/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.currency.internal.util;

import com.liferay.commerce.currency.configuration.RoundingTypeConfiguration;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.commerce.currency.configuration.RoundingTypeConfiguration"}, enabled=false, immediate=true, service={CommercePriceFormatter.class})
public class CommercePriceFormatterImpl
implements CommercePriceFormatter {
    private volatile RoundingTypeConfiguration _roundingTypeConfiguration;

    public String format(BigDecimal price, Locale locale) throws PortalException {
        DecimalFormat decimalFormat = this._getDecimalFormat(null, locale);
        return decimalFormat.format(price);
    }

    public String format(CommerceCurrency commerceCurrency, BigDecimal price, Locale locale) throws PortalException {
        DecimalFormat decimalFormat = this._getDecimalFormat(commerceCurrency, locale);
        return decimalFormat.format(price);
    }

    public String formatAsRelative(CommerceCurrency commerceCurrency, BigDecimal relativePrice, Locale locale) {
        if (relativePrice.signum() == 0) {
            return "";
        }
        DecimalFormat decimalFormat = this._getDecimalFormat(commerceCurrency, locale);
        if (relativePrice.signum() == -1) {
            return String.format("%2s %s", "-", decimalFormat.format(relativePrice.negate()));
        }
        return String.format("%2s %s", "+", decimalFormat.format(relativePrice));
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._roundingTypeConfiguration = (RoundingTypeConfiguration)ConfigurableUtil.createConfigurable(RoundingTypeConfiguration.class, properties);
    }

    @Deactivate
    protected void deactivate() {
        this._roundingTypeConfiguration = null;
    }

    private DecimalFormat _getDecimalFormat(CommerceCurrency commerceCurrency, Locale locale) {
        String formatPattern = "###,##0.00";
        int maxFractionDigits = this._roundingTypeConfiguration.maximumFractionDigits();
        int minFractionDigits = this._roundingTypeConfiguration.minimumFractionDigits();
        RoundingMode roundingMode = this._roundingTypeConfiguration.roundingMode();
        if (commerceCurrency != null) {
            formatPattern = commerceCurrency.getFormatPattern(locale);
            if (Validator.isNull((String)formatPattern)) {
                formatPattern = commerceCurrency.getFormatPattern(commerceCurrency.getDefaultLanguageId());
            }
            maxFractionDigits = commerceCurrency.getMaxFractionDigits();
            minFractionDigits = commerceCurrency.getMinFractionDigits();
            roundingMode = RoundingMode.valueOf(commerceCurrency.getRoundingMode());
        }
        DecimalFormat decimalFormat = new DecimalFormat(formatPattern, DecimalFormatSymbols.getInstance(locale));
        decimalFormat.setMaximumFractionDigits(maxFractionDigits);
        decimalFormat.setMinimumFractionDigits(minFractionDigits);
        decimalFormat.setRoundingMode(roundingMode);
        return decimalFormat;
    }
}

