/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.currency.internal.util;

import com.liferay.commerce.currency.internal.configuration.ECBExchangeRateProviderConfiguration;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.util.ExchangeRateProvider;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.currency.internal.configuration.ECBExchangeRateProviderConfiguration"}, enabled=false, immediate=true, property={"commerce.exchange.provider.key=european-central-bank"}, service={ExchangeRateProvider.class})
public class ECBExchangeRateProvider
implements ExchangeRateProvider {
    private volatile Map<String, BigDecimal> _currencyRates;
    private volatile long _expirationTime;
    @Reference
    private Http _http;
    @Reference
    private SAXReader _saxReader;
    private volatile long _timeStamp;
    private volatile String _url;

    public BigDecimal getExchangeRate(CommerceCurrency primaryCommerceCurrency, CommerceCurrency secondaryCommerceCurrency) throws Exception {
        Map<String, BigDecimal> currencyRates = this._getCurrencyRates();
        String primaryCurrencyCode = StringUtil.toUpperCase((String)primaryCommerceCurrency.getCode());
        String secondaryCurrencyCode = StringUtil.toUpperCase((String)secondaryCommerceCurrency.getCode());
        BigDecimal rateToPrimary = currencyRates.getOrDefault(primaryCurrencyCode, BigDecimal.ZERO);
        BigDecimal rateToSecondary = currencyRates.getOrDefault(secondaryCurrencyCode, BigDecimal.ZERO);
        if (primaryCurrencyCode.equals("EUR")) {
            rateToPrimary = BigDecimal.ONE;
        }
        if (secondaryCurrencyCode.equals("EUR")) {
            rateToSecondary = BigDecimal.ONE;
        }
        return rateToSecondary.divide(rateToPrimary, 4, RoundingMode.HALF_EVEN);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        ECBExchangeRateProviderConfiguration ecbExchangeRateProviderConfiguration = (ECBExchangeRateProviderConfiguration)ConfigurableUtil.createConfigurable(ECBExchangeRateProviderConfiguration.class, properties);
        this._url = ecbExchangeRateProviderConfiguration.europeanCentralBankURL();
        this._expirationTime = TimeUnit.SECONDS.toMillis(ecbExchangeRateProviderConfiguration.europeanCentralBankURLCacheExpirationTime());
        this._timeStamp = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, BigDecimal> _getCurrencyRates() throws Exception {
        long currentTime = System.currentTimeMillis();
        long timestamp = currentTime - this._expirationTime;
        if (timestamp < this._timeStamp) {
            return this._currencyRates;
        }
        ECBExchangeRateProvider eCBExchangeRateProvider = this;
        synchronized (eCBExchangeRateProvider) {
            if (timestamp < this._timeStamp) {
                return this._currencyRates;
            }
            Document document = null;
            int i = 0;
            while (document == null) {
                block9: {
                    try {
                        document = this._saxReader.read(this._http.URLtoString(this._getURL()));
                    }
                    catch (IOException ioException) {
                        if (i++ < 10) break block9;
                        throw ioException;
                    }
                }
                if (i < 10) continue;
                throw new PortalException("Impossible to load " + this._url);
            }
            Element rootElement = document.getRootElement();
            List rootCubeElements = rootElement.elements("Cube");
            Element rootCubeElement = (Element)rootCubeElements.get(0);
            List cubeParentElements = rootCubeElement.elements("Cube");
            Element cubeParentElement = (Element)cubeParentElements.get(0);
            List cubeElements = cubeParentElement.elements("Cube");
            HashMap<String, BigDecimal> currencyRates = new HashMap<String, BigDecimal>();
            for (Element cubeElement : cubeElements) {
                currencyRates.put(cubeElement.attributeValue("currency"), new BigDecimal(cubeElement.attributeValue("rate")));
            }
            this._currencyRates = currencyRates;
            this._timeStamp = currentTime;
            return this._currencyRates;
        }
    }

    private URL _getURL() throws Exception {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        URL url = classLoader.getResource(this._url);
        if (url == null && this._isLocalNetworkURL(url = new URL(this._url))) {
            throw new PortalException("Invalid European Central Bank URL: " + url);
        }
        return url;
    }

    private boolean _isLocalNetworkURL(URL url) throws Exception {
        return InetAddressUtil.isLocalInetAddress((InetAddress)InetAddressUtil.getInetAddressByName((String)url.getHost()));
    }
}

