/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.currency.model.impl;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceCurrency service. Represents a row in the &quot;CommerceCurrency&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceCurrencyImpl}.
 * </p>
 *
 * @author Andrea Di Giorgi
 * @see CommerceCurrencyImpl
 * @see CommerceCurrency
 * @generated
 */
public abstract class CommerceCurrencyBaseImpl
	extends CommerceCurrencyModelImpl implements CommerceCurrency {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce currency model instance should use the <code>CommerceCurrency</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceCurrencyLocalServiceUtil.addCommerceCurrency(this);
		}
		else {
			CommerceCurrencyLocalServiceUtil.updateCommerceCurrency(this);
		}
	}

}