/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.currency.internal.model;

import com.liferay.commerce.currency.internal.model.CommerceMoneyImpl;
import com.liferay.commerce.currency.internal.model.RelativeCommerceMoneyImpl;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.currency.model.CommerceMoneyFactoryUtil;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.commerce.currency.util.PriceFormat;
import com.liferay.portal.kernel.exception.PortalException;
import java.math.BigDecimal;
import java.util.Locale;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceMoneyFactory.class})
public class CommerceMoneyFactoryImpl
implements CommerceMoneyFactory {
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CommercePriceFormatter _commercePriceFormatter;
    private CommerceMoney _emptyCommerceMoney;
    private CommerceMoney _priceOnApplicationCommerceMoney;

    public CommerceMoney create(CommerceCurrency commerceCurrency, BigDecimal price) {
        return new CommerceMoneyImpl(commerceCurrency, this._commercePriceFormatter, price);
    }

    public CommerceMoney create(CommerceCurrency commerceCurrency, BigDecimal price, PriceFormat priceFormat) {
        if (priceFormat == null) {
            throw new IllegalArgumentException("Price format must not be null");
        }
        CommerceMoneyImpl commerceMoney = new CommerceMoneyImpl(commerceCurrency, this._commercePriceFormatter, price);
        if (priceFormat == PriceFormat.RELATIVE) {
            commerceMoney = new RelativeCommerceMoneyImpl(commerceCurrency, this._commercePriceFormatter, price);
        }
        return commerceMoney;
    }

    public CommerceMoney create(long commerceCurrencyId, BigDecimal price) throws PortalException {
        return this.create(this._commerceCurrencyLocalService.getCommerceCurrency(commerceCurrencyId), price);
    }

    public CommerceMoney emptyCommerceMoney() {
        if (this._emptyCommerceMoney != null) {
            return this._emptyCommerceMoney;
        }
        this._emptyCommerceMoney = new CommerceMoney(){

            public String format(Locale locale) throws PortalException {
                return CommerceMoneyFactoryImpl.this._commercePriceFormatter.format(BigDecimal.ZERO, locale);
            }

            public CommerceCurrency getCommerceCurrency() {
                throw new UnsupportedOperationException();
            }

            public BigDecimal getPrice() {
                return BigDecimal.ZERO;
            }

            public boolean isEmpty() {
                return true;
            }

            public boolean isPriceOnApplication() {
                return false;
            }
        };
        return this._emptyCommerceMoney;
    }

    public CommerceMoney priceOnApplicationCommerceMoney() {
        if (this._priceOnApplicationCommerceMoney != null) {
            return this._priceOnApplicationCommerceMoney;
        }
        this._priceOnApplicationCommerceMoney = new CommerceMoney(){

            public String format(Locale locale) throws PortalException {
                return CommerceMoneyFactoryImpl.this._commercePriceFormatter.format(BigDecimal.ZERO, locale);
            }

            public CommerceCurrency getCommerceCurrency() {
                return null;
            }

            public BigDecimal getPrice() {
                return BigDecimal.ZERO;
            }

            public boolean isEmpty() {
                return true;
            }

            public boolean isPriceOnApplication() {
                return true;
            }
        };
        return this._priceOnApplicationCommerceMoney;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        CommerceMoneyFactoryUtil.setCommerceMoneyFactory((CommerceMoneyFactory)this);
    }
}

