/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.currency.internal.model;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.portal.kernel.exception.PortalException;
import java.math.BigDecimal;
import java.util.Locale;

public class CommerceMoneyImpl
implements CommerceMoney {
    private final CommerceCurrency _commerceCurrency;
    private final CommercePriceFormatter _commercePriceFormatter;
    private final BigDecimal _price;
    private final boolean _priceOnApplication;

    public CommerceMoneyImpl(CommerceCurrency commerceCurrency, CommercePriceFormatter commercePriceFormatter, BigDecimal price) {
        this._commerceCurrency = commerceCurrency;
        this._commercePriceFormatter = commercePriceFormatter;
        this._price = price;
        this._priceOnApplication = false;
    }

    public String format(Locale locale) throws PortalException {
        BigDecimal price = this.getPrice();
        if (price == null) {
            price = BigDecimal.ZERO;
        }
        return this._commercePriceFormatter.format(this.getCommerceCurrency(), price, locale);
    }

    public CommerceCurrency getCommerceCurrency() {
        return this._commerceCurrency;
    }

    public BigDecimal getPrice() {
        return this._price;
    }

    public boolean isEmpty() {
        return this._price == null;
    }

    public boolean isPriceOnApplication() {
        return this._priceOnApplication;
    }

    protected CommercePriceFormatter getCommercePriceFormatter() {
        return this._commercePriceFormatter;
    }
}

