/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.currency.internal.model.listener.util;

import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Locale;

public class ImportDefaultValuesUtil {
    public static void importDefaultValues(CommerceCurrencyLocalService commerceCurrencyLocalService, Company company) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Locale defaultLocale = LocaleThreadLocal.getDefaultLocale();
            Locale siteDefaultLocale = LocaleThreadLocal.getSiteDefaultLocale();
            try {
                LocaleThreadLocal.setDefaultLocale((Locale)company.getLocale());
                LocaleThreadLocal.setSiteDefaultLocale(null);
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCompanyId(company.getCompanyId());
                serviceContext.setLanguageId(LocaleUtil.toLanguageId((Locale)company.getLocale()));
                User guestUser = company.getGuestUser();
                serviceContext.setUserId(guestUser.getUserId());
                commerceCurrencyLocalService.importDefaultValues(false, serviceContext);
                Object var6_6 = null;
                return var6_6;
            }
            finally {
                LocaleThreadLocal.setDefaultLocale((Locale)defaultLocale);
                LocaleThreadLocal.setSiteDefaultLocale((Locale)siteDefaultLocale);
            }
        });
    }
}

