/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.currency.internal.model.listener;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={PortalInstanceLifecycleListener.class})
public class PortalInstanceLifecycleListenerImpl
extends BasePortalInstanceLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(PortalInstanceLifecycleListenerImpl.class);
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;

    public void portalInstanceRegistered(Company company) throws Exception {
        try {
            CommerceCurrency commerceCurrency = this._commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(company.getCompanyId());
            if (commerceCurrency != null) {
                return;
            }
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(company.getCompanyId());
            serviceContext.setLanguageId(LocaleUtil.toLanguageId((Locale)company.getLocale()));
            User defaultUser = company.getDefaultUser();
            serviceContext.setUserId(defaultUser.getUserId());
            this._commerceCurrencyLocalService.importDefaultValues(serviceContext);
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
        }
    }
}

