/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.discount.model.impl;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.math.BigDecimal;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceDiscount service. Represents a row in the &quot;CommerceDiscount&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceDiscountModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceDiscountImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see CommerceDiscountImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceDiscountModelImpl
	extends BaseModelImpl<CommerceDiscount> implements CommerceDiscountModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce discount model instance should use the <code>CommerceDiscount</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceDiscount";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"externalReferenceCode", Types.VARCHAR},
		{"commerceDiscountId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"title", Types.VARCHAR}, {"target", Types.VARCHAR},
		{"useCouponCode", Types.BOOLEAN}, {"couponCode", Types.VARCHAR},
		{"usePercentage", Types.BOOLEAN},
		{"maximumDiscountAmount", Types.DECIMAL}, {"levelType", Types.VARCHAR},
		{"level1", Types.DECIMAL}, {"level2", Types.DECIMAL},
		{"level3", Types.DECIMAL}, {"level4", Types.DECIMAL},
		{"limitationType", Types.VARCHAR}, {"limitationTimes", Types.INTEGER},
		{"limitationTimesPerAccount", Types.INTEGER},
		{"numberOfUse", Types.INTEGER}, {"rulesConjunction", Types.BOOLEAN},
		{"active_", Types.BOOLEAN}, {"displayDate", Types.TIMESTAMP},
		{"expirationDate", Types.TIMESTAMP},
		{"lastPublishDate", Types.TIMESTAMP}, {"status", Types.INTEGER},
		{"statusByUserId", Types.BIGINT}, {"statusByUserName", Types.VARCHAR},
		{"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceDiscountId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("title", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("target", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("useCouponCode", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("couponCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("usePercentage", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("maximumDiscountAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("levelType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("level1", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("level2", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("level3", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("level4", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("limitationType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("limitationTimes", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("limitationTimesPerAccount", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("numberOfUse", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("rulesConjunction", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("active_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("displayDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("expirationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceDiscount (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,commerceDiscountId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,title VARCHAR(75) null,target VARCHAR(75) null,useCouponCode BOOLEAN,couponCode VARCHAR(75) null,usePercentage BOOLEAN,maximumDiscountAmount DECIMAL(30, 16) null,levelType VARCHAR(75) null,level1 DECIMAL(30, 16) null,level2 DECIMAL(30, 16) null,level3 DECIMAL(30, 16) null,level4 DECIMAL(30, 16) null,limitationType VARCHAR(75) null,limitationTimes INTEGER,limitationTimesPerAccount INTEGER,numberOfUse INTEGER,rulesConjunction BOOLEAN,active_ BOOLEAN,displayDate DATE null,expirationDate DATE null,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table CommerceDiscount";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceDiscount.createDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceDiscount.createDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ACTIVE_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COUPONCODE_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DISPLAYDATE_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXPIRATIONDATE_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LEVEL_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public CommerceDiscountModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceDiscountId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceDiscountId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceDiscountId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceDiscount.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceDiscount.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceDiscount, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceDiscount, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceDiscount, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommerceDiscount)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceDiscount, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceDiscount, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceDiscount)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceDiscount, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceDiscount, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<CommerceDiscount, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<CommerceDiscount, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommerceDiscount, Object>>
			attributeGetterFunctions =
				new LinkedHashMap<String, Function<CommerceDiscount, Object>>();
		Map<String, BiConsumer<CommerceDiscount, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<CommerceDiscount, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", CommerceDiscount::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<CommerceDiscount, Long>)
				CommerceDiscount::setMvccVersion);
		attributeGetterFunctions.put("uuid", CommerceDiscount::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<CommerceDiscount, String>)CommerceDiscount::setUuid);
		attributeGetterFunctions.put(
			"externalReferenceCode",
			CommerceDiscount::getExternalReferenceCode);
		attributeSetterBiConsumers.put(
			"externalReferenceCode",
			(BiConsumer<CommerceDiscount, String>)
				CommerceDiscount::setExternalReferenceCode);
		attributeGetterFunctions.put(
			"commerceDiscountId", CommerceDiscount::getCommerceDiscountId);
		attributeSetterBiConsumers.put(
			"commerceDiscountId",
			(BiConsumer<CommerceDiscount, Long>)
				CommerceDiscount::setCommerceDiscountId);
		attributeGetterFunctions.put(
			"companyId", CommerceDiscount::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<CommerceDiscount, Long>)CommerceDiscount::setCompanyId);
		attributeGetterFunctions.put("userId", CommerceDiscount::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<CommerceDiscount, Long>)CommerceDiscount::setUserId);
		attributeGetterFunctions.put("userName", CommerceDiscount::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<CommerceDiscount, String>)
				CommerceDiscount::setUserName);
		attributeGetterFunctions.put(
			"createDate", CommerceDiscount::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<CommerceDiscount, Date>)
				CommerceDiscount::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", CommerceDiscount::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<CommerceDiscount, Date>)
				CommerceDiscount::setModifiedDate);
		attributeGetterFunctions.put("title", CommerceDiscount::getTitle);
		attributeSetterBiConsumers.put(
			"title",
			(BiConsumer<CommerceDiscount, String>)CommerceDiscount::setTitle);
		attributeGetterFunctions.put("target", CommerceDiscount::getTarget);
		attributeSetterBiConsumers.put(
			"target",
			(BiConsumer<CommerceDiscount, String>)CommerceDiscount::setTarget);
		attributeGetterFunctions.put(
			"useCouponCode", CommerceDiscount::getUseCouponCode);
		attributeSetterBiConsumers.put(
			"useCouponCode",
			(BiConsumer<CommerceDiscount, Boolean>)
				CommerceDiscount::setUseCouponCode);
		attributeGetterFunctions.put(
			"couponCode", CommerceDiscount::getCouponCode);
		attributeSetterBiConsumers.put(
			"couponCode",
			(BiConsumer<CommerceDiscount, String>)
				CommerceDiscount::setCouponCode);
		attributeGetterFunctions.put(
			"usePercentage", CommerceDiscount::getUsePercentage);
		attributeSetterBiConsumers.put(
			"usePercentage",
			(BiConsumer<CommerceDiscount, Boolean>)
				CommerceDiscount::setUsePercentage);
		attributeGetterFunctions.put(
			"maximumDiscountAmount",
			CommerceDiscount::getMaximumDiscountAmount);
		attributeSetterBiConsumers.put(
			"maximumDiscountAmount",
			(BiConsumer<CommerceDiscount, BigDecimal>)
				CommerceDiscount::setMaximumDiscountAmount);
		attributeGetterFunctions.put("level", CommerceDiscount::getLevel);
		attributeSetterBiConsumers.put(
			"level",
			(BiConsumer<CommerceDiscount, String>)CommerceDiscount::setLevel);
		attributeGetterFunctions.put("level1", CommerceDiscount::getLevel1);
		attributeSetterBiConsumers.put(
			"level1",
			(BiConsumer<CommerceDiscount, BigDecimal>)
				CommerceDiscount::setLevel1);
		attributeGetterFunctions.put("level2", CommerceDiscount::getLevel2);
		attributeSetterBiConsumers.put(
			"level2",
			(BiConsumer<CommerceDiscount, BigDecimal>)
				CommerceDiscount::setLevel2);
		attributeGetterFunctions.put("level3", CommerceDiscount::getLevel3);
		attributeSetterBiConsumers.put(
			"level3",
			(BiConsumer<CommerceDiscount, BigDecimal>)
				CommerceDiscount::setLevel3);
		attributeGetterFunctions.put("level4", CommerceDiscount::getLevel4);
		attributeSetterBiConsumers.put(
			"level4",
			(BiConsumer<CommerceDiscount, BigDecimal>)
				CommerceDiscount::setLevel4);
		attributeGetterFunctions.put(
			"limitationType", CommerceDiscount::getLimitationType);
		attributeSetterBiConsumers.put(
			"limitationType",
			(BiConsumer<CommerceDiscount, String>)
				CommerceDiscount::setLimitationType);
		attributeGetterFunctions.put(
			"limitationTimes", CommerceDiscount::getLimitationTimes);
		attributeSetterBiConsumers.put(
			"limitationTimes",
			(BiConsumer<CommerceDiscount, Integer>)
				CommerceDiscount::setLimitationTimes);
		attributeGetterFunctions.put(
			"limitationTimesPerAccount",
			CommerceDiscount::getLimitationTimesPerAccount);
		attributeSetterBiConsumers.put(
			"limitationTimesPerAccount",
			(BiConsumer<CommerceDiscount, Integer>)
				CommerceDiscount::setLimitationTimesPerAccount);
		attributeGetterFunctions.put(
			"numberOfUse", CommerceDiscount::getNumberOfUse);
		attributeSetterBiConsumers.put(
			"numberOfUse",
			(BiConsumer<CommerceDiscount, Integer>)
				CommerceDiscount::setNumberOfUse);
		attributeGetterFunctions.put(
			"rulesConjunction", CommerceDiscount::getRulesConjunction);
		attributeSetterBiConsumers.put(
			"rulesConjunction",
			(BiConsumer<CommerceDiscount, Boolean>)
				CommerceDiscount::setRulesConjunction);
		attributeGetterFunctions.put("active", CommerceDiscount::getActive);
		attributeSetterBiConsumers.put(
			"active",
			(BiConsumer<CommerceDiscount, Boolean>)CommerceDiscount::setActive);
		attributeGetterFunctions.put(
			"displayDate", CommerceDiscount::getDisplayDate);
		attributeSetterBiConsumers.put(
			"displayDate",
			(BiConsumer<CommerceDiscount, Date>)
				CommerceDiscount::setDisplayDate);
		attributeGetterFunctions.put(
			"expirationDate", CommerceDiscount::getExpirationDate);
		attributeSetterBiConsumers.put(
			"expirationDate",
			(BiConsumer<CommerceDiscount, Date>)
				CommerceDiscount::setExpirationDate);
		attributeGetterFunctions.put(
			"lastPublishDate", CommerceDiscount::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<CommerceDiscount, Date>)
				CommerceDiscount::setLastPublishDate);
		attributeGetterFunctions.put("status", CommerceDiscount::getStatus);
		attributeSetterBiConsumers.put(
			"status",
			(BiConsumer<CommerceDiscount, Integer>)CommerceDiscount::setStatus);
		attributeGetterFunctions.put(
			"statusByUserId", CommerceDiscount::getStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<CommerceDiscount, Long>)
				CommerceDiscount::setStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName", CommerceDiscount::getStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<CommerceDiscount, String>)
				CommerceDiscount::setStatusByUserName);
		attributeGetterFunctions.put(
			"statusDate", CommerceDiscount::getStatusDate);
		attributeSetterBiConsumers.put(
			"statusDate",
			(BiConsumer<CommerceDiscount, Date>)
				CommerceDiscount::setStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getCommerceDiscountId() {
		return _commerceDiscountId;
	}

	@Override
	public void setCommerceDiscountId(long commerceDiscountId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceDiscountId = commerceDiscountId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getTitle() {
		if (_title == null) {
			return "";
		}
		else {
			return _title;
		}
	}

	@Override
	public void setTitle(String title) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_title = title;
	}

	@JSON
	@Override
	public String getTarget() {
		if (_target == null) {
			return "";
		}
		else {
			return _target;
		}
	}

	@Override
	public void setTarget(String target) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_target = target;
	}

	@JSON
	@Override
	public boolean getUseCouponCode() {
		return _useCouponCode;
	}

	@JSON
	@Override
	public boolean isUseCouponCode() {
		return _useCouponCode;
	}

	@Override
	public void setUseCouponCode(boolean useCouponCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_useCouponCode = useCouponCode;
	}

	@JSON
	@Override
	public String getCouponCode() {
		if (_couponCode == null) {
			return "";
		}
		else {
			return _couponCode;
		}
	}

	@Override
	public void setCouponCode(String couponCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_couponCode = couponCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalCouponCode() {
		return getColumnOriginalValue("couponCode");
	}

	@JSON
	@Override
	public boolean getUsePercentage() {
		return _usePercentage;
	}

	@JSON
	@Override
	public boolean isUsePercentage() {
		return _usePercentage;
	}

	@Override
	public void setUsePercentage(boolean usePercentage) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_usePercentage = usePercentage;
	}

	@JSON
	@Override
	public BigDecimal getMaximumDiscountAmount() {
		return _maximumDiscountAmount;
	}

	@Override
	public void setMaximumDiscountAmount(BigDecimal maximumDiscountAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_maximumDiscountAmount = maximumDiscountAmount;
	}

	@JSON
	@Override
	public String getLevel() {
		if (_level == null) {
			return "";
		}
		else {
			return _level;
		}
	}

	@Override
	public void setLevel(String level) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_level = level;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalLevel() {
		return getColumnOriginalValue("levelType");
	}

	@JSON
	@Override
	public BigDecimal getLevel1() {
		return _level1;
	}

	@Override
	public void setLevel1(BigDecimal level1) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_level1 = level1;
	}

	@JSON
	@Override
	public BigDecimal getLevel2() {
		return _level2;
	}

	@Override
	public void setLevel2(BigDecimal level2) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_level2 = level2;
	}

	@JSON
	@Override
	public BigDecimal getLevel3() {
		return _level3;
	}

	@Override
	public void setLevel3(BigDecimal level3) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_level3 = level3;
	}

	@JSON
	@Override
	public BigDecimal getLevel4() {
		return _level4;
	}

	@Override
	public void setLevel4(BigDecimal level4) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_level4 = level4;
	}

	@JSON
	@Override
	public String getLimitationType() {
		if (_limitationType == null) {
			return "";
		}
		else {
			return _limitationType;
		}
	}

	@Override
	public void setLimitationType(String limitationType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_limitationType = limitationType;
	}

	@JSON
	@Override
	public int getLimitationTimes() {
		return _limitationTimes;
	}

	@Override
	public void setLimitationTimes(int limitationTimes) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_limitationTimes = limitationTimes;
	}

	@JSON
	@Override
	public int getLimitationTimesPerAccount() {
		return _limitationTimesPerAccount;
	}

	@Override
	public void setLimitationTimesPerAccount(int limitationTimesPerAccount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_limitationTimesPerAccount = limitationTimesPerAccount;
	}

	@JSON
	@Override
	public int getNumberOfUse() {
		return _numberOfUse;
	}

	@Override
	public void setNumberOfUse(int numberOfUse) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_numberOfUse = numberOfUse;
	}

	@JSON
	@Override
	public boolean getRulesConjunction() {
		return _rulesConjunction;
	}

	@JSON
	@Override
	public boolean isRulesConjunction() {
		return _rulesConjunction;
	}

	@Override
	public void setRulesConjunction(boolean rulesConjunction) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_rulesConjunction = rulesConjunction;
	}

	@JSON
	@Override
	public boolean getActive() {
		return _active;
	}

	@JSON
	@Override
	public boolean isActive() {
		return _active;
	}

	@Override
	public void setActive(boolean active) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_active = active;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalActive() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("active_"));
	}

	@JSON
	@Override
	public Date getDisplayDate() {
		return _displayDate;
	}

	@Override
	public void setDisplayDate(Date displayDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_displayDate = displayDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalDisplayDate() {
		return getColumnOriginalValue("displayDate");
	}

	@JSON
	@Override
	public Date getExpirationDate() {
		return _expirationDate;
	}

	@Override
	public void setExpirationDate(Date expirationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_expirationDate = expirationDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalExpirationDate() {
		return getColumnOriginalValue("expirationDate");
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(CommerceDiscount.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceDiscount.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceDiscount toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceDiscount>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceDiscountImpl commerceDiscountImpl = new CommerceDiscountImpl();

		commerceDiscountImpl.setMvccVersion(getMvccVersion());
		commerceDiscountImpl.setUuid(getUuid());
		commerceDiscountImpl.setExternalReferenceCode(
			getExternalReferenceCode());
		commerceDiscountImpl.setCommerceDiscountId(getCommerceDiscountId());
		commerceDiscountImpl.setCompanyId(getCompanyId());
		commerceDiscountImpl.setUserId(getUserId());
		commerceDiscountImpl.setUserName(getUserName());
		commerceDiscountImpl.setCreateDate(getCreateDate());
		commerceDiscountImpl.setModifiedDate(getModifiedDate());
		commerceDiscountImpl.setTitle(getTitle());
		commerceDiscountImpl.setTarget(getTarget());
		commerceDiscountImpl.setUseCouponCode(isUseCouponCode());
		commerceDiscountImpl.setCouponCode(getCouponCode());
		commerceDiscountImpl.setUsePercentage(isUsePercentage());
		commerceDiscountImpl.setMaximumDiscountAmount(
			getMaximumDiscountAmount());
		commerceDiscountImpl.setLevel(getLevel());
		commerceDiscountImpl.setLevel1(getLevel1());
		commerceDiscountImpl.setLevel2(getLevel2());
		commerceDiscountImpl.setLevel3(getLevel3());
		commerceDiscountImpl.setLevel4(getLevel4());
		commerceDiscountImpl.setLimitationType(getLimitationType());
		commerceDiscountImpl.setLimitationTimes(getLimitationTimes());
		commerceDiscountImpl.setLimitationTimesPerAccount(
			getLimitationTimesPerAccount());
		commerceDiscountImpl.setNumberOfUse(getNumberOfUse());
		commerceDiscountImpl.setRulesConjunction(isRulesConjunction());
		commerceDiscountImpl.setActive(isActive());
		commerceDiscountImpl.setDisplayDate(getDisplayDate());
		commerceDiscountImpl.setExpirationDate(getExpirationDate());
		commerceDiscountImpl.setLastPublishDate(getLastPublishDate());
		commerceDiscountImpl.setStatus(getStatus());
		commerceDiscountImpl.setStatusByUserId(getStatusByUserId());
		commerceDiscountImpl.setStatusByUserName(getStatusByUserName());
		commerceDiscountImpl.setStatusDate(getStatusDate());

		commerceDiscountImpl.resetOriginalValues();

		return commerceDiscountImpl;
	}

	@Override
	public CommerceDiscount cloneWithOriginalValues() {
		CommerceDiscountImpl commerceDiscountImpl = new CommerceDiscountImpl();

		commerceDiscountImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		commerceDiscountImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		commerceDiscountImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		commerceDiscountImpl.setCommerceDiscountId(
			this.<Long>getColumnOriginalValue("commerceDiscountId"));
		commerceDiscountImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		commerceDiscountImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		commerceDiscountImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		commerceDiscountImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		commerceDiscountImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		commerceDiscountImpl.setTitle(
			this.<String>getColumnOriginalValue("title"));
		commerceDiscountImpl.setTarget(
			this.<String>getColumnOriginalValue("target"));
		commerceDiscountImpl.setUseCouponCode(
			this.<Boolean>getColumnOriginalValue("useCouponCode"));
		commerceDiscountImpl.setCouponCode(
			this.<String>getColumnOriginalValue("couponCode"));
		commerceDiscountImpl.setUsePercentage(
			this.<Boolean>getColumnOriginalValue("usePercentage"));
		commerceDiscountImpl.setMaximumDiscountAmount(
			this.<BigDecimal>getColumnOriginalValue("maximumDiscountAmount"));
		commerceDiscountImpl.setLevel(
			this.<String>getColumnOriginalValue("levelType"));
		commerceDiscountImpl.setLevel1(
			this.<BigDecimal>getColumnOriginalValue("level1"));
		commerceDiscountImpl.setLevel2(
			this.<BigDecimal>getColumnOriginalValue("level2"));
		commerceDiscountImpl.setLevel3(
			this.<BigDecimal>getColumnOriginalValue("level3"));
		commerceDiscountImpl.setLevel4(
			this.<BigDecimal>getColumnOriginalValue("level4"));
		commerceDiscountImpl.setLimitationType(
			this.<String>getColumnOriginalValue("limitationType"));
		commerceDiscountImpl.setLimitationTimes(
			this.<Integer>getColumnOriginalValue("limitationTimes"));
		commerceDiscountImpl.setLimitationTimesPerAccount(
			this.<Integer>getColumnOriginalValue("limitationTimesPerAccount"));
		commerceDiscountImpl.setNumberOfUse(
			this.<Integer>getColumnOriginalValue("numberOfUse"));
		commerceDiscountImpl.setRulesConjunction(
			this.<Boolean>getColumnOriginalValue("rulesConjunction"));
		commerceDiscountImpl.setActive(
			this.<Boolean>getColumnOriginalValue("active_"));
		commerceDiscountImpl.setDisplayDate(
			this.<Date>getColumnOriginalValue("displayDate"));
		commerceDiscountImpl.setExpirationDate(
			this.<Date>getColumnOriginalValue("expirationDate"));
		commerceDiscountImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));
		commerceDiscountImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));
		commerceDiscountImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		commerceDiscountImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		commerceDiscountImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return commerceDiscountImpl;
	}

	@Override
	public int compareTo(CommerceDiscount commerceDiscount) {
		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), commerceDiscount.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceDiscount)) {
			return false;
		}

		CommerceDiscount commerceDiscount = (CommerceDiscount)object;

		long primaryKey = commerceDiscount.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceDiscount> toCacheModel() {
		CommerceDiscountCacheModel commerceDiscountCacheModel =
			new CommerceDiscountCacheModel();

		commerceDiscountCacheModel.mvccVersion = getMvccVersion();

		commerceDiscountCacheModel.uuid = getUuid();

		String uuid = commerceDiscountCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commerceDiscountCacheModel.uuid = null;
		}

		commerceDiscountCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			commerceDiscountCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			commerceDiscountCacheModel.externalReferenceCode = null;
		}

		commerceDiscountCacheModel.commerceDiscountId = getCommerceDiscountId();

		commerceDiscountCacheModel.companyId = getCompanyId();

		commerceDiscountCacheModel.userId = getUserId();

		commerceDiscountCacheModel.userName = getUserName();

		String userName = commerceDiscountCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceDiscountCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceDiscountCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceDiscountCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceDiscountCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceDiscountCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceDiscountCacheModel.title = getTitle();

		String title = commerceDiscountCacheModel.title;

		if ((title != null) && (title.length() == 0)) {
			commerceDiscountCacheModel.title = null;
		}

		commerceDiscountCacheModel.target = getTarget();

		String target = commerceDiscountCacheModel.target;

		if ((target != null) && (target.length() == 0)) {
			commerceDiscountCacheModel.target = null;
		}

		commerceDiscountCacheModel.useCouponCode = isUseCouponCode();

		commerceDiscountCacheModel.couponCode = getCouponCode();

		String couponCode = commerceDiscountCacheModel.couponCode;

		if ((couponCode != null) && (couponCode.length() == 0)) {
			commerceDiscountCacheModel.couponCode = null;
		}

		commerceDiscountCacheModel.usePercentage = isUsePercentage();

		commerceDiscountCacheModel.maximumDiscountAmount =
			getMaximumDiscountAmount();

		commerceDiscountCacheModel.level = getLevel();

		String level = commerceDiscountCacheModel.level;

		if ((level != null) && (level.length() == 0)) {
			commerceDiscountCacheModel.level = null;
		}

		commerceDiscountCacheModel.level1 = getLevel1();

		commerceDiscountCacheModel.level2 = getLevel2();

		commerceDiscountCacheModel.level3 = getLevel3();

		commerceDiscountCacheModel.level4 = getLevel4();

		commerceDiscountCacheModel.limitationType = getLimitationType();

		String limitationType = commerceDiscountCacheModel.limitationType;

		if ((limitationType != null) && (limitationType.length() == 0)) {
			commerceDiscountCacheModel.limitationType = null;
		}

		commerceDiscountCacheModel.limitationTimes = getLimitationTimes();

		commerceDiscountCacheModel.limitationTimesPerAccount =
			getLimitationTimesPerAccount();

		commerceDiscountCacheModel.numberOfUse = getNumberOfUse();

		commerceDiscountCacheModel.rulesConjunction = isRulesConjunction();

		commerceDiscountCacheModel.active = isActive();

		Date displayDate = getDisplayDate();

		if (displayDate != null) {
			commerceDiscountCacheModel.displayDate = displayDate.getTime();
		}
		else {
			commerceDiscountCacheModel.displayDate = Long.MIN_VALUE;
		}

		Date expirationDate = getExpirationDate();

		if (expirationDate != null) {
			commerceDiscountCacheModel.expirationDate =
				expirationDate.getTime();
		}
		else {
			commerceDiscountCacheModel.expirationDate = Long.MIN_VALUE;
		}

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			commerceDiscountCacheModel.lastPublishDate =
				lastPublishDate.getTime();
		}
		else {
			commerceDiscountCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		commerceDiscountCacheModel.status = getStatus();

		commerceDiscountCacheModel.statusByUserId = getStatusByUserId();

		commerceDiscountCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = commerceDiscountCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			commerceDiscountCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			commerceDiscountCacheModel.statusDate = statusDate.getTime();
		}
		else {
			commerceDiscountCacheModel.statusDate = Long.MIN_VALUE;
		}

		return commerceDiscountCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceDiscount, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceDiscount, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceDiscount, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommerceDiscount)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceDiscount, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceDiscount, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceDiscount, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((CommerceDiscount)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CommerceDiscount>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					CommerceDiscount.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private String _externalReferenceCode;
	private long _commerceDiscountId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _title;
	private String _target;
	private boolean _useCouponCode;
	private String _couponCode;
	private boolean _usePercentage;
	private BigDecimal _maximumDiscountAmount;
	private String _level;
	private BigDecimal _level1;
	private BigDecimal _level2;
	private BigDecimal _level3;
	private BigDecimal _level4;
	private String _limitationType;
	private int _limitationTimes;
	private int _limitationTimesPerAccount;
	private int _numberOfUse;
	private boolean _rulesConjunction;
	private boolean _active;
	private Date _displayDate;
	private Date _expirationDate;
	private Date _lastPublishDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommerceDiscount, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommerceDiscount)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("commerceDiscountId", _commerceDiscountId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("title", _title);
		_columnOriginalValues.put("target", _target);
		_columnOriginalValues.put("useCouponCode", _useCouponCode);
		_columnOriginalValues.put("couponCode", _couponCode);
		_columnOriginalValues.put("usePercentage", _usePercentage);
		_columnOriginalValues.put(
			"maximumDiscountAmount", _maximumDiscountAmount);
		_columnOriginalValues.put("levelType", _level);
		_columnOriginalValues.put("level1", _level1);
		_columnOriginalValues.put("level2", _level2);
		_columnOriginalValues.put("level3", _level3);
		_columnOriginalValues.put("level4", _level4);
		_columnOriginalValues.put("limitationType", _limitationType);
		_columnOriginalValues.put("limitationTimes", _limitationTimes);
		_columnOriginalValues.put(
			"limitationTimesPerAccount", _limitationTimesPerAccount);
		_columnOriginalValues.put("numberOfUse", _numberOfUse);
		_columnOriginalValues.put("rulesConjunction", _rulesConjunction);
		_columnOriginalValues.put("active_", _active);
		_columnOriginalValues.put("displayDate", _displayDate);
		_columnOriginalValues.put("expirationDate", _expirationDate);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("levelType", "level");
		attributeNames.put("active_", "active");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("externalReferenceCode", 4L);

		columnBitmasks.put("commerceDiscountId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("userId", 32L);

		columnBitmasks.put("userName", 64L);

		columnBitmasks.put("createDate", 128L);

		columnBitmasks.put("modifiedDate", 256L);

		columnBitmasks.put("title", 512L);

		columnBitmasks.put("target", 1024L);

		columnBitmasks.put("useCouponCode", 2048L);

		columnBitmasks.put("couponCode", 4096L);

		columnBitmasks.put("usePercentage", 8192L);

		columnBitmasks.put("maximumDiscountAmount", 16384L);

		columnBitmasks.put("levelType", 32768L);

		columnBitmasks.put("level1", 65536L);

		columnBitmasks.put("level2", 131072L);

		columnBitmasks.put("level3", 262144L);

		columnBitmasks.put("level4", 524288L);

		columnBitmasks.put("limitationType", 1048576L);

		columnBitmasks.put("limitationTimes", 2097152L);

		columnBitmasks.put("limitationTimesPerAccount", 4194304L);

		columnBitmasks.put("numberOfUse", 8388608L);

		columnBitmasks.put("rulesConjunction", 16777216L);

		columnBitmasks.put("active_", 33554432L);

		columnBitmasks.put("displayDate", 67108864L);

		columnBitmasks.put("expirationDate", 134217728L);

		columnBitmasks.put("lastPublishDate", 268435456L);

		columnBitmasks.put("status", 536870912L);

		columnBitmasks.put("statusByUserId", 1073741824L);

		columnBitmasks.put("statusByUserName", 2147483648L);

		columnBitmasks.put("statusDate", 4294967296L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommerceDiscount _escapedModel;

}