/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.internal;

import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.discount.CommerceDiscountCalculation;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountModel;
import com.liferay.commerce.discount.service.CommerceDiscountLocalService;
import com.liferay.commerce.product.model.CommerceChannelAccountEntryRel;
import com.liferay.commerce.product.service.CommerceChannelAccountEntryRelLocalService;
import com.liferay.commerce.util.CommerceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseCommerceDiscountCalculation
implements CommerceDiscountCalculation {
    @Reference
    protected CommerceAccountHelper commerceAccountHelper;
    @Reference
    protected CommerceChannelAccountEntryRelLocalService commerceChannelAccountEntryRelLocalService;
    @Reference
    protected CommerceDiscountLocalService commerceDiscountLocalService;

    protected List<CommerceDiscount> getOrderCommerceDiscountByHierarchy(long companyId, CommerceContext commerceContext, long commerceOrderTypeId, String target) throws PortalException {
        return this._getOrderCommerceDiscountByHierarchy(companyId, CommerceUtil.getCommerceAccountId((CommerceContext)commerceContext), commerceContext.getCommerceChannelId(), commerceOrderTypeId, target);
    }

    protected List<CommerceDiscount> getProductCommerceDiscountByHierarchy(long companyId, CommerceContext commerceContext, long commerceOrderTypeId, long cpDefinitionId, long cpInstanceId) throws PortalException {
        return this._getProductCommerceDiscountByHierarchy(companyId, CommerceUtil.getCommerceAccountId((CommerceContext)commerceContext), commerceContext.getCommerceChannelId(), commerceOrderTypeId, cpDefinitionId, cpInstanceId);
    }

    private List<CommerceDiscount> _getDefaultCommerceDiscounts(CommerceChannelAccountEntryRel commerceChannelAccountEntryRel, List<CommerceDiscount> commerceDiscounts) throws PortalException {
        if (commerceChannelAccountEntryRel == null) {
            return null;
        }
        Stream commerceDiscountsStream = commerceDiscounts.stream();
        if (commerceDiscountsStream.mapToLong(CommerceDiscountModel::getCommerceDiscountId).anyMatch(commerceDiscountId -> commerceDiscountId == commerceChannelAccountEntryRel.getClassPK())) {
            return Collections.singletonList(this.commerceDiscountLocalService.getCommerceDiscount(commerceChannelAccountEntryRel.getClassPK()));
        }
        return null;
    }

    private List<CommerceDiscount> _getOrderCommerceDiscountByHierarchy(long companyId, long commerceAccountId, long commerceChannelId, long commerceOrderTypeId, String target) throws PortalException {
        List<CommerceDiscount> defaultCommerceDiscounts;
        long[] commerceAccountGroupIds;
        List<CommerceDiscount> defaultCommerceDiscounts2;
        CommerceDiscount commerceDiscount;
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this.commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(commerceAccountId, commerceChannelId, 5);
        if (commerceChannelAccountEntryRel != null && commerceChannelAccountEntryRel.isOverrideEligibility() && (commerceDiscount = this.commerceDiscountLocalService.getCommerceDiscount(commerceChannelAccountEntryRel.getClassPK())).isActive() && target.equals(commerceDiscount.getTarget())) {
            return Collections.singletonList(commerceDiscount);
        }
        ArrayList<CommerceDiscount> firstEligibleCommerceDiscounts = new ArrayList<CommerceDiscount>();
        List commerceDiscounts = this.commerceDiscountLocalService.getAccountAndChannelAndOrderTypeCommerceDiscounts(commerceAccountId, commerceChannelId, commerceOrderTypeId, target);
        if (commerceDiscounts != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts2 = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts2 != null) {
                return defaultCommerceDiscounts2;
            }
            firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getAccountAndOrderTypeCommerceDiscounts(commerceAccountId, commerceOrderTypeId, target)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts2 = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts2 != null) {
                return defaultCommerceDiscounts2;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getAccountAndChannelCommerceDiscounts(commerceAccountId, commerceChannelId, target)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts2 = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts2 != null) {
                return defaultCommerceDiscounts2;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getAccountCommerceDiscounts(commerceAccountId, target)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts2 = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts2 != null) {
                return defaultCommerceDiscounts2;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getAccountGroupAndChannelAndOrderTypeCommerceDiscount(commerceAccountGroupIds = this.commerceAccountHelper.getCommerceAccountGroupIds(commerceAccountId), commerceChannelId, commerceOrderTypeId, target)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts != null) {
                return defaultCommerceDiscounts;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getAccountGroupAndOrderTypeCommerceDiscount(commerceAccountGroupIds, commerceOrderTypeId, target)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts != null) {
                return defaultCommerceDiscounts;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getAccountGroupAndChannelCommerceDiscount(commerceAccountGroupIds, commerceChannelId, target)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts != null) {
                return defaultCommerceDiscounts;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getAccountGroupCommerceDiscount(commerceAccountGroupIds, target)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts != null) {
                return defaultCommerceDiscounts;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getChannelAndOrderTypeCommerceDiscounts(commerceChannelId, commerceOrderTypeId, target)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts != null) {
                return defaultCommerceDiscounts;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getOrderTypeCommerceDiscounts(commerceOrderTypeId, target)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts != null) {
                return defaultCommerceDiscounts;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getChannelCommerceDiscounts(commerceChannelId, target)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts != null) {
                return defaultCommerceDiscounts;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getUnqualifiedCommerceDiscounts(companyId, target)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts != null) {
                return defaultCommerceDiscounts;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        return firstEligibleCommerceDiscounts;
    }

    private List<CommerceDiscount> _getProductCommerceDiscountByHierarchy(long companyId, long commerceAccountId, long commerceChannelId, long commerceOrderTypeId, long cpDefinitionId, long cpInstanceId) throws PortalException {
        List<CommerceDiscount> defaultCommerceDiscounts;
        long[] commerceAccountGroupIds;
        List<CommerceDiscount> defaultCommerceDiscounts2;
        CommerceDiscount defaultCommerceDiscount;
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this.commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(commerceAccountId, commerceChannelId, 5);
        if (commerceChannelAccountEntryRel != null && commerceChannelAccountEntryRel.isOverrideEligibility() && (defaultCommerceDiscount = this.commerceDiscountLocalService.fetchDefaultCommerceDiscount(commerceChannelAccountEntryRel.getCommerceChannelAccountEntryRelId(), cpDefinitionId, cpInstanceId)) != null) {
            return Collections.singletonList(defaultCommerceDiscount);
        }
        ArrayList<CommerceDiscount> firstEligibleCommerceDiscounts = new ArrayList<CommerceDiscount>();
        List commerceDiscounts = this.commerceDiscountLocalService.getAccountAndChannelAndOrderTypeCommerceDiscounts(commerceAccountId, commerceChannelId, commerceOrderTypeId, cpDefinitionId, cpInstanceId);
        if (commerceDiscounts != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts2 = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts2 != null) {
                return defaultCommerceDiscounts2;
            }
            firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getAccountAndChannelCommerceDiscounts(commerceAccountId, commerceChannelId, cpDefinitionId, cpInstanceId)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts2 = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts2 != null) {
                return defaultCommerceDiscounts2;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getAccountCommerceDiscounts(commerceAccountId, cpDefinitionId, cpInstanceId)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts2 = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts2 != null) {
                return defaultCommerceDiscounts2;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getAccountGroupAndChannelAndOrderTypeCommerceDiscount(commerceAccountGroupIds = this.commerceAccountHelper.getCommerceAccountGroupIds(commerceAccountId), commerceChannelId, commerceOrderTypeId, cpDefinitionId, cpInstanceId)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts != null) {
                return defaultCommerceDiscounts;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getAccountGroupAndChannelCommerceDiscount(commerceAccountGroupIds, commerceChannelId, cpDefinitionId, cpInstanceId)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts != null) {
                return defaultCommerceDiscounts;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getAccountGroupCommerceDiscount(commerceAccountGroupIds, cpDefinitionId, cpInstanceId)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts != null) {
                return defaultCommerceDiscounts;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getChannelAndOrderTypeCommerceDiscounts(commerceChannelId, commerceOrderTypeId, cpDefinitionId, cpInstanceId)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts != null) {
                return defaultCommerceDiscounts;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getOrderTypeCommerceDiscounts(commerceOrderTypeId, cpDefinitionId, cpInstanceId)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts != null) {
                return defaultCommerceDiscounts;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getChannelCommerceDiscounts(commerceChannelId, cpDefinitionId, cpInstanceId)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts != null) {
                return defaultCommerceDiscounts;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        if ((commerceDiscounts = this.commerceDiscountLocalService.getUnqualifiedCommerceDiscounts(companyId, cpDefinitionId, cpInstanceId)) != null && !commerceDiscounts.isEmpty()) {
            defaultCommerceDiscounts = this._getDefaultCommerceDiscounts(commerceChannelAccountEntryRel, commerceDiscounts);
            if (defaultCommerceDiscounts != null) {
                return defaultCommerceDiscounts;
            }
            if (firstEligibleCommerceDiscounts.isEmpty()) {
                firstEligibleCommerceDiscounts.addAll(commerceDiscounts);
            }
        }
        return firstEligibleCommerceDiscounts;
    }
}

