/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.internal;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.discount.CommerceDiscountCalculation;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.discount.application.strategy.CommerceDiscountApplicationStrategy;
import com.liferay.commerce.discount.internal.BaseCommerceDiscountCalculation;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.service.CommerceDiscountUsageEntryLocalService;
import com.liferay.commerce.discount.validator.helper.CommerceDiscountValidatorHelper;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.price.list.model.CommercePriceListDiscountRelModel;
import com.liferay.commerce.price.list.service.CommercePriceListDiscountRelLocalService;
import com.liferay.commerce.pricing.configuration.CommercePricingConfiguration;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.util.CommerceBigDecimalUtil;
import com.liferay.commerce.util.CommerceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(enabled=false, property={"commerce.discount.calculation.key=v2.0"}, service={CommerceDiscountCalculation.class})
public class CommerceDiscountCalculationV2Impl
extends BaseCommerceDiscountCalculation {
    private static final BigDecimal _ONE_HUNDRED = BigDecimal.valueOf(100L);
    private static final int _SCALE = 10;
    private static final Log _log = LogFactoryUtil.getLog(CommerceDiscountCalculationV2Impl.class);
    private final Map<String, CommerceDiscountApplicationStrategy> _commerceDiscountApplicationStrategyMap = new ConcurrentHashMap<String, CommerceDiscountApplicationStrategy>();
    @Reference
    private CommerceDiscountUsageEntryLocalService _commerceDiscountUsageEntryLocalService;
    @Reference
    private CommerceDiscountValidatorHelper _commerceDiscountValidatorHelper;
    @Reference
    private CommerceMoneyFactory _commerceMoneyFactory;
    @Reference
    private CommercePriceListDiscountRelLocalService _commercePriceListDiscountRelLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;

    public CommerceDiscountValue getOrderShippingCommerceDiscountValue(CommerceOrder commerceOrder, BigDecimal shippingAmount, CommerceContext commerceContext) throws PortalException {
        if (commerceOrder == null) {
            return null;
        }
        return this._getCommerceDiscountValue(commerceOrder, shippingAmount, commerceContext, "shipping");
    }

    public CommerceDiscountValue getOrderSubtotalCommerceDiscountValue(CommerceOrder commerceOrder, BigDecimal subtotalAmount, CommerceContext commerceContext) throws PortalException {
        if (commerceOrder == null) {
            return null;
        }
        return this._getCommerceDiscountValue(commerceOrder, subtotalAmount, commerceContext, "subtotal");
    }

    public CommerceDiscountValue getOrderTotalCommerceDiscountValue(CommerceOrder commerceOrder, BigDecimal totalAmount, CommerceContext commerceContext) throws PortalException {
        if (commerceOrder == null) {
            return null;
        }
        return this._getCommerceDiscountValue(commerceOrder, totalAmount, commerceContext, "total");
    }

    public CommerceDiscountValue getProductCommerceDiscountValue(long cpInstanceId, int quantity, BigDecimal productUnitPrice, CommerceContext commerceContext) throws PortalException {
        return this.getProductCommerceDiscountValue(cpInstanceId, 0L, quantity, productUnitPrice, commerceContext);
    }

    public CommerceDiscountValue getProductCommerceDiscountValue(long cpInstanceId, long commercePriceListId, int quantity, BigDecimal productUnitPrice, CommerceContext commerceContext) throws PortalException {
        List<CommerceDiscount> commerceDiscounts;
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        List commercePriceListDiscountRels = this._commercePriceListDiscountRelLocalService.getCommercePriceListDiscountRels(commercePriceListId);
        if (commercePriceListDiscountRels != null && !commercePriceListDiscountRels.isEmpty()) {
            Stream stream = commercePriceListDiscountRels.stream();
            long[] commerceDiscountIds = stream.mapToLong(CommercePriceListDiscountRelModel::getCommerceDiscountId).toArray();
            List commerceDiscounts2 = this.commerceDiscountLocalService.getPriceListCommerceDiscounts(commerceDiscountIds, cpInstance.getCPDefinitionId());
            if (commerceDiscounts2.isEmpty()) {
                return null;
            }
            return this._getCommerceDiscountValues(productUnitPrice, quantity, commerceContext, commerceDiscounts2);
        }
        long commerceOrderTypeId = 0L;
        CommerceOrder commerceOrder = commerceContext.getCommerceOrder();
        if (commerceOrder != null) {
            commerceOrderTypeId = commerceOrder.getCommerceOrderTypeId();
        }
        if ((commerceDiscounts = this.getProductCommerceDiscountByHierarchy(cpInstance.getCompanyId(), commerceContext, commerceOrderTypeId, cpInstance.getCPDefinitionId(), cpInstanceId)).isEmpty()) {
            return null;
        }
        return this._getCommerceDiscountValues(productUnitPrice, quantity, commerceContext, commerceDiscounts);
    }

    public void unsetCommerceDiscountApplicationStrategy(CommerceDiscountApplicationStrategy commerceDiscountApplicationStrategy, Map<String, Object> properties) {
        String commerceDiscountApplicationStrategyKey = GetterUtil.getString((Object)properties.get("commerce.discount.application.strategy.key"));
        this._commerceDiscountApplicationStrategyMap.remove(commerceDiscountApplicationStrategyKey);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setCommerceDiscountApplicationStrategy(CommerceDiscountApplicationStrategy commerceDiscountApplicationStrategy, Map<String, Object> properties) {
        String commerceDiscountApplicationStrategyKey = GetterUtil.getString((Object)properties.get("commerce.discount.application.strategy.key"));
        this._commerceDiscountApplicationStrategyMap.put(commerceDiscountApplicationStrategyKey, commerceDiscountApplicationStrategy);
    }

    private CommerceDiscountApplicationStrategy _getCommerceDiscountApplicationStrategy() throws ConfigurationException {
        CommercePricingConfiguration commercePricingConfiguration = (CommercePricingConfiguration)this._configurationProvider.getSystemConfiguration(CommercePricingConfiguration.class);
        String commerceDiscountApplicationStrategy = commercePricingConfiguration.commerceDiscountApplicationStrategy();
        if (!this._commerceDiscountApplicationStrategyMap.containsKey(commerceDiscountApplicationStrategy)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No commerce discount application strategy specified for " + commerceDiscountApplicationStrategy));
            }
            return null;
        }
        return this._commerceDiscountApplicationStrategyMap.get(commerceDiscountApplicationStrategy);
    }

    private BigDecimal _getCommerceDiscountLevel(BigDecimal currentDiscountLevel, BigDecimal commercePrice, CommerceCurrency commerceCurrency, long commerceDiscountId, BigDecimal commerceDiscountValue, boolean usePercentage) throws PortalException {
        if (commerceDiscountValue == null || CommerceBigDecimalUtil.isZero((BigDecimal)commercePrice)) {
            return null;
        }
        BigDecimal discountAmount = BigDecimal.ZERO;
        if (usePercentage) {
            discountAmount = commercePrice.multiply(commerceDiscountValue);
            discountAmount = discountAmount.divide(_ONE_HUNDRED);
            CommerceDiscount commerceDiscount = this.commerceDiscountLocalService.getCommerceDiscount(commerceDiscountId);
            BigDecimal maximumDiscountAmount = commerceDiscount.getMaximumDiscountAmount();
            if (CommerceBigDecimalUtil.gt((BigDecimal)maximumDiscountAmount, (BigDecimal)BigDecimal.ZERO) && CommerceBigDecimalUtil.gt((BigDecimal)discountAmount, (BigDecimal)maximumDiscountAmount)) {
                discountAmount = commerceDiscount.getMaximumDiscountAmount();
            }
        } else {
            discountAmount = commerceDiscountValue;
            if (CommerceBigDecimalUtil.gt((BigDecimal)commerceDiscountValue, (BigDecimal)commercePrice)) {
                discountAmount = commercePrice;
            }
        }
        RoundingMode roundingMode = RoundingMode.valueOf(commerceCurrency.getRoundingMode());
        BigDecimal discountedAmount = commercePrice.subtract(discountAmount);
        BigDecimal discountPercentage = this._getDiscountPercentage(discountedAmount, commercePrice, roundingMode);
        if (currentDiscountLevel == null || CommerceBigDecimalUtil.gt((BigDecimal)discountPercentage, (BigDecimal)currentDiscountLevel)) {
            return discountPercentage;
        }
        return currentDiscountLevel;
    }

    private BigDecimal[] _getCommerceDiscountLevels(String couponCode, BigDecimal commercePrice, CommerceContext commerceContext, List<CommerceDiscount> commerceDiscounts) throws PortalException {
        CommerceOrder commerceOrder;
        if (couponCode.isEmpty() && (commerceOrder = commerceContext.getCommerceOrder()) != null) {
            couponCode = commerceOrder.getCouponCode();
        }
        CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        BigDecimal[] levels = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
        for (CommerceDiscount commerceDiscount : commerceDiscounts) {
            String discountCouponCode = commerceDiscount.getCouponCode();
            if (!this._isValidCouponCode(commerceDiscount.getCommerceDiscountId(), couponCode, discountCouponCode, commerceContext) || !this._isValidDiscount(commerceContext, commerceDiscount)) continue;
            String discountLevel = commerceDiscount.getLevel();
            if (discountLevel.isEmpty() || discountLevel.equals("L1")) {
                levels[0] = this._getCommerceDiscountLevel(levels[0], commercePrice, commerceCurrency, commerceDiscount.getCommerceDiscountId(), commerceDiscount.getLevel1(), commerceDiscount.isUsePercentage());
            }
            if (!commerceDiscount.isUsePercentage()) continue;
            if (discountLevel.isEmpty() || discountLevel.equals("L2")) {
                levels[1] = this._getCommerceDiscountLevel(levels[1], commercePrice, commerceCurrency, commerceDiscount.getCommerceDiscountId(), commerceDiscount.getLevel2(), commerceDiscount.isUsePercentage());
            }
            if (discountLevel.isEmpty() || discountLevel.equals("L3")) {
                levels[2] = this._getCommerceDiscountLevel(levels[2], commercePrice, commerceCurrency, commerceDiscount.getCommerceDiscountId(), commerceDiscount.getLevel3(), commerceDiscount.isUsePercentage());
            }
            if (!discountLevel.isEmpty() && !discountLevel.equals("L4")) continue;
            levels[3] = this._getCommerceDiscountLevel(levels[3], commercePrice, commerceCurrency, commerceDiscount.getCommerceDiscountId(), commerceDiscount.getLevel4(), commerceDiscount.isUsePercentage());
        }
        return levels;
    }

    private CommerceDiscountValue _getCommerceDiscountValue(CommerceOrder commerceOrder, BigDecimal amount, CommerceContext commerceContext, String target) throws PortalException {
        if (amount == null || CommerceBigDecimalUtil.lte((BigDecimal)amount, (BigDecimal)BigDecimal.ZERO)) {
            return null;
        }
        List<CommerceDiscount> commerceDiscounts = this.getOrderCommerceDiscountByHierarchy(commerceOrder.getCompanyId(), commerceContext, commerceOrder.getCommerceOrderTypeId(), target);
        if (commerceDiscounts.isEmpty()) {
            return null;
        }
        BigDecimal[] commerceDiscountLevels = this._getCommerceDiscountLevels(commerceOrder.getCouponCode(), amount, commerceContext, commerceDiscounts);
        CommerceDiscountApplicationStrategy commerceDiscountApplicationStrategy = this._getCommerceDiscountApplicationStrategy();
        BigDecimal discountedAmount = commerceDiscountApplicationStrategy.applyCommerceDiscounts(amount, commerceDiscountLevels);
        BigDecimal currentDiscountAmount = amount.subtract(discountedAmount);
        CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        RoundingMode roundingMode = RoundingMode.valueOf(commerceCurrency.getRoundingMode());
        currentDiscountAmount = currentDiscountAmount.setScale(10, roundingMode);
        CommerceMoney discountAmountCommerceMoney = this._commerceMoneyFactory.create(commerceCurrency, currentDiscountAmount);
        return new CommerceDiscountValue(0L, discountAmountCommerceMoney, this._getDiscountPercentage(discountedAmount, amount, roundingMode), commerceDiscountLevels);
    }

    private CommerceDiscountValue _getCommerceDiscountValues(BigDecimal commercePrice, int quantity, CommerceContext commerceContext, List<CommerceDiscount> commerceDiscounts) throws PortalException {
        BigDecimal[] commerceDiscountLevels = this._getCommerceDiscountLevels("", commercePrice, commerceContext, commerceDiscounts);
        CommerceDiscountApplicationStrategy commerceDiscountApplicationStrategy = this._getCommerceDiscountApplicationStrategy();
        BigDecimal discountedAmount = commerceDiscountApplicationStrategy.applyCommerceDiscounts(commercePrice, commerceDiscountLevels);
        BigDecimal currentDiscountAmount = commercePrice.subtract(discountedAmount);
        CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        RoundingMode roundingMode = RoundingMode.valueOf(commerceCurrency.getRoundingMode());
        if (CommerceBigDecimalUtil.isZero((BigDecimal)(currentDiscountAmount = currentDiscountAmount.setScale(10, roundingMode)))) {
            return null;
        }
        CommerceMoney discountAmountCommerceMoney = this._commerceMoneyFactory.create(commerceCurrency, currentDiscountAmount.multiply(new BigDecimal(quantity)));
        return new CommerceDiscountValue(0L, discountAmountCommerceMoney, this._getDiscountPercentage(discountedAmount, commercePrice, roundingMode), commerceDiscountLevels);
    }

    private BigDecimal _getDiscountPercentage(BigDecimal discountedAmount, BigDecimal amount, RoundingMode roundingMode) {
        double actualPrice = discountedAmount.doubleValue();
        double originalPrice = amount.doubleValue();
        double percentage = actualPrice / originalPrice;
        BigDecimal discountPercentage = new BigDecimal(percentage);
        discountPercentage = discountPercentage.multiply(_ONE_HUNDRED);
        MathContext mathContext = new MathContext(discountPercentage.precision(), roundingMode);
        return _ONE_HUNDRED.subtract(discountPercentage, mathContext);
    }

    private boolean _isValidCouponCode(long commerceDiscountId, String couponCode, String discountCouponCode, CommerceContext commerceContext) throws PortalException {
        return (Validator.isBlank((String)discountCouponCode) || Objects.equals(couponCode, discountCouponCode)) && this._commerceDiscountUsageEntryLocalService.validateDiscountLimitationUsage(CommerceUtil.getCommerceAccountId((CommerceContext)commerceContext), commerceDiscountId);
    }

    private boolean _isValidDiscount(CommerceContext commerceContext, CommerceDiscount commerceDiscount) throws PortalException {
        return this._commerceDiscountValidatorHelper.isValid(commerceContext, commerceDiscount, new String[]{"post-qualification"});
    }
}

