/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.internal.rule.type;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.discount.model.CommerceDiscountRule;
import com.liferay.commerce.discount.rule.type.CommerceDiscountRuleType;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.price.CommerceOrderPriceCalculation;
import com.liferay.commerce.util.CommerceBigDecimalUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"commerce.discount.rule.type.key=cart-total", "commerce.discount.rule.type.order:Integer=10"}, service={CommerceDiscountRuleType.class})
public class CartTotalCommerceDiscountRuleTypeImpl
implements CommerceDiscountRuleType {
    @Reference
    private CommerceOrderPriceCalculation _commerceOrderPriceCalculation;
    @Reference
    private Language _language;

    public boolean evaluate(CommerceDiscountRule commerceDiscountRule, CommerceContext commerceContext) throws PortalException {
        String settingsProperty;
        BigDecimal cartTotal;
        CommerceOrder commerceOrder = commerceContext.getCommerceOrder();
        if (commerceOrder == null) {
            return false;
        }
        CommerceMoney orderPriceCommerceMoney = this._commerceOrderPriceCalculation.getSubtotal(commerceOrder, commerceContext);
        if (orderPriceCommerceMoney == null) {
            return false;
        }
        BigDecimal orderPrice = orderPriceCommerceMoney.getPrice();
        return CommerceBigDecimalUtil.gt((BigDecimal)orderPrice, (BigDecimal)(cartTotal = new BigDecimal(settingsProperty = commerceDiscountRule.getSettingsProperty(commerceDiscountRule.getType()))));
    }

    public String getKey() {
        return "cart-total";
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return this._language.get(resourceBundle, "cart-total");
    }
}

