/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.internal.target;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRelModel;
import com.liferay.commerce.discount.service.CommerceDiscountRelLocalService;
import com.liferay.commerce.discount.target.CommerceDiscountProductTarget;
import com.liferay.commerce.discount.target.CommerceDiscountTarget;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.ExistsFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"commerce.discount.target.key=products", "commerce.discount.target.order:Integer=20"}, service={CommerceDiscountProductTarget.class, CommerceDiscountTarget.class})
public class ApplyToProductCommerceDiscountTargetImpl
implements CommerceDiscountProductTarget,
CommerceDiscountTarget {
    @Reference
    private CommerceDiscountRelLocalService _commerceDiscountRelLocalService;
    @Reference
    private Language _language;

    public void contributeDocument(Document document, CommerceDiscount commerceDiscount) {
        List commerceDiscountRels = this._commerceDiscountRelLocalService.getCommerceDiscountRels(commerceDiscount.getCommerceDiscountId(), CPDefinition.class.getName());
        Stream stream = commerceDiscountRels.stream();
        LongStream longStream = stream.mapToLong(CommerceDiscountRelModel::getClassPK);
        long[] cpDefinitionIds = longStream.toArray();
        document.addKeyword("commerce_discount_target_cp_definition_ids", cpDefinitionIds);
    }

    public String getKey() {
        return "products";
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return this._language.get(resourceBundle, "products");
    }

    public CommerceDiscountTarget.Type getType() {
        return CommerceDiscountTarget.Type.APPLY_TO_PRODUCT;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, CPDefinition cpDefinition) {
        TermFilter termFilter = new TermFilter("commerce_discount_target_cp_definition_ids", String.valueOf(cpDefinition.getCPDefinitionId()));
        ExistsFilter existFilter = new ExistsFilter("commerce_discount_target_cp_definition_ids");
        BooleanFilter existBooleanFilter = new BooleanFilter();
        existBooleanFilter.add((Filter)existFilter, BooleanClauseOccur.MUST_NOT);
        BooleanFilter fieldBooleanFilter = new BooleanFilter();
        fieldBooleanFilter.add((Filter)existBooleanFilter, BooleanClauseOccur.SHOULD);
        fieldBooleanFilter.add((Filter)termFilter, BooleanClauseOccur.SHOULD);
        contextBooleanFilter.add((Filter)fieldBooleanFilter, BooleanClauseOccur.MUST);
    }
}

