/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.internal.target;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRelModel;
import com.liferay.commerce.discount.service.CommerceDiscountRelLocalService;
import com.liferay.commerce.discount.target.CommerceDiscountSKUTarget;
import com.liferay.commerce.discount.target.CommerceDiscountTarget;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.ExistsFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"commerce.discount.target.key=skus", "commerce.discount.target.order:Integer=20"}, service={CommerceDiscountSKUTarget.class, CommerceDiscountTarget.class})
public class ApplyToSKUCommerceDiscountTargetImpl
implements CommerceDiscountSKUTarget,
CommerceDiscountTarget {
    @Reference
    private CommerceDiscountRelLocalService _commerceDiscountRelLocalService;
    @Reference
    private Language _language;

    public void contributeDocument(Document document, CommerceDiscount commerceDiscount) {
        List commerceDiscountRels = this._commerceDiscountRelLocalService.getCommerceDiscountRels(commerceDiscount.getCommerceDiscountId(), CPInstance.class.getName());
        Stream stream = commerceDiscountRels.stream();
        LongStream longStream = stream.mapToLong(CommerceDiscountRelModel::getClassPK);
        long[] cpInstanceIds = longStream.toArray();
        document.addKeyword("commerce_discount_target_cp_instance_ids", cpInstanceIds);
    }

    public String getKey() {
        return "skus";
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return this._language.get(resourceBundle, "skus");
    }

    public CommerceDiscountTarget.Type getType() {
        return CommerceDiscountTarget.Type.APPLY_TO_SKU;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, CPInstance cpInstance) {
        BooleanFilter booleanFilter = new BooleanFilter();
        booleanFilter.add((Filter)new BooleanFilter(){
            {
                this.add((Filter)new ExistsFilter("commerce_discount_target_cp_instance_ids"), BooleanClauseOccur.MUST_NOT);
            }
        }, BooleanClauseOccur.SHOULD);
        booleanFilter.add((Filter)new TermFilter("commerce_discount_target_cp_instance_ids", String.valueOf(cpInstance.getCPDefinitionId())), BooleanClauseOccur.SHOULD);
        contextBooleanFilter.add((Filter)booleanFilter, BooleanClauseOccur.MUST);
    }
}

