/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.internal.validator;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.service.CommerceDiscountLocalService;
import com.liferay.commerce.discount.validator.CommerceDiscountValidator;
import com.liferay.commerce.discount.validator.CommerceDiscountValidatorResult;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"commerce.discount.validator.key=order", "commerce.discount.validator.priority:Integer=40", "commerce.discount.validator.type=target"}, service={CommerceDiscountValidator.class})
public class OrderCommerceDiscountValidator
implements CommerceDiscountValidator {
    public static final String KEY = "order";
    @Reference
    private CommerceDiscountLocalService _commerceDiscountLocalService;

    public String getKey() {
        return KEY;
    }

    public CommerceDiscountValidatorResult validate(CommerceContext commerceContext, CommerceDiscount commerceDiscount) throws PortalException {
        String target = commerceDiscount.getTarget();
        if (Objects.equals(target, "shipping") || Objects.equals(target, "subtotal") || Objects.equals(target, "total")) {
            return new CommerceDiscountValidatorResult(true);
        }
        CommerceOrder commerceOrder = commerceContext.getCommerceOrder();
        List commerceOrderItems = commerceOrder.getCommerceOrderItems();
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            int validCommerceDiscountsCount = this._commerceDiscountLocalService.getValidCommerceDiscountsCount(commerceDiscount.getCommerceDiscountId(), commerceOrderItem.getCPDefinitionId(), commerceOrderItem.getCPInstanceId());
            if (validCommerceDiscountsCount <= 0) continue;
            return new CommerceDiscountValidatorResult(true);
        }
        return new CommerceDiscountValidatorResult(commerceDiscount.getCommerceDiscountId(), false, "the-discount-is-not-applicable-to-the-current-order");
    }
}

