/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.internal.validator;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRule;
import com.liferay.commerce.discount.rule.type.CommerceDiscountRuleType;
import com.liferay.commerce.discount.rule.type.CommerceDiscountRuleTypeRegistry;
import com.liferay.commerce.discount.service.CommerceDiscountRuleLocalService;
import com.liferay.commerce.discount.validator.CommerceDiscountValidator;
import com.liferay.commerce.discount.validator.CommerceDiscountValidatorResult;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"commerce.discount.validator.key=rules", "commerce.discount.validator.priority:Integer=30", "commerce.discount.validator.type=post-qualification"}, service={CommerceDiscountValidator.class})
public class RulesCommerceDiscountValidator
implements CommerceDiscountValidator {
    public static final String KEY = "rules";
    @Reference
    private CommerceDiscountRuleLocalService _commerceDiscountRuleLocalService;
    @Reference
    private CommerceDiscountRuleTypeRegistry _commerceDiscountRuleTypeRegistry;

    public String getKey() {
        return KEY;
    }

    public CommerceDiscountValidatorResult validate(CommerceContext commerceContext, CommerceDiscount commerceDiscount) throws PortalException {
        List commerceDiscountRules = this._commerceDiscountRuleLocalService.getCommerceDiscountRules(commerceDiscount.getCommerceDiscountId(), -1, -1, null);
        if (commerceDiscountRules.isEmpty()) {
            return new CommerceDiscountValidatorResult(true);
        }
        for (CommerceDiscountRule commerceDiscountRule : commerceDiscountRules) {
            CommerceDiscountRuleType commerceDiscountRuleType = this._commerceDiscountRuleTypeRegistry.getCommerceDiscountRuleType(commerceDiscountRule.getType());
            boolean commerceDiscountRuleTypeEvaluation = commerceDiscountRuleType.evaluate(commerceDiscountRule, commerceContext);
            if (!commerceDiscountRuleTypeEvaluation && commerceDiscount.isRulesConjunction()) {
                return new CommerceDiscountValidatorResult(commerceDiscount.getCommerceDiscountId(), false, "the-discount-is-not-valid");
            }
            if (!commerceDiscountRuleTypeEvaluation || commerceDiscount.isRulesConjunction()) continue;
            return new CommerceDiscountValidatorResult(true);
        }
        if (commerceDiscount.isRulesConjunction()) {
            return new CommerceDiscountValidatorResult(true);
        }
        return new CommerceDiscountValidatorResult(commerceDiscount.getCommerceDiscountId(), false, "the-discount-is-not-valid");
    }
}

