/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.internal.validator.helper;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.discount.exception.CommerceDiscountValidatorException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.validator.CommerceDiscountValidator;
import com.liferay.commerce.discount.validator.CommerceDiscountValidatorRegistry;
import com.liferay.commerce.discount.validator.CommerceDiscountValidatorResult;
import com.liferay.commerce.discount.validator.helper.CommerceDiscountValidatorHelper;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommerceDiscountValidatorHelper.class})
public class CommerceDiscountValidatorHelperImpl
implements CommerceDiscountValidatorHelper {
    @Reference
    private CommerceDiscountValidatorRegistry _commerceDiscountValidatorRegistry;

    public void checkValid(CommerceContext commerceContext, CommerceDiscount commerceDiscount, String ... types) throws PortalException {
        List commerceDiscountValidators = this._commerceDiscountValidatorRegistry.getCommerceDiscountValidators(types);
        for (CommerceDiscountValidator commerceDiscountValidator : commerceDiscountValidators) {
            CommerceDiscountValidatorResult commerceDiscountValidatorResult = commerceDiscountValidator.validate(commerceContext, commerceDiscount);
            if (commerceDiscountValidatorResult.isValid()) continue;
            throw new CommerceDiscountValidatorException(commerceDiscountValidatorResult.getMessage());
        }
    }

    public boolean isValid(CommerceContext commerceContext, CommerceDiscount commerceDiscount, String ... types) throws PortalException {
        List<CommerceDiscountValidatorResult> commerceDiscountValidatorResults = this.validate(commerceContext, commerceDiscount, types);
        return commerceDiscountValidatorResults.isEmpty();
    }

    public List<CommerceDiscountValidatorResult> validate(CommerceContext commerceContext, CommerceDiscount commerceDiscount, String ... types) throws PortalException {
        ArrayList<CommerceDiscountValidatorResult> commerceDiscountValidatorResults = new ArrayList<CommerceDiscountValidatorResult>();
        List commerceDiscountValidators = this._commerceDiscountValidatorRegistry.getCommerceDiscountValidators(types);
        for (CommerceDiscountValidator commerceDiscountValidator : commerceDiscountValidators) {
            CommerceDiscountValidatorResult commerceDiscountValidatorResult = commerceDiscountValidator.validate(commerceContext, commerceDiscount);
            if (commerceDiscountValidatorResult.isValid()) continue;
            commerceDiscountValidatorResults.add(commerceDiscountValidatorResult);
        }
        return commerceDiscountValidatorResults;
    }
}

