/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.service.impl;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountAccountRel;
import com.liferay.commerce.discount.service.base.CommerceDiscountAccountRelLocalServiceBaseImpl;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.discount.model.CommerceDiscountAccountRel"}, service={AopService.class})
public class CommerceDiscountAccountRelLocalServiceImpl
extends CommerceDiscountAccountRelLocalServiceBaseImpl {
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public CommerceDiscountAccountRel addCommerceDiscountAccountRel(long userId, long commerceDiscountId, long commerceAccountId, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long commerceDiscountAccountRelId = this.counterLocalService.increment();
        CommerceDiscountAccountRel commerceDiscountAccountRel = this.commerceDiscountAccountRelPersistence.create(commerceDiscountAccountRelId);
        commerceDiscountAccountRel.setCompanyId(user.getCompanyId());
        commerceDiscountAccountRel.setUserId(user.getUserId());
        commerceDiscountAccountRel.setUserName(user.getFullName());
        commerceDiscountAccountRel.setCommerceAccountId(commerceAccountId);
        commerceDiscountAccountRel.setCommerceDiscountId(commerceDiscountId);
        commerceDiscountAccountRel = (CommerceDiscountAccountRel)this.commerceDiscountAccountRelPersistence.update((BaseModel)commerceDiscountAccountRel);
        this.reindexCommerceDiscount(commerceDiscountId);
        return commerceDiscountAccountRel;
    }

    @Override
    @SystemEvent(type=1)
    public CommerceDiscountAccountRel deleteCommerceDiscountAccountRel(CommerceDiscountAccountRel commerceDiscountAccountRel) throws PortalException {
        this.commerceDiscountAccountRelPersistence.remove((BaseModel)commerceDiscountAccountRel);
        this._expandoRowLocalService.deleteRows(commerceDiscountAccountRel.getCommerceDiscountAccountRelId());
        this.reindexCommerceDiscount(commerceDiscountAccountRel.getCommerceDiscountId());
        return commerceDiscountAccountRel;
    }

    @Override
    public CommerceDiscountAccountRel deleteCommerceDiscountAccountRel(long commerceDiscountAccountRelId) throws PortalException {
        CommerceDiscountAccountRel commerceDiscountAccountRel = this.commerceDiscountAccountRelPersistence.findByPrimaryKey(commerceDiscountAccountRelId);
        return this.commerceDiscountAccountRelLocalService.deleteCommerceDiscountAccountRel(commerceDiscountAccountRel);
    }

    @Deprecated
    public void deleteCommerceDiscountAccountRelsBycommerceAccountId(long commerceAccountId) {
        this.commerceDiscountAccountRelPersistence.removeByCommerceAccountId(commerceAccountId);
    }

    public void deleteCommerceDiscountAccountRelsByCommerceDiscountId(long commerceDiscountId) throws PortalException {
        List commerceDiscountAccountRels = this.commerceDiscountAccountRelPersistence.findByCommerceDiscountId(commerceDiscountId);
        for (CommerceDiscountAccountRel commerceDiscountAccountRel : commerceDiscountAccountRels) {
            this.commerceDiscountAccountRelLocalService.deleteCommerceDiscountAccountRel(commerceDiscountAccountRel);
        }
    }

    public CommerceDiscountAccountRel fetchCommerceDiscountAccountRel(long commerceAccountId, long commerceDiscountId) {
        return this.commerceDiscountAccountRelPersistence.fetchByCAI_CDI(commerceAccountId, commerceDiscountId);
    }

    public List<CommerceDiscountAccountRel> getCommerceDiscountAccountRels(long commerceDiscountId, int start, int end, OrderByComparator<CommerceDiscountAccountRel> orderByComparator) {
        return this.commerceDiscountAccountRelPersistence.findByCommerceDiscountId(commerceDiscountId, start, end, orderByComparator);
    }

    public List<CommerceDiscountAccountRel> getCommerceDiscountAccountRels(long commerceDiscountId, String name, int start, int end) {
        return this.commerceDiscountAccountRelFinder.findByCommerceDiscountId(commerceDiscountId, name, start, end);
    }

    public int getCommerceDiscountAccountRelsCount(long commerceDiscountId) {
        return this.commerceDiscountAccountRelPersistence.countByCommerceDiscountId(commerceDiscountId);
    }

    public int getCommerceDiscountAccountRelsCount(long commerceDiscountId, String name) {
        return this.commerceDiscountAccountRelFinder.countByCommerceDiscountId(commerceDiscountId, name);
    }

    protected void reindexCommerceDiscount(long commerceDiscountId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceDiscount.class);
        indexer.reindex(CommerceDiscount.class.getName(), commerceDiscountId);
    }
}

