/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.service.impl;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountAccountRel;
import com.liferay.commerce.discount.service.base.CommerceDiscountAccountRelServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceDiscountAccountRel"}, service={AopService.class})
public class CommerceDiscountAccountRelServiceImpl
extends CommerceDiscountAccountRelServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.commerce.discount.model.CommerceDiscount)")
    private ModelResourcePermission<CommerceDiscount> _commerceDiscountResourcePermission;

    public CommerceDiscountAccountRel addCommerceDiscountAccountRel(long commerceDiscountId, long commerceAccountId, ServiceContext serviceContext) throws PortalException {
        this._commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "UPDATE");
        return this.commerceDiscountAccountRelLocalService.addCommerceDiscountAccountRel(this.getUserId(), commerceDiscountId, commerceAccountId, serviceContext);
    }

    public void deleteCommerceDiscountAccountRel(long commerceDiscountAccountRelId) throws PortalException {
        CommerceDiscountAccountRel commerceDiscountAccountRel = this.commerceDiscountAccountRelLocalService.getCommerceDiscountAccountRel(commerceDiscountAccountRelId);
        this._commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountAccountRel.getCommerceDiscountId(), "UPDATE");
        this.commerceDiscountAccountRelLocalService.deleteCommerceDiscountAccountRel(commerceDiscountAccountRel);
    }

    public void deleteCommerceDiscountAccountRelsByCommerceDiscountId(long commerceDiscountId) throws PortalException {
        this._commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "UPDATE");
        this.commerceDiscountAccountRelLocalService.deleteCommerceDiscountAccountRelsByCommerceDiscountId(commerceDiscountId);
    }

    public CommerceDiscountAccountRel fetchCommerceDiscountAccountRel(long commerceAccountId, long commerceDiscountId) throws PortalException {
        CommerceDiscountAccountRel commerceDiscountAccountRel = this.commerceDiscountAccountRelLocalService.fetchCommerceDiscountAccountRel(commerceAccountId, commerceDiscountId);
        if (commerceDiscountAccountRel != null) {
            this._commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountAccountRel.getCommerceDiscountId(), "UPDATE");
        }
        return commerceDiscountAccountRel;
    }

    public CommerceDiscountAccountRel getCommerceDiscountAccountRel(long commerceDiscountAccountRelId) throws PortalException {
        CommerceDiscountAccountRel commerceDiscountAccountRel = this.commerceDiscountAccountRelLocalService.getCommerceDiscountAccountRel(commerceDiscountAccountRelId);
        this._commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountAccountRel.getCommerceDiscountId(), "UPDATE");
        return commerceDiscountAccountRel;
    }

    public List<CommerceDiscountAccountRel> getCommerceDiscountAccountRels(long commerceDiscountId, int start, int end, OrderByComparator<CommerceDiscountAccountRel> orderByComparator) throws PortalException {
        this._commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "UPDATE");
        return this.commerceDiscountAccountRelLocalService.getCommerceDiscountAccountRels(commerceDiscountId, start, end, orderByComparator);
    }

    public List<CommerceDiscountAccountRel> getCommerceDiscountAccountRels(long commerceDiscountId, String name, int start, int end) {
        return this.commerceDiscountAccountRelFinder.findByCommerceDiscountId(commerceDiscountId, name, start, end, true);
    }

    public int getCommerceDiscountAccountRelsCount(long commerceDiscountId) throws PortalException {
        this._commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "UPDATE");
        return this.commerceDiscountAccountRelLocalService.getCommerceDiscountAccountRelsCount(commerceDiscountId);
    }

    public int getCommerceDiscountAccountRelsCount(long commerceDiscountId, String name) {
        return this.commerceDiscountAccountRelFinder.countByCommerceDiscountId(commerceDiscountId, name, true);
    }
}

