/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.service.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetCategoryModel;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.commerce.discount.exception.CommerceDiscountCouponCodeException;
import com.liferay.commerce.discount.exception.CommerceDiscountDisplayDateException;
import com.liferay.commerce.discount.exception.CommerceDiscountExpirationDateException;
import com.liferay.commerce.discount.exception.CommerceDiscountLimitationTypeException;
import com.liferay.commerce.discount.exception.CommerceDiscountMaxPriceValueException;
import com.liferay.commerce.discount.exception.CommerceDiscountTargetException;
import com.liferay.commerce.discount.exception.CommerceDiscountTitleException;
import com.liferay.commerce.discount.exception.DuplicateCommerceDiscountException;
import com.liferay.commerce.discount.exception.NoSuchDiscountException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountAccountRelTable;
import com.liferay.commerce.discount.model.CommerceDiscountCommerceAccountGroupRelTable;
import com.liferay.commerce.discount.model.CommerceDiscountOrderTypeRelTable;
import com.liferay.commerce.discount.model.CommerceDiscountRelTable;
import com.liferay.commerce.discount.model.CommerceDiscountTable;
import com.liferay.commerce.discount.service.CommerceDiscountCommerceAccountGroupRelLocalService;
import com.liferay.commerce.discount.service.CommerceDiscountOrderTypeRelLocalService;
import com.liferay.commerce.discount.service.CommerceDiscountRelLocalService;
import com.liferay.commerce.discount.service.CommerceDiscountRuleLocalService;
import com.liferay.commerce.discount.service.CommerceDiscountUsageEntryLocalService;
import com.liferay.commerce.discount.service.base.CommerceDiscountLocalServiceBaseImpl;
import com.liferay.commerce.discount.target.CommerceDiscountTarget;
import com.liferay.commerce.discount.target.CommerceDiscountTargetRegistry;
import com.liferay.commerce.discount.util.comparator.CommerceDiscountCreateDateComparator;
import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.service.CommercePricingClassLocalService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceChannelAccountEntryRelTable;
import com.liferay.commerce.product.model.CommerceChannelRelTable;
import com.liferay.commerce.product.service.CommerceChannelAccountEntryRelLocalService;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.discount.model.CommerceDiscount"}, service={AopService.class})
public class CommerceDiscountLocalServiceImpl
extends CommerceDiscountLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "uid"};
    private static final Log _log = LogFactoryUtil.getLog(CommerceDiscountLocalServiceImpl.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CommerceChannelAccountEntryRelLocalService _commerceChannelAccountEntryRelLocalService;
    @Reference
    private CommerceDiscountCommerceAccountGroupRelLocalService _commerceDiscountCommerceAccountGroupRelLocalService;
    @Reference
    private CommerceDiscountOrderTypeRelLocalService _commerceDiscountOrderTypeRelLocalService;
    @Reference
    private CommerceDiscountRelLocalService _commerceDiscountRelLocalService;
    @Reference
    private CommerceDiscountRuleLocalService _commerceDiscountRuleLocalService;
    @Reference
    private CommerceDiscountTargetRegistry _commerceDiscountTargetRegistry;
    @Reference
    private CommerceDiscountUsageEntryLocalService _commerceDiscountUsageEntryLocalService;
    @Reference
    private CommercePricingClassLocalService _commercePricingClassLocalService;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount addCommerceDiscount(long userId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.commerceDiscountLocalService.addCommerceDiscount(userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, "", level1, level2, level3, level4, limitationType, limitationTimes, true, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount addCommerceDiscount(long userId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addCommerceDiscount(null, userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount addCommerceDiscount(long userId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, String externalReferenceCode, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addCommerceDiscount(externalReferenceCode, userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount addCommerceDiscount(long userId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, int limitationTimesPerAccount, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, String externalReferenceCode, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addCommerceDiscount(externalReferenceCode, userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, limitationTimesPerAccount, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount addCommerceDiscount(String externalReferenceCode, long userId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addCommerceDiscount(externalReferenceCode, userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, 0, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount addCommerceDiscount(String externalReferenceCode, long userId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, int limitationTimesPerAccount, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        this.validateExternalReferenceCode(externalReferenceCode, serviceContext.getCompanyId());
        User user = this._userLocalService.getUser(userId);
        this._validate(0L, serviceContext.getCompanyId(), title, target, useCouponCode, couponCode, maximumDiscountAmount, level1, level2, level3, level4, limitationType);
        Date date = new Date();
        Date displayDate = this._portal.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), CommerceDiscountDisplayDateException.class);
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), CommerceDiscountExpirationDateException.class);
        }
        long commerceDiscountId = this.counterLocalService.increment();
        CommerceDiscount commerceDiscount = this.commerceDiscountPersistence.create(commerceDiscountId);
        commerceDiscount.setExternalReferenceCode(externalReferenceCode);
        commerceDiscount.setCompanyId(user.getCompanyId());
        commerceDiscount.setUserId(user.getUserId());
        commerceDiscount.setUserName(user.getFullName());
        commerceDiscount.setTitle(title);
        commerceDiscount.setTarget(target);
        commerceDiscount.setUseCouponCode(useCouponCode);
        commerceDiscount.setCouponCode(couponCode);
        commerceDiscount.setUsePercentage(usePercentage);
        commerceDiscount.setMaximumDiscountAmount(maximumDiscountAmount);
        commerceDiscount.setLevel(level);
        if (!level.isEmpty()) {
            if (level.equals("L1")) {
                commerceDiscount.setLevel1(level1);
            } else if (level.equals("L2")) {
                commerceDiscount.setLevel2(level1);
            } else if (level.equals("L3")) {
                commerceDiscount.setLevel3(level1);
            } else if (level.equals("L4")) {
                commerceDiscount.setLevel4(level1);
            }
        } else {
            commerceDiscount.setLevel1(level1);
            commerceDiscount.setLevel2(level2);
            commerceDiscount.setLevel3(level3);
            commerceDiscount.setLevel4(level4);
        }
        commerceDiscount.setLimitationType(limitationType);
        commerceDiscount.setLimitationTimes(limitationTimes);
        commerceDiscount.setLimitationTimesPerAccount(limitationTimesPerAccount);
        commerceDiscount.setRulesConjunction(rulesConjunction);
        commerceDiscount.setActive(active);
        commerceDiscount.setDisplayDate(displayDate);
        commerceDiscount.setExpirationDate(expirationDate);
        if (expirationDate == null || expirationDate.after(date)) {
            commerceDiscount.setStatus(2);
        } else {
            commerceDiscount.setStatus(3);
        }
        commerceDiscount.setStatusByUserId(user.getUserId());
        commerceDiscount.setStatusDate(serviceContext.getModifiedDate(date));
        commerceDiscount.setExpandoBridgeAttributes(serviceContext);
        commerceDiscount = (CommerceDiscount)this.commerceDiscountPersistence.update((BaseModel)commerceDiscount);
        this._resourceLocalService.addModelResources((AuditedModel)commerceDiscount, serviceContext);
        return this.startWorkflowInstance(user.getUserId(), commerceDiscount, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount addOrUpdateCommerceDiscount(String externalReferenceCode, long userId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommerceDiscount(externalReferenceCode, userId, commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, "", level1, level2, level3, level4, limitationType, limitationTimes, 0, true, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount addOrUpdateCommerceDiscount(String externalReferenceCode, long userId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        CommerceDiscount commerceDiscount;
        block4: {
            if (commerceDiscountId > 0L) {
                try {
                    return this.commerceDiscountLocalService.updateCommerceDiscount(commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
                }
                catch (NoSuchDiscountException noSuchDiscountException) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)("Unable to find discount with ID: " + commerceDiscountId), (Throwable)noSuchDiscountException);
                }
            }
        }
        if (!Validator.isBlank((String)externalReferenceCode) && (commerceDiscount = this.commerceDiscountPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode)) != null) {
            return this.commerceDiscountLocalService.updateCommerceDiscount(commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
        }
        return this.commerceDiscountLocalService.addCommerceDiscount(externalReferenceCode, userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount addOrUpdateCommerceDiscount(String externalReferenceCode, long userId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, int limitationTimesPerAccount, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        CommerceDiscount commerceDiscount;
        block4: {
            if (commerceDiscountId > 0L) {
                try {
                    return this.commerceDiscountLocalService.updateCommerceDiscount(commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, limitationTimesPerAccount, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
                }
                catch (NoSuchDiscountException noSuchDiscountException) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)("Unable to find discount with ID: " + commerceDiscountId), (Throwable)noSuchDiscountException);
                }
            }
        }
        if (!Validator.isBlank((String)externalReferenceCode) && (commerceDiscount = this.commerceDiscountPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode)) != null) {
            return this.commerceDiscountLocalService.updateCommerceDiscount(commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, limitationTimesPerAccount, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
        }
        return this.commerceDiscountLocalService.addCommerceDiscount(externalReferenceCode, userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, limitationTimesPerAccount, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public void checkCommerceDiscounts() throws PortalException {
        this.checkCommerceDiscountsByDisplayDate();
        this.checkCommerceDiscountsByExpirationDate();
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceDiscount deleteCommerceDiscount(CommerceDiscount commerceDiscount) throws PortalException {
        this.commerceDiscountPersistence.remove((BaseModel)commerceDiscount);
        this._resourceLocalService.deleteResource(commerceDiscount.getCompanyId(), CommerceDiscount.class.getName(), 4, commerceDiscount.getCommerceDiscountId());
        this._commerceChannelAccountEntryRelLocalService.deleteCommerceChannelAccountEntryRels(CommerceDiscount.class.getName(), commerceDiscount.getCommerceDiscountId());
        this._commerceDiscountCommerceAccountGroupRelLocalService.deleteCommerceDiscountCommerceAccountGroupRelsByCommerceDiscountId(commerceDiscount.getCommerceDiscountId());
        this._commerceDiscountOrderTypeRelLocalService.deleteCommerceDiscountOrderTypeRels(commerceDiscount.getCommerceDiscountId());
        this._commerceDiscountRelLocalService.deleteCommerceDiscountRels(commerceDiscount.getCommerceDiscountId());
        this._commerceDiscountRuleLocalService.deleteCommerceDiscountRules(commerceDiscount.getCommerceDiscountId());
        this._commerceDiscountUsageEntryLocalService.deleteCommerceUsageEntryByDiscountId(commerceDiscount.getCommerceDiscountId());
        this._expandoRowLocalService.deleteRows(commerceDiscount.getCommerceDiscountId());
        this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(commerceDiscount.getCompanyId(), 0L, CommerceDiscount.class.getName(), commerceDiscount.getCommerceDiscountId());
        return commerceDiscount;
    }

    @Override
    public CommerceDiscount deleteCommerceDiscount(long commerceDiscountId) throws PortalException {
        CommerceDiscount commerceDiscount = this.commerceDiscountPersistence.findByPrimaryKey(commerceDiscountId);
        return this.commerceDiscountLocalService.deleteCommerceDiscount(commerceDiscount);
    }

    public void deleteCommerceDiscounts(long companyId) throws PortalException {
        List commerceDiscounts = this.commerceDiscountPersistence.findByCompanyId(companyId);
        for (CommerceDiscount commerceDiscount : commerceDiscounts) {
            this.commerceDiscountLocalService.deleteCommerceDiscount(commerceDiscount);
        }
    }

    @Deprecated
    public CommerceDiscount fetchByExternalReferenceCode(long companyId, String externalReferenceCode) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.commerceDiscountPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public CommerceDiscount fetchByExternalReferenceCode(String externalReferenceCode, long companyId) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.commerceDiscountPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public CommerceDiscount fetchDefaultCommerceDiscount(long commerceChannelAccountEntryRelId, long cpDefinitionId, long cpInstanceId) {
        List commerceDiscounts = (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), commerceChannelAccountEntryRelId, cpDefinitionId, cpInstanceId).limit(0, 1));
        if (commerceDiscounts.isEmpty()) {
            return null;
        }
        return (CommerceDiscount)commerceDiscounts.get(0);
    }

    public List<CommerceDiscount> getAccountAndChannelAndOrderTypeCommerceDiscounts(long commerceAccountId, long commerceChannelId, long commerceOrderTypeId, long cpDefinitionId, long cpInstanceId) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, commerceAccountId, null, commerceChannelId, commerceOrderTypeId, cpDefinitionId, cpInstanceId, null));
    }

    public List<CommerceDiscount> getAccountAndChannelAndOrderTypeCommerceDiscounts(long commerceAccountId, long commerceChannelId, long commerceOrderTypeId, String target) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, commerceAccountId, null, commerceChannelId, commerceOrderTypeId, null, null, target));
    }

    public List<CommerceDiscount> getAccountAndChannelCommerceDiscounts(long commerceAccountId, long commerceChannelId, long cpDefinitionId, long cpInstanceId) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, commerceAccountId, null, commerceChannelId, null, cpDefinitionId, cpInstanceId, null));
    }

    public List<CommerceDiscount> getAccountAndChannelCommerceDiscounts(long commerceAccountId, long commerceChannelId, String target) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, commerceAccountId, null, commerceChannelId, null, null, null, target));
    }

    public List<CommerceDiscount> getAccountAndOrderTypeCommerceDiscounts(long commerceAccountId, long commerceOrderTypeId, String target) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, commerceAccountId, null, null, commerceOrderTypeId, null, null, target));
    }

    public List<CommerceDiscount> getAccountCommerceAndOrderTypeDiscounts(long commerceAccountId, long commerceOrderTypeId, long cpDefinitionId, long cpInstanceId) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, commerceAccountId, null, null, commerceOrderTypeId, cpDefinitionId, cpInstanceId, null));
    }

    public List<CommerceDiscount> getAccountCommerceDiscounts(long commerceAccountId, long cpDefinitionId, long cpInstanceId) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, commerceAccountId, null, null, null, cpDefinitionId, cpInstanceId, null));
    }

    public List<CommerceDiscount> getAccountCommerceDiscounts(long commerceAccountId, String target) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, commerceAccountId, null, null, null, null, null, target));
    }

    public List<CommerceDiscount> getAccountGroupAndChannelAndOrderTypeCommerceDiscount(long[] commerceAccountGroupIds, long commerceChannelId, long commerceOrderTypeId, long cpDefinitionId, long cpInstanceId) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, null, commerceAccountGroupIds, commerceChannelId, commerceOrderTypeId, cpDefinitionId, cpInstanceId, null));
    }

    public List<CommerceDiscount> getAccountGroupAndChannelAndOrderTypeCommerceDiscount(long[] commerceAccountGroupIds, long commerceChannelId, long commerceOrderTypeId, String target) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, null, commerceAccountGroupIds, commerceChannelId, commerceOrderTypeId, null, null, target));
    }

    public List<CommerceDiscount> getAccountGroupAndChannelCommerceDiscount(long[] commerceAccountGroupIds, long commerceChannelId, long cpDefinitionId, long cpInstanceId) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, null, commerceAccountGroupIds, commerceChannelId, null, cpDefinitionId, cpInstanceId, null));
    }

    public List<CommerceDiscount> getAccountGroupAndChannelCommerceDiscount(long[] commerceAccountGroupIds, long commerceChannelId, String target) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, null, commerceAccountGroupIds, commerceChannelId, null, null, null, target));
    }

    public List<CommerceDiscount> getAccountGroupAndOrderTypeCommerceDiscount(long[] commerceAccountGroupIds, long commerceOrderTypeId, long cpDefinitionId, long cpInstanceId) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, null, commerceAccountGroupIds, null, commerceOrderTypeId, cpDefinitionId, cpInstanceId, null));
    }

    public List<CommerceDiscount> getAccountGroupAndOrderTypeCommerceDiscount(long[] commerceAccountGroupIds, long commerceOrderTypeId, String target) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, null, commerceAccountGroupIds, null, commerceOrderTypeId, null, null, target));
    }

    public List<CommerceDiscount> getAccountGroupCommerceDiscount(long[] commerceAccountGroupIds, long cpDefinitionId, long cpInstanceId) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, null, commerceAccountGroupIds, null, null, cpDefinitionId, cpInstanceId, null));
    }

    public List<CommerceDiscount> getAccountGroupCommerceDiscount(long[] commerceAccountGroupIds, String target) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, null, commerceAccountGroupIds, null, null, null, null, target));
    }

    public CommerceDiscount getActiveCommerceDiscount(long companyId, String couponCode, boolean active) throws PortalException {
        return this.commerceDiscountPersistence.findByC_C_A(companyId, couponCode, active);
    }

    public int getActiveCommerceDiscountsCount(long companyId, String couponCode, boolean active) {
        return this.commerceDiscountPersistence.countByC_C_A(companyId, couponCode, active);
    }

    public List<CommerceDiscount> getChannelAndOrderTypeCommerceDiscounts(long commerceChannelId, long commerceOrderTypeId, long cpDefinitionId, long cpInstanceId) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, null, null, commerceChannelId, commerceOrderTypeId, cpDefinitionId, cpInstanceId, null));
    }

    public List<CommerceDiscount> getChannelAndOrderTypeCommerceDiscounts(long commerceChannelId, long commerceOrderTypeId, String target) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, null, null, commerceChannelId, commerceOrderTypeId, null, null, target));
    }

    public List<CommerceDiscount> getChannelCommerceDiscounts(long commerceChannelId, long cpDefinitionId, long cpInstanceId) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, null, null, commerceChannelId, null, cpDefinitionId, cpInstanceId, null));
    }

    public List<CommerceDiscount> getChannelCommerceDiscounts(long commerceChannelId, String target) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, null, null, commerceChannelId, null, null, null, target));
    }

    @Deprecated
    public List<CommerceDiscount> getCommerceDiscounts(long companyId, String couponCode) {
        return this.commerceDiscountPersistence.findByC_C(companyId, couponCode);
    }

    public List<CommerceDiscount> getCommerceDiscounts(long companyId, String level, boolean active, int status) {
        return this.commerceDiscountPersistence.findByC_L_A_S(companyId, level, active, status);
    }

    @Deprecated
    public int getCommerceDiscountsCount(long companyId, String couponCode) {
        return this.commerceDiscountPersistence.countByC_C(companyId, couponCode);
    }

    public int getCommerceDiscountsCountByPricingClassId(long commercePricingClassId, String title) {
        return this.commerceDiscountFinder.countByCommercePricingClassId(commercePricingClassId, title);
    }

    public List<CommerceDiscount> getOrderTypeCommerceDiscounts(long commerceOrderTypeId, long cpDefinitionId, long cpInstanceId) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, null, null, null, commerceOrderTypeId, cpDefinitionId, cpInstanceId, null));
    }

    public List<CommerceDiscount> getOrderTypeCommerceDiscounts(long commerceOrderTypeId, String target) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), null, null, null, null, commerceOrderTypeId, null, null, target));
    }

    public List<CommerceDiscount> getPriceListCommerceDiscounts(long[] commerceDiscountIds, long cpDefinitionId) {
        return this.commerceDiscountFinder.findPriceListDiscountProduct(commerceDiscountIds, cpDefinitionId, this._getAssetCategoryIds(cpDefinitionId), this._commercePricingClassLocalService.getCommercePricingClassByCPDefinition(cpDefinitionId));
    }

    public List<CommerceDiscount> getUnqualifiedCommerceDiscounts(long companyId, long cpDefinitionId, long cpInstanceId) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), companyId, null, null, null, null, cpDefinitionId, cpInstanceId, null));
    }

    public List<CommerceDiscount> getUnqualifiedCommerceDiscounts(long companyId, String target) {
        return (List)this.dslQuery((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountTable.INSTANCE), companyId, null, null, null, null, null, null, target));
    }

    public int getValidCommerceDiscountsCount(long commerceDiscountId, long cpDefinitionId, long cpInstanceId) {
        return this.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.countDistinct((Expression)CommerceDiscountTable.INSTANCE.commerceDiscountId).from((Table)CommerceDiscountTable.INSTANCE).innerJoinON((Table)CommerceDiscountRelTable.INSTANCE, CommerceDiscountRelTable.INSTANCE.commerceDiscountId.eq((Expression)CommerceDiscountTable.INSTANCE.commerceDiscountId)).where(CommerceDiscountTable.INSTANCE.commerceDiscountId.eq((Object)commerceDiscountId).and((Expression)this._toTargetPredicate(cpDefinitionId, cpInstanceId))));
    }

    public int getValidCommerceDiscountsCount(long commerceAccountId, long[] commerceAccountGroupIds, long commerceChannelId, long commerceDiscountId) {
        return this.commerceDiscountFinder.countByValidCommerceDiscount(commerceAccountId, commerceAccountGroupIds, commerceChannelId, commerceDiscountId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount incrementCommerceDiscountNumberOfUse(long commerceDiscountId) throws PortalException {
        CommerceDiscount commerceDiscount = this.commerceDiscountPersistence.findByPrimaryKey(commerceDiscountId);
        commerceDiscount.setNumberOfUse(commerceDiscount.getNumberOfUse() + 1);
        return (CommerceDiscount)this.commerceDiscountPersistence.update((BaseModel)commerceDiscount);
    }

    public List<CommerceDiscount> searchByCommercePricingClassId(long commercePricingClassId, String title, int start, int end) {
        return this.commerceDiscountFinder.findByCommercePricingClassId(commercePricingClassId, title, start, end);
    }

    public BaseModelSearchResult<CommerceDiscount> searchCommerceDiscounts(long companyId, long[] groupIds, String keywords, int status, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, keywords, status, start, end, sort);
        return this.searchCommerceDiscounts(searchContext);
    }

    public BaseModelSearchResult<CommerceDiscount> searchCommerceDiscounts(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceDiscount.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceDiscount> commerceDiscounts = this.getCommerceDiscounts(hits);
            if (commerceDiscounts == null) continue;
            return new BaseModelSearchResult(commerceDiscounts, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount updateCommerceDiscount(long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.updateCommerceDiscount(commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, "", level1, level2, level3, level4, limitationType, limitationTimes, 0, true, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount updateCommerceDiscount(long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        CommerceDiscount commerceDiscount = this.commerceDiscountPersistence.findByPrimaryKey(commerceDiscountId);
        this._validate(commerceDiscountId, serviceContext.getCompanyId(), title, target, useCouponCode, couponCode, maximumDiscountAmount, level1, level2, level3, level4, limitationType);
        Date date = new Date();
        Date displayDate = this._portal.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), CommerceDiscountDisplayDateException.class);
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), CommerceDiscountExpirationDateException.class);
        }
        commerceDiscount.setTitle(title);
        commerceDiscount.setTarget(target);
        commerceDiscount.setUseCouponCode(useCouponCode);
        commerceDiscount.setCouponCode(couponCode);
        commerceDiscount.setUsePercentage(usePercentage);
        commerceDiscount.setMaximumDiscountAmount(maximumDiscountAmount);
        commerceDiscount.setLevel(level);
        commerceDiscount.setLevel1(level1);
        commerceDiscount.setLevel2(level2);
        commerceDiscount.setLevel3(level3);
        commerceDiscount.setLevel4(level4);
        commerceDiscount.setLimitationType(limitationType);
        commerceDiscount.setLimitationTimes(limitationTimes);
        commerceDiscount.setRulesConjunction(rulesConjunction);
        commerceDiscount.setActive(active);
        commerceDiscount.setDisplayDate(displayDate);
        commerceDiscount.setExpirationDate(expirationDate);
        if (expirationDate == null || expirationDate.after(date)) {
            commerceDiscount.setStatus(2);
        } else {
            commerceDiscount.setStatus(3);
        }
        commerceDiscount.setStatusByUserId(user.getUserId());
        commerceDiscount.setStatusDate(serviceContext.getModifiedDate(date));
        commerceDiscount.setExpandoBridgeAttributes(serviceContext);
        commerceDiscount = (CommerceDiscount)this.commerceDiscountPersistence.update((BaseModel)commerceDiscount);
        return this.startWorkflowInstance(user.getUserId(), commerceDiscount, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount updateCommerceDiscount(long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, int limitationTimesPerAccount, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        CommerceDiscount commerceDiscount = this.commerceDiscountPersistence.findByPrimaryKey(commerceDiscountId);
        this._validate(commerceDiscountId, serviceContext.getCompanyId(), title, target, useCouponCode, couponCode, maximumDiscountAmount, level1, level2, level3, level4, limitationType);
        Date date = new Date();
        Date displayDate = this._portal.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), CommerceDiscountDisplayDateException.class);
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = this._portal.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), CommerceDiscountExpirationDateException.class);
        }
        commerceDiscount.setTitle(title);
        commerceDiscount.setTarget(target);
        commerceDiscount.setUseCouponCode(useCouponCode);
        commerceDiscount.setCouponCode(couponCode);
        commerceDiscount.setUsePercentage(usePercentage);
        commerceDiscount.setMaximumDiscountAmount(maximumDiscountAmount);
        commerceDiscount.setLevel(level);
        commerceDiscount.setLevel1(level1);
        commerceDiscount.setLevel2(level2);
        commerceDiscount.setLevel3(level3);
        commerceDiscount.setLevel4(level4);
        commerceDiscount.setLimitationType(limitationType);
        commerceDiscount.setLimitationTimes(limitationTimes);
        commerceDiscount.setLimitationTimesPerAccount(limitationTimesPerAccount);
        commerceDiscount.setRulesConjunction(rulesConjunction);
        commerceDiscount.setActive(active);
        commerceDiscount.setDisplayDate(displayDate);
        commerceDiscount.setExpirationDate(expirationDate);
        if (expirationDate == null || expirationDate.after(date)) {
            commerceDiscount.setStatus(2);
        } else {
            commerceDiscount.setStatus(3);
        }
        commerceDiscount.setStatusByUserId(user.getUserId());
        commerceDiscount.setStatusDate(serviceContext.getModifiedDate(date));
        commerceDiscount.setExpandoBridgeAttributes(serviceContext);
        commerceDiscount = (CommerceDiscount)this.commerceDiscountPersistence.update((BaseModel)commerceDiscount);
        return this.startWorkflowInstance(user.getUserId(), commerceDiscount, serviceContext);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount updateCommerceDiscountExternalReferenceCode(long commerceDiscountId, String externalReferenceCode) throws PortalException {
        return this.updateCommerceDiscountExternalReferenceCode(externalReferenceCode, commerceDiscountId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount updateCommerceDiscountExternalReferenceCode(String externalReferenceCode, long commerceDiscountId) throws PortalException {
        CommerceDiscount commerceDiscount = this.commerceDiscountLocalService.getCommerceDiscount(commerceDiscountId);
        commerceDiscount.setExternalReferenceCode(externalReferenceCode);
        return this.commerceDiscountLocalService.updateCommerceDiscount(commerceDiscount);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount updateStatus(long userId, long commerceDiscountId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        Date date = new Date();
        CommerceDiscount commerceDiscount = this.commerceDiscountPersistence.findByPrimaryKey(commerceDiscountId);
        if (status == 0 && commerceDiscount.getDisplayDate() != null && date.before(commerceDiscount.getDisplayDate())) {
            commerceDiscount.setActive(false);
            status = 7;
        }
        if (status == 0) {
            Date expirationDate = commerceDiscount.getExpirationDate();
            if (expirationDate != null && expirationDate.before(date)) {
                commerceDiscount.setExpirationDate(null);
            }
            if (commerceDiscount.getStatus() == 7) {
                commerceDiscount.setActive(true);
            }
        }
        if (status == 3) {
            commerceDiscount.setActive(false);
            commerceDiscount.setExpirationDate(date);
        }
        commerceDiscount.setStatus(status);
        commerceDiscount.setStatusByUserId(user.getUserId());
        commerceDiscount.setStatusByUserName(user.getFullName());
        commerceDiscount.setStatusDate(serviceContext.getModifiedDate(date));
        return (CommerceDiscount)this.commerceDiscountPersistence.update((BaseModel)commerceDiscount);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount upsertCommerceDiscount(long userId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, String externalReferenceCode, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommerceDiscount(externalReferenceCode, userId, commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, "", level1, level2, level3, level4, limitationType, limitationTimes, 0, true, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount upsertCommerceDiscount(long userId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, String externalReferenceCode, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommerceDiscount(externalReferenceCode, userId, commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount upsertCommerceDiscount(long userId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, int limitationTimesPerAccount, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, String externalReferenceCode, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommerceDiscount(externalReferenceCode, userId, commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, limitationTimesPerAccount, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    protected SearchContext buildSearchContext(long companyId, long[] groupIds, String keywords, int status, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"groupIds", (Object)groupIds).put((Object)"entryClassPK", (Object)keywords).put((Object)"status", (Object)status).put((Object)"title", (Object)keywords).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).put((Object)"skipCommerceAccountGroupValidation", (Object)true).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected void checkCommerceDiscountsByDisplayDate() throws PortalException {
        List commerceDiscounts = this.commerceDiscountPersistence.findByLtD_S(new Date(), 7);
        for (CommerceDiscount commerceDiscount : commerceDiscounts) {
            long userId = this._portal.getValidUserId(commerceDiscount.getCompanyId(), commerceDiscount.getUserId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            this.commerceDiscountLocalService.updateStatus(userId, commerceDiscount.getCommerceDiscountId(), 0, serviceContext, new HashMap());
        }
    }

    protected void checkCommerceDiscountsByExpirationDate() throws PortalException {
        List commerceDiscounts = this.commerceDiscountPersistence.findByLtE_S(new Date(), 0);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Expiring " + commerceDiscounts.size() + " commerce discounts"));
        }
        if (commerceDiscounts != null && !commerceDiscounts.isEmpty()) {
            for (CommerceDiscount commerceDiscount : commerceDiscounts) {
                long userId = this._portal.getValidUserId(commerceDiscount.getCompanyId(), commerceDiscount.getUserId());
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCommand("update");
                this.commerceDiscountLocalService.updateStatus(userId, commerceDiscount.getCommerceDiscountId(), 3, serviceContext, new HashMap());
            }
        }
    }

    protected List<CommerceDiscount> getCommerceDiscounts(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceDiscount> commerceDiscounts = new ArrayList<CommerceDiscount>(documents.size());
        for (Document document : documents) {
            long commerceDiscountId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceDiscount commerceDiscount = this.fetchCommerceDiscount(commerceDiscountId);
            if (commerceDiscount == null) {
                commerceDiscounts = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceDiscount.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceDiscounts == null) continue;
            commerceDiscounts.add(commerceDiscount);
        }
        return commerceDiscounts;
    }

    protected CommerceDiscount startWorkflowInstance(long userId, CommerceDiscount commerceDiscount, ServiceContext serviceContext) throws PortalException {
        HashMap workflowContext = new HashMap();
        return (CommerceDiscount)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)commerceDiscount.getCompanyId(), (long)0L, (long)userId, (String)CommerceDiscount.class.getName(), (long)commerceDiscount.getCommerceDiscountId(), (Object)commerceDiscount, (ServiceContext)serviceContext, workflowContext);
    }

    protected void validateExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        CommerceDiscount commerceDiscount = this.commerceDiscountPersistence.fetchByC_ERC(companyId, externalReferenceCode);
        if (commerceDiscount != null) {
            throw new DuplicateCommerceDiscountException("There is another commerce discount with external reference code " + externalReferenceCode);
        }
    }

    private long[] _getAssetCategoryIds(long cpDefinitionId) {
        try {
            AssetEntry assetEntry = this._assetEntryLocalService.getEntry(CPDefinition.class.getName(), cpDefinitionId);
            HashSet<AssetCategory> assetCategories = new HashSet<AssetCategory>();
            for (AssetCategory assetCategory : assetEntry.getCategories()) {
                assetCategories.add(assetCategory);
                assetCategories.addAll(assetCategory.getAncestors());
            }
            Stream stream = assetCategories.stream();
            LongStream longStream = stream.mapToLong(AssetCategoryModel::getCategoryId);
            return longStream.toArray();
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return new long[0];
        }
    }

    private GroupByStep _getGroupByStep(FromStep fromStep, long commerceChannelAccountEntryRelId, long cpDefinitionId, long cpInstanceId) {
        JoinStep joinStep = fromStep.from((Table)CommerceDiscountTable.INSTANCE).innerJoinON((Table)CommerceChannelAccountEntryRelTable.INSTANCE, CommerceChannelAccountEntryRelTable.INSTANCE.classPK.eq((Expression)CommerceDiscountTable.INSTANCE.commerceDiscountId)).innerJoinON((Table)CommerceDiscountRelTable.INSTANCE, CommerceDiscountRelTable.INSTANCE.commerceDiscountId.eq((Expression)CommerceDiscountTable.INSTANCE.commerceDiscountId));
        Predicate predicate = CommerceChannelAccountEntryRelTable.INSTANCE.commerceChannelAccountEntryRelId.eq((Object)commerceChannelAccountEntryRelId).and((Expression)CommerceDiscountTable.INSTANCE.active.eq((Object)true));
        return joinStep.where(predicate.and((Expression)this._toTargetPredicate(cpDefinitionId, cpInstanceId)));
    }

    private GroupByStep _getGroupByStep(FromStep fromStep, Long companyId, Long commerceAccountId, long[] commerceAccountGroupIds, Long commerceChannelId, Long commerceOrderTypeId, Long cpDefinitionId, Long cpInstanceId, String target) {
        JoinStep joinStep = fromStep.from((Table)CommerceDiscountTable.INSTANCE);
        Predicate predicate = CommerceDiscountTable.INSTANCE.active.eq((Object)true).and(() -> {
            if (companyId != null) {
                return CommerceDiscountTable.INSTANCE.companyId.eq((Object)companyId);
            }
            return null;
        });
        if (commerceAccountId != null) {
            joinStep = joinStep.innerJoinON((Table)CommerceDiscountAccountRelTable.INSTANCE, CommerceDiscountAccountRelTable.INSTANCE.commerceDiscountId.eq((Expression)CommerceDiscountTable.INSTANCE.commerceDiscountId));
            predicate = predicate.and((Expression)CommerceDiscountAccountRelTable.INSTANCE.commerceAccountId.eq((Object)commerceAccountId));
        } else {
            joinStep = joinStep.leftJoinOn((Table)CommerceDiscountAccountRelTable.INSTANCE, CommerceDiscountAccountRelTable.INSTANCE.commerceDiscountId.eq((Expression)CommerceDiscountTable.INSTANCE.commerceDiscountId));
            predicate = predicate.and((Expression)CommerceDiscountAccountRelTable.INSTANCE.commerceDiscountAccountRelId.isNull());
        }
        if (commerceAccountGroupIds != null) {
            if (commerceAccountGroupIds.length == 0) {
                commerceAccountGroupIds = new long[]{0L};
            }
            joinStep = joinStep.innerJoinON((Table)CommerceDiscountCommerceAccountGroupRelTable.INSTANCE, CommerceDiscountCommerceAccountGroupRelTable.INSTANCE.commerceDiscountId.eq((Expression)CommerceDiscountTable.INSTANCE.commerceDiscountId));
            LongStream longStream = Arrays.stream(commerceAccountGroupIds);
            predicate = predicate.and((Expression)CommerceDiscountCommerceAccountGroupRelTable.INSTANCE.commerceAccountGroupId.in((Object[])longStream.boxed().toArray(Long[]::new)));
        } else {
            joinStep = joinStep.leftJoinOn((Table)CommerceDiscountCommerceAccountGroupRelTable.INSTANCE, CommerceDiscountCommerceAccountGroupRelTable.INSTANCE.commerceDiscountId.eq((Expression)CommerceDiscountTable.INSTANCE.commerceDiscountId));
            predicate = predicate.and((Expression)CommerceDiscountCommerceAccountGroupRelTable.INSTANCE.commerceDiscountCommerceAccountGroupRelId.isNull());
        }
        if (commerceChannelId != null) {
            joinStep = joinStep.innerJoinON((Table)CommerceChannelRelTable.INSTANCE, CommerceChannelRelTable.INSTANCE.classPK.eq((Expression)CommerceDiscountTable.INSTANCE.commerceDiscountId).and((Expression)CommerceChannelRelTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(CommerceDiscount.class.getName()))));
            predicate = predicate.and((Expression)CommerceChannelRelTable.INSTANCE.commerceChannelId.eq((Object)commerceChannelId));
        } else {
            joinStep = joinStep.leftJoinOn((Table)CommerceChannelRelTable.INSTANCE, CommerceChannelRelTable.INSTANCE.classPK.eq((Expression)CommerceDiscountTable.INSTANCE.commerceDiscountId).and((Expression)CommerceChannelRelTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(CommerceDiscount.class.getName()))));
            predicate = predicate.and((Expression)CommerceChannelRelTable.INSTANCE.commerceChannelRelId.isNull());
        }
        if (commerceOrderTypeId != null) {
            joinStep = joinStep.innerJoinON((Table)CommerceDiscountOrderTypeRelTable.INSTANCE, CommerceDiscountOrderTypeRelTable.INSTANCE.commerceDiscountId.eq((Expression)CommerceDiscountTable.INSTANCE.commerceDiscountId));
            predicate = predicate.and((Expression)CommerceDiscountOrderTypeRelTable.INSTANCE.commerceOrderTypeId.eq((Object)commerceOrderTypeId));
        } else {
            joinStep = joinStep.leftJoinOn((Table)CommerceDiscountOrderTypeRelTable.INSTANCE, CommerceDiscountOrderTypeRelTable.INSTANCE.commerceDiscountId.eq((Expression)CommerceDiscountTable.INSTANCE.commerceDiscountId));
            predicate = predicate.and((Expression)CommerceDiscountOrderTypeRelTable.INSTANCE.commerceDiscountOrderTypeRelId.isNull());
        }
        if (!Validator.isBlank((String)target)) {
            return joinStep.where(predicate.and((Expression)CommerceDiscountTable.INSTANCE.target.eq((Object)target)));
        }
        joinStep = joinStep.innerJoinON((Table)CommerceDiscountRelTable.INSTANCE, CommerceDiscountRelTable.INSTANCE.commerceDiscountId.eq((Expression)CommerceDiscountTable.INSTANCE.commerceDiscountId));
        return joinStep.where(predicate.and((Expression)this._toTargetPredicate(cpDefinitionId, cpInstanceId)));
    }

    private Predicate _toTargetPredicate(long cpDefinitionId, long cpInstanceId) {
        long[] commercePricingClasses;
        Predicate predicate = CommerceDiscountTable.INSTANCE.target.eq((Object)"products").and((Expression)CommerceDiscountRelTable.INSTANCE.classPK.eq((Object)cpDefinitionId)).and((Expression)CommerceDiscountRelTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(CPDefinition.class.getName())));
        predicate = predicate.or((Expression)CommerceDiscountTable.INSTANCE.target.eq((Object)"skus").and((Expression)CommerceDiscountRelTable.INSTANCE.classPK.eq((Object)cpInstanceId)).and((Expression)CommerceDiscountRelTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(CPInstance.class.getName()))));
        long[] assetCategoryIds = this._getAssetCategoryIds(cpDefinitionId);
        if (assetCategoryIds != null) {
            if (assetCategoryIds.length == 0) {
                assetCategoryIds = new long[]{0L};
            }
            LongStream assetCategoryIdsLongStream = Arrays.stream(assetCategoryIds);
            predicate = predicate.or((Expression)CommerceDiscountTable.INSTANCE.target.eq((Object)"categories").and((Expression)CommerceDiscountRelTable.INSTANCE.classPK.in((Object[])assetCategoryIdsLongStream.boxed().toArray(Long[]::new))).and((Expression)CommerceDiscountRelTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(AssetCategory.class.getName()))));
        }
        if ((commercePricingClasses = this._commercePricingClassLocalService.getCommercePricingClassByCPDefinition(cpDefinitionId)) != null) {
            if (commercePricingClasses.length == 0) {
                commercePricingClasses = new long[]{0L};
            }
            LongStream commercePricingClassesLongStream = Arrays.stream(commercePricingClasses);
            predicate = predicate.or((Expression)CommerceDiscountTable.INSTANCE.target.eq((Object)"product-groups").and((Expression)CommerceDiscountRelTable.INSTANCE.classPK.in((Object[])commercePricingClassesLongStream.boxed().toArray(Long[]::new))).and((Expression)CommerceDiscountRelTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(CommercePricingClass.class.getName()))));
        }
        return predicate.withParentheses();
    }

    private void _validate(long commerceDiscountId, long companyId, String title, String target, boolean useCouponCode, String couponCode, BigDecimal maxDiscountAmount, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new CommerceDiscountTitleException();
        }
        CommerceDiscountTarget commerceDiscountTarget = this._commerceDiscountTargetRegistry.getCommerceDiscountTarget(target);
        if (commerceDiscountTarget == null) {
            throw new CommerceDiscountTargetException();
        }
        if (useCouponCode) {
            if (Validator.isNull((String)couponCode)) {
                throw new CommerceDiscountCouponCodeException();
            }
            CommerceDiscount commerceDiscount = this.commerceDiscountPersistence.fetchByC_C_First(companyId, couponCode, (OrderByComparator)new CommerceDiscountCreateDateComparator(true));
            if (commerceDiscountId <= 0L && commerceDiscount != null || commerceDiscount != null && commerceDiscountId != commerceDiscount.getCommerceDiscountId()) {
                throw new DuplicateCommerceDiscountException();
            }
        }
        if (Validator.isNull((String)limitationType)) {
            throw new CommerceDiscountLimitationTypeException();
        }
        BigDecimal maxValue = BigDecimal.valueOf(GetterUtil.getDouble((String)"999999999.99"));
        if (maxDiscountAmount != null && maxDiscountAmount.compareTo(maxValue) > 0 || level1 != null && level1.compareTo(maxValue) > 0 || level2 != null && level2.compareTo(maxValue) > 0 || level3 != null && level3.compareTo(maxValue) > 0 || level4 != null && level4.compareTo(maxValue) > 0) {
            throw new CommerceDiscountMaxPriceValueException();
        }
    }
}

