/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.service.impl;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountOrderTypeRel;
import com.liferay.commerce.discount.model.CommerceDiscountOrderTypeRelTable;
import com.liferay.commerce.discount.service.base.CommerceDiscountOrderTypeRelLocalServiceBaseImpl;
import com.liferay.commerce.model.CommerceOrderTypeTable;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.discount.model.CommerceDiscountOrderTypeRel"}, service={AopService.class})
public class CommerceDiscountOrderTypeRelLocalServiceImpl
extends CommerceDiscountOrderTypeRelLocalServiceBaseImpl {
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public CommerceDiscountOrderTypeRel addCommerceDiscountOrderTypeRel(long userId, long commerceDiscountId, long commerceOrderTypeId, int priority, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        CommerceDiscountOrderTypeRel commerceDiscountOrderTypeRel = this.commerceDiscountOrderTypeRelPersistence.create(this.counterLocalService.increment());
        commerceDiscountOrderTypeRel.setCompanyId(user.getCompanyId());
        commerceDiscountOrderTypeRel.setUserId(user.getUserId());
        commerceDiscountOrderTypeRel.setUserName(user.getFullName());
        commerceDiscountOrderTypeRel.setCommerceDiscountId(commerceDiscountId);
        commerceDiscountOrderTypeRel.setCommerceOrderTypeId(commerceOrderTypeId);
        commerceDiscountOrderTypeRel.setPriority(priority);
        commerceDiscountOrderTypeRel.setExpandoBridgeAttributes(serviceContext);
        commerceDiscountOrderTypeRel = (CommerceDiscountOrderTypeRel)this.commerceDiscountOrderTypeRelPersistence.update((BaseModel)commerceDiscountOrderTypeRel);
        this.reindexCommerceDiscount(commerceDiscountId);
        return commerceDiscountOrderTypeRel;
    }

    @Override
    @SystemEvent(type=1)
    public CommerceDiscountOrderTypeRel deleteCommerceDiscountOrderTypeRel(CommerceDiscountOrderTypeRel commerceDiscountOrderTypeRel) throws PortalException {
        this.commerceDiscountOrderTypeRelPersistence.remove((BaseModel)commerceDiscountOrderTypeRel);
        this._expandoRowLocalService.deleteRows(commerceDiscountOrderTypeRel.getCommerceDiscountOrderTypeRelId());
        this.reindexCommerceDiscount(commerceDiscountOrderTypeRel.getCommerceDiscountId());
        return commerceDiscountOrderTypeRel;
    }

    @Override
    public CommerceDiscountOrderTypeRel deleteCommerceDiscountOrderTypeRel(long commerceDiscountOrderTypeRelId) throws PortalException {
        CommerceDiscountOrderTypeRel commerceDiscountOrderTypeRel = this.commerceDiscountOrderTypeRelPersistence.findByPrimaryKey(commerceDiscountOrderTypeRelId);
        return this.commerceDiscountOrderTypeRelLocalService.deleteCommerceDiscountOrderTypeRel(commerceDiscountOrderTypeRel);
    }

    public void deleteCommerceDiscountOrderTypeRels(long commerceDiscountId) {
        this.commerceDiscountOrderTypeRelPersistence.removeByCommerceDiscountId(commerceDiscountId);
    }

    public CommerceDiscountOrderTypeRel fetchCommerceDiscountOrderTypeRel(long commerceDiscountId, long commerceOrderTypeId) {
        return this.commerceDiscountOrderTypeRelPersistence.fetchByCDI_COTI(commerceDiscountId, commerceOrderTypeId);
    }

    @Override
    public CommerceDiscountOrderTypeRel getCommerceDiscountOrderTypeRel(long commerceDiscountOrderTypeRelId) throws PortalException {
        return this.commerceDiscountOrderTypeRelPersistence.findByPrimaryKey(commerceDiscountOrderTypeRelId);
    }

    public List<CommerceDiscountOrderTypeRel> getCommerceDiscountOrderTypeRels(long commerceDiscountId) {
        return this.commerceDiscountOrderTypeRelPersistence.findByCommerceDiscountId(commerceDiscountId);
    }

    public List<CommerceDiscountOrderTypeRel> getCommerceDiscountOrderTypeRels(long commerceDiscountId, String name, int start, int end, OrderByComparator<CommerceDiscountOrderTypeRel> orderByComparator) throws PortalException {
        return (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountOrderTypeRelTable.INSTANCE), commerceDiscountId, name).orderBy((Table)CommerceDiscountOrderTypeRelTable.INSTANCE, orderByComparator).limit(start, end));
    }

    public int getCommerceDiscountOrderTypeRelsCount(long commerceDiscountId, String name) throws PortalException {
        return this.dslQueryCount((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)CommerceDiscountOrderTypeRelTable.INSTANCE.commerceDiscountOrderTypeRelId), commerceDiscountId, name));
    }

    protected void reindexCommerceDiscount(long commerceDiscountId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceDiscount.class);
        indexer.reindex(CommerceDiscount.class.getName(), commerceDiscountId);
    }

    private GroupByStep _getGroupByStep(FromStep fromStep, Long commerceDiscountId, String keywords) throws PortalException {
        JoinStep joinStep = fromStep.from((Table)CommerceDiscountOrderTypeRelTable.INSTANCE).innerJoinON((Table)CommerceOrderTypeTable.INSTANCE, CommerceOrderTypeTable.INSTANCE.commerceOrderTypeId.eq((Expression)CommerceDiscountOrderTypeRelTable.INSTANCE.commerceOrderTypeId));
        return joinStep.where(() -> {
            Predicate predicate = CommerceDiscountOrderTypeRelTable.INSTANCE.commerceDiscountId.eq((Object)commerceDiscountId);
            if (Validator.isNotNull((String)keywords)) {
                predicate = predicate.and((Expression)Predicate.withParentheses((Predicate)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)CommerceOrderTypeTable.INSTANCE.name), this._customSQL.keywords(keywords, true))));
            }
            return predicate;
        });
    }
}

