/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.service.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetCategoryTable;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRel;
import com.liferay.commerce.discount.model.CommerceDiscountRelModel;
import com.liferay.commerce.discount.model.CommerceDiscountRelTable;
import com.liferay.commerce.discount.service.base.CommerceDiscountRelLocalServiceBaseImpl;
import com.liferay.commerce.discount.service.persistence.CommerceDiscountPersistence;
import com.liferay.commerce.discount.util.comparator.CommerceDiscountRelCreateDateComparator;
import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.model.CommercePricingClassTable;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionLocalizationTable;
import com.liferay.commerce.product.model.CPDefinitionTable;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPInstanceTable;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.discount.model.CommerceDiscountRel"}, service={AopService.class})
public class CommerceDiscountRelLocalServiceImpl
extends CommerceDiscountRelLocalServiceBaseImpl {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CommerceDiscountPersistence _commerceDiscountPersistence;
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private UserLocalService _userLocalService;

    public CommerceDiscountRel addCommerceDiscountRel(long commerceDiscountId, String className, long classPK, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        long commerceDiscountRelId = this.counterLocalService.increment();
        CommerceDiscountRel commerceDiscountRel = this.commerceDiscountRelPersistence.create(commerceDiscountRelId);
        commerceDiscountRel.setCompanyId(user.getCompanyId());
        commerceDiscountRel.setUserId(user.getUserId());
        commerceDiscountRel.setUserName(user.getFullName());
        commerceDiscountRel.setCommerceDiscountId(commerceDiscountId);
        commerceDiscountRel.setClassName(className);
        commerceDiscountRel.setClassPK(classPK);
        commerceDiscountRel = (CommerceDiscountRel)this.commerceDiscountRelPersistence.update((BaseModel)commerceDiscountRel);
        this.reindexCommerceDiscount(commerceDiscountId);
        return commerceDiscountRel;
    }

    @Override
    @SystemEvent(type=1)
    public CommerceDiscountRel deleteCommerceDiscountRel(CommerceDiscountRel commerceDiscountRel) throws PortalException {
        this.commerceDiscountRelPersistence.remove((BaseModel)commerceDiscountRel);
        this.reindexCommerceDiscount(commerceDiscountRel.getCommerceDiscountId());
        return commerceDiscountRel;
    }

    @Override
    public CommerceDiscountRel deleteCommerceDiscountRel(long commerceDiscountRelId) throws PortalException {
        CommerceDiscountRel commerceDiscountRel = this.commerceDiscountRelPersistence.findByPrimaryKey(commerceDiscountRelId);
        return this.commerceDiscountRelLocalService.deleteCommerceDiscountRel(commerceDiscountRel);
    }

    public void deleteCommerceDiscountRels(long commerceDiscountId) throws PortalException {
        List commerceDiscountRels = this.commerceDiscountRelPersistence.findByCommerceDiscountId(commerceDiscountId);
        for (CommerceDiscountRel commerceDiscountRel : commerceDiscountRels) {
            this.commerceDiscountRelLocalService.deleteCommerceDiscountRel(commerceDiscountRel);
        }
    }

    public void deleteCommerceDiscountRels(String className, long classPK) throws PortalException {
        List commerceDiscountRels = this.commerceDiscountRelPersistence.findByCN_CPK(this._classNameLocalService.getClassNameId(className), classPK);
        for (CommerceDiscountRel commerceDiscountRel : commerceDiscountRels) {
            this.commerceDiscountRelLocalService.deleteCommerceDiscountRel(commerceDiscountRel);
        }
    }

    public CommerceDiscountRel fetchCommerceDiscountRel(String className, long classPK) {
        return this.commerceDiscountRelPersistence.fetchByCN_CPK_First(this._classNameLocalService.getClassNameId(className), classPK, (OrderByComparator)new CommerceDiscountRelCreateDateComparator());
    }

    public List<CommerceDiscountRel> getCategoriesByCommerceDiscountId(long commerceDiscountId, String name, int start, int end) {
        return (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountRelTable.INSTANCE).from((Table)CommerceDiscountRelTable.INSTANCE).innerJoinON((Table)AssetCategoryTable.INSTANCE, AssetCategoryTable.INSTANCE.categoryId.eq((Expression)CommerceDiscountRelTable.INSTANCE.classPK)), AssetCategory.class.getName(), commerceDiscountId, name, (Expression<String>)AssetCategoryTable.INSTANCE.name).limit(start, end));
    }

    public int getCategoriesByCommerceDiscountIdCount(long commerceDiscountId, String name) {
        return this.dslQueryCount((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)CommerceDiscountRelTable.INSTANCE.commerceDiscountRelId).from((Table)CommerceDiscountRelTable.INSTANCE).innerJoinON((Table)AssetCategoryTable.INSTANCE, AssetCategoryTable.INSTANCE.categoryId.eq((Expression)CommerceDiscountRelTable.INSTANCE.classPK)), AssetCategory.class.getName(), commerceDiscountId, name, (Expression<String>)AssetCategoryTable.INSTANCE.name));
    }

    public long[] getClassPKs(long commerceDiscountId, String className) {
        return ListUtil.toLongArray((List)this.commerceDiscountRelPersistence.findByCD_CN(commerceDiscountId, this._classNameLocalService.getClassNameId(className)), CommerceDiscountRelModel::getClassPK);
    }

    public List<CommerceDiscountRel> getCommerceDiscountRels(long commerceDiscountId, String className) {
        return this.commerceDiscountRelPersistence.findByCD_CN(commerceDiscountId, this._classNameLocalService.getClassNameId(className));
    }

    public List<CommerceDiscountRel> getCommerceDiscountRels(long commerceDiscountId, String className, int start, int end, OrderByComparator<CommerceDiscountRel> orderByComparator) {
        return this.commerceDiscountRelPersistence.findByCD_CN(commerceDiscountId, this._classNameLocalService.getClassNameId(className), start, end, orderByComparator);
    }

    public int getCommerceDiscountRelsCount(long commerceDiscountId, String className) {
        return this.commerceDiscountRelPersistence.countByCD_CN(commerceDiscountId, this._classNameLocalService.getClassNameId(className));
    }

    public List<CommerceDiscountRel> getCommercePricingClassesByCommerceDiscountId(long commerceDiscountId, String title, int start, int end) {
        return (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountRelTable.INSTANCE).from((Table)CommerceDiscountRelTable.INSTANCE).innerJoinON((Table)CommercePricingClassTable.INSTANCE, CommercePricingClassTable.INSTANCE.commercePricingClassId.eq((Expression)CommerceDiscountRelTable.INSTANCE.classPK)), CommercePricingClass.class.getName(), commerceDiscountId, title, (Expression<String>)CommercePricingClassTable.INSTANCE.title).limit(start, end));
    }

    public int getCommercePricingClassesByCommerceDiscountIdCount(long commerceDiscountId, String title) {
        return this.dslQueryCount((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)CommerceDiscountRelTable.INSTANCE.commerceDiscountRelId).from((Table)CommerceDiscountRelTable.INSTANCE).innerJoinON((Table)CommercePricingClassTable.INSTANCE, CommercePricingClassTable.INSTANCE.commercePricingClassId.eq((Expression)CommerceDiscountRelTable.INSTANCE.classPK)), CommercePricingClass.class.getName(), commerceDiscountId, title, (Expression<String>)CommercePricingClassTable.INSTANCE.title));
    }

    public List<CommerceDiscountRel> getCPDefinitionsByCommerceDiscountId(long commerceDiscountId, String name, String languageId, int start, int end) {
        return (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountRelTable.INSTANCE).from((Table)CommerceDiscountRelTable.INSTANCE).innerJoinON((Table)CPDefinitionTable.INSTANCE, CPDefinitionTable.INSTANCE.CPDefinitionId.eq((Expression)CommerceDiscountRelTable.INSTANCE.classPK)).leftJoinOn((Table)CPDefinitionLocalizationTable.INSTANCE, CPDefinitionTable.INSTANCE.CPDefinitionId.eq((Expression)CPDefinitionLocalizationTable.INSTANCE.CPDefinitionId).and((Expression)CPDefinitionLocalizationTable.INSTANCE.languageId.eq((Object)languageId))), CPDefinition.class.getName(), commerceDiscountId, name, (Expression<String>)CPDefinitionLocalizationTable.INSTANCE.name).limit(start, end));
    }

    public int getCPDefinitionsByCommerceDiscountIdCount(long commerceDiscountId, String name, String languageId) {
        return this.dslQueryCount((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)CommerceDiscountRelTable.INSTANCE.commerceDiscountRelId).from((Table)CommerceDiscountRelTable.INSTANCE).innerJoinON((Table)CPDefinitionTable.INSTANCE, CPDefinitionTable.INSTANCE.CPDefinitionId.eq((Expression)CommerceDiscountRelTable.INSTANCE.classPK)).leftJoinOn((Table)CPDefinitionLocalizationTable.INSTANCE, CPDefinitionTable.INSTANCE.CPDefinitionId.eq((Expression)CPDefinitionLocalizationTable.INSTANCE.CPDefinitionId).and((Expression)CPDefinitionLocalizationTable.INSTANCE.languageId.eq((Object)languageId))), CPDefinition.class.getName(), commerceDiscountId, name, (Expression<String>)CPDefinitionLocalizationTable.INSTANCE.name));
    }

    public List<CommerceDiscountRel> getCPInstancesByCommerceDiscountId(long commerceDiscountId, String sku, int start, int end) {
        return (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CommerceDiscountRelTable.INSTANCE).from((Table)CommerceDiscountRelTable.INSTANCE).innerJoinON((Table)CPInstanceTable.INSTANCE, CPInstanceTable.INSTANCE.CPInstanceId.eq((Expression)CommerceDiscountRelTable.INSTANCE.classPK)), CPInstance.class.getName(), commerceDiscountId, sku, (Expression<String>)CPInstanceTable.INSTANCE.sku).limit(start, end));
    }

    public int getCPInstancesByCommerceDiscountIdCount(long commerceDiscountId, String sku) {
        return this.dslQueryCount((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)CommerceDiscountRelTable.INSTANCE.commerceDiscountRelId).from((Table)CommerceDiscountRelTable.INSTANCE).innerJoinON((Table)CPInstanceTable.INSTANCE, CPInstanceTable.INSTANCE.CPInstanceId.eq((Expression)CommerceDiscountRelTable.INSTANCE.classPK)), CPInstance.class.getName(), commerceDiscountId, sku, (Expression<String>)CPInstanceTable.INSTANCE.sku));
    }

    protected void reindexCommerceDiscount(long commerceDiscountId) throws PortalException {
        CommerceDiscount commerceDiscount = this._commerceDiscountPersistence.findByPrimaryKey(commerceDiscountId);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceDiscount.class);
        indexer.reindex((Object)commerceDiscount);
    }

    private GroupByStep _getGroupByStep(JoinStep joinStep, String className, Long commerceDiscountId, String keywords, Expression<String> keywordsPredicateExpression) {
        return joinStep.where(() -> {
            Predicate predicate = CommerceDiscountRelTable.INSTANCE.commerceDiscountId.eq((Object)commerceDiscountId).and((Expression)CommerceDiscountRelTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(className)));
            if (Validator.isNotNull((String)keywords)) {
                predicate = predicate.and((Expression)Predicate.withParentheses((Predicate)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)keywordsPredicateExpression), this._customSQL.keywords(keywords, true))));
            }
            return predicate;
        });
    }
}

