/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.service.impl;

import com.liferay.commerce.discount.exception.CommerceDiscountRuleTypeException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRule;
import com.liferay.commerce.discount.rule.type.CommerceDiscountRuleType;
import com.liferay.commerce.discount.rule.type.CommerceDiscountRuleTypeRegistry;
import com.liferay.commerce.discount.service.base.CommerceDiscountRuleLocalServiceBaseImpl;
import com.liferay.commerce.discount.service.persistence.CommerceDiscountPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.discount.model.CommerceDiscountRule"}, service={AopService.class})
public class CommerceDiscountRuleLocalServiceImpl
extends CommerceDiscountRuleLocalServiceBaseImpl {
    @Reference
    private CommerceDiscountPersistence _commerceDiscountPersistence;
    @Reference
    private CommerceDiscountRuleTypeRegistry _commerceDiscountRuleTypeRegistry;
    @Reference
    private UserLocalService _userLocalService;

    public CommerceDiscountRule addCommerceDiscountRule(long commerceDiscountId, String type, String typeSettings, ServiceContext serviceContext) throws PortalException {
        return this.commerceDiscountRuleLocalService.addCommerceDiscountRule(commerceDiscountId, type, type, typeSettings, serviceContext);
    }

    public CommerceDiscountRule addCommerceDiscountRule(long commerceDiscountId, String name, String type, String typeSettings, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        this.validate(type);
        long commerceDiscountRuleId = this.counterLocalService.increment();
        CommerceDiscountRule commerceDiscountRule = this.commerceDiscountRulePersistence.create(commerceDiscountRuleId);
        commerceDiscountRule.setCompanyId(user.getCompanyId());
        commerceDiscountRule.setUserId(user.getUserId());
        commerceDiscountRule.setUserName(user.getFullName());
        commerceDiscountRule.setName(name);
        commerceDiscountRule.setCommerceDiscountId(commerceDiscountId);
        commerceDiscountRule.setType(type);
        UnicodeProperties settingsUnicodeProperties = commerceDiscountRule.getSettingsProperties();
        settingsUnicodeProperties.put(type, typeSettings);
        commerceDiscountRule.setSettingsProperties(settingsUnicodeProperties);
        commerceDiscountRule = (CommerceDiscountRule)this.commerceDiscountRulePersistence.update((BaseModel)commerceDiscountRule);
        this.reindexCommerceDiscount(commerceDiscountId);
        return commerceDiscountRule;
    }

    @Override
    @SystemEvent(type=1)
    public CommerceDiscountRule deleteCommerceDiscountRule(CommerceDiscountRule commerceDiscountRule) throws PortalException {
        this.commerceDiscountRulePersistence.remove((BaseModel)commerceDiscountRule);
        this.reindexCommerceDiscount(commerceDiscountRule.getCommerceDiscountId());
        return commerceDiscountRule;
    }

    @Override
    public CommerceDiscountRule deleteCommerceDiscountRule(long commerceDiscountRuleId) throws PortalException {
        CommerceDiscountRule commerceDiscountRule = this.commerceDiscountRulePersistence.findByPrimaryKey(commerceDiscountRuleId);
        return this.commerceDiscountRuleLocalService.deleteCommerceDiscountRule(commerceDiscountRule);
    }

    public void deleteCommerceDiscountRules(long commerceDiscountId) throws PortalException {
        List commerceDiscountRules = this.commerceDiscountRulePersistence.findByCommerceDiscountId(commerceDiscountId);
        for (CommerceDiscountRule commerceDiscountRule : commerceDiscountRules) {
            this.commerceDiscountRuleLocalService.deleteCommerceDiscountRule(commerceDiscountRule);
        }
    }

    public List<CommerceDiscountRule> getCommerceDiscountRules(long commerceDiscountId, int start, int end, OrderByComparator<CommerceDiscountRule> orderByComparator) {
        return this.commerceDiscountRulePersistence.findByCommerceDiscountId(commerceDiscountId, start, end, orderByComparator);
    }

    public List<CommerceDiscountRule> getCommerceDiscountRules(long commerceDiscountId, String name, int start, int end) throws PortalException {
        return this.commerceDiscountRuleFinder.findByCommerceDiscountId(commerceDiscountId, name, start, end);
    }

    public int getCommerceDiscountRulesCount(long commerceDiscountId) {
        return this.commerceDiscountRulePersistence.countByCommerceDiscountId(commerceDiscountId);
    }

    public int getCommerceDiscountRulesCount(long commerceDiscountId, String name) throws PortalException {
        return this.commerceDiscountRuleFinder.countByCommerceDiscountId(commerceDiscountId, name);
    }

    public CommerceDiscountRule updateCommerceDiscountRule(long commerceDiscountRuleId, String type, String typeSettings) throws PortalException {
        CommerceDiscountRule commerceDiscountRule = this.commerceDiscountRulePersistence.findByPrimaryKey(commerceDiscountRuleId);
        this.validate(type);
        commerceDiscountRule.setType(type);
        UnicodeProperties unicodeProperties = commerceDiscountRule.getSettingsProperties();
        unicodeProperties.put(type, typeSettings);
        commerceDiscountRule.setSettingsProperties(unicodeProperties);
        commerceDiscountRule = (CommerceDiscountRule)this.commerceDiscountRulePersistence.update((BaseModel)commerceDiscountRule);
        this.reindexCommerceDiscount(commerceDiscountRule.getCommerceDiscountId());
        return commerceDiscountRule;
    }

    public CommerceDiscountRule updateCommerceDiscountRule(long commerceDiscountRuleId, String name, String type, String typeSettings) throws PortalException {
        CommerceDiscountRule commerceDiscountRule = this.commerceDiscountRulePersistence.findByPrimaryKey(commerceDiscountRuleId);
        this.validate(type);
        commerceDiscountRule.setName(name);
        commerceDiscountRule.setType(type);
        UnicodeProperties unicodeProperties = commerceDiscountRule.getSettingsProperties();
        unicodeProperties.put(type, typeSettings);
        commerceDiscountRule.setSettingsProperties(unicodeProperties);
        commerceDiscountRule = (CommerceDiscountRule)this.commerceDiscountRulePersistence.update((BaseModel)commerceDiscountRule);
        this.reindexCommerceDiscount(commerceDiscountRule.getCommerceDiscountId());
        return commerceDiscountRule;
    }

    protected void reindexCommerceDiscount(long commerceDiscountId) throws PortalException {
        CommerceDiscount commerceDiscount = this._commerceDiscountPersistence.findByPrimaryKey(commerceDiscountId);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceDiscount.class);
        indexer.reindex((Object)commerceDiscount);
    }

    protected void validate(String type) throws PortalException {
        CommerceDiscountRuleType commerceDiscountRuleType = this._commerceDiscountRuleTypeRegistry.getCommerceDiscountRuleType(type);
        if (commerceDiscountRuleType == null) {
            throw new CommerceDiscountRuleTypeException();
        }
    }
}

