/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.service.impl;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountUsageEntry;
import com.liferay.commerce.discount.service.base.CommerceDiscountUsageEntryLocalServiceBaseImpl;
import com.liferay.commerce.discount.service.persistence.CommerceDiscountPersistence;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.discount.model.CommerceDiscountUsageEntry"}, service={AopService.class})
public class CommerceDiscountUsageEntryLocalServiceImpl
extends CommerceDiscountUsageEntryLocalServiceBaseImpl {
    @Reference
    private CommerceDiscountPersistence _commerceDiscountPersistence;
    @Reference
    private CounterLocalService _counterLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public CommerceDiscountUsageEntry addCommerceDiscountUsageEntry(long commerceAccountId, long commerceOrderId, long commerceDiscountId, ServiceContext serviceContext) throws PortalException {
        long userId = serviceContext.getUserId();
        User user = this._userLocalService.getUser(userId);
        if (user.isDefaultUser()) {
            userId = 0L;
        }
        long commerceDiscountUsageEntryId = this._counterLocalService.increment();
        CommerceDiscountUsageEntry commerceDiscountUsageEntry = this.commerceDiscountUsageEntryPersistence.create(commerceDiscountUsageEntryId);
        commerceDiscountUsageEntry.setCompanyId(user.getCompanyId());
        commerceDiscountUsageEntry.setUserId(userId);
        commerceDiscountUsageEntry.setUserName(user.getFullName());
        commerceDiscountUsageEntry.setCommerceAccountId(commerceAccountId);
        commerceDiscountUsageEntry.setCommerceOrderId(commerceOrderId);
        commerceDiscountUsageEntry.setCommerceDiscountId(commerceDiscountId);
        return (CommerceDiscountUsageEntry)this.commerceDiscountUsageEntryPersistence.update((BaseModel)commerceDiscountUsageEntry);
    }

    public void deleteCommerceUsageEntry(long commerceAccountId, long commerceOrderId, long commerceDiscountId) {
        CommerceDiscountUsageEntry commerceDiscountUsageEntry = this.commerceDiscountUsageEntryPersistence.fetchByCAI_COI_CDI_First(commerceAccountId, commerceOrderId, commerceDiscountId, null);
        if (commerceDiscountUsageEntry != null) {
            this.commerceDiscountUsageEntryPersistence.remove((BaseModel)commerceDiscountUsageEntry);
        }
    }

    public void deleteCommerceUsageEntryByDiscountId(long commerceDiscountId) {
        this.commerceDiscountUsageEntryPersistence.removeByCommerceDiscountId(commerceDiscountId);
    }

    public int getCommerceDiscountUsageEntriesCount(long commerceDiscountId) {
        return this.commerceDiscountUsageEntryPersistence.countByCommerceDiscountId(commerceDiscountId);
    }

    public int getCommerceDiscountUsageEntriesCount(long commerceAccountId, long commerceOrderId, long commerceDiscountId) {
        return this.commerceDiscountUsageEntryPersistence.countByCAI_COI_CDI(commerceAccountId, commerceOrderId, commerceDiscountId);
    }

    public int getCommerceDiscountUsageEntriesCountByAccountId(long commerceAccountId, long commerceDiscountId) {
        return this.commerceDiscountUsageEntryPersistence.countByCAI_CDI(commerceAccountId, commerceDiscountId);
    }

    public int getCommerceDiscountUsageEntriesCountByOrderId(long commerceOrderId, long commerceDiscountId) {
        return this.commerceDiscountUsageEntryPersistence.countByCOI_CDI(commerceOrderId, commerceDiscountId);
    }

    public boolean validateDiscountLimitationUsage(long commerceAccountId, long commerceDiscountId) throws PortalException {
        CommerceDiscount commerceDiscount = this._commerceDiscountPersistence.findByPrimaryKey(commerceDiscountId);
        if (Objects.equals(commerceDiscount.getLimitationType(), "unlimited")) {
            return true;
        }
        int limitationTimes = commerceDiscount.getLimitationTimes();
        if (Objects.equals(commerceDiscount.getLimitationType(), "limited")) {
            int commerceDiscountUsageEntriesCount = this.getCommerceDiscountUsageEntriesCount(commerceDiscountId);
            return commerceDiscountUsageEntriesCount < limitationTimes;
        }
        int limitationTimesPerAccount = commerceDiscount.getLimitationTimesPerAccount();
        if (Objects.equals(commerceDiscount.getLimitationType(), "limited-for-accounts")) {
            int commerceDiscountUsageEntriesCount = this.getCommerceDiscountUsageEntriesCountByAccountId(commerceAccountId, commerceDiscountId);
            return commerceDiscountUsageEntriesCount < limitationTimesPerAccount;
        }
        int commerceDiscountUsageEntriesTotalCount = this.getCommerceDiscountUsageEntriesCount(commerceDiscountId);
        if (commerceDiscountUsageEntriesTotalCount >= limitationTimes) {
            return false;
        }
        int commerceDiscountUsageEntriesUserCount = this.getCommerceDiscountUsageEntriesCountByAccountId(commerceAccountId, commerceDiscountId);
        return commerceDiscountUsageEntriesUserCount < limitationTimesPerAccount;
    }
}

