/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.internal;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.discount.CommerceDiscountCalculation;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.service.CommerceDiscountLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.List;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseCommerceDiscountCalculation
implements CommerceDiscountCalculation {
    @Reference
    protected CommerceAccountHelper commerceAccountHelper;
    @Reference
    protected CommerceDiscountLocalService commerceDiscountLocalService;

    protected List<CommerceDiscount> getOrderCommerceDiscountByHierarchy(long companyId, CommerceAccount commerceAccount, long commerceChannelId, String commerceDiscountTargetType) throws PortalException {
        long commerceAccountId = 0L;
        if (commerceAccount != null) {
            commerceAccountId = commerceAccount.getCommerceAccountId();
        }
        return this._getOrderCommerceDiscountByHierarchy(companyId, commerceAccountId, commerceChannelId, commerceDiscountTargetType);
    }

    protected List<CommerceDiscount> getProductCommerceDiscountByHierarchy(long companyId, CommerceAccount commerceAccount, long commerceChannelId, long cpDefinitionId) throws PortalException {
        long commerceAccountId = 0L;
        if (commerceAccount != null) {
            commerceAccountId = commerceAccount.getCommerceAccountId();
        }
        return this._getProductCommerceDiscountByHierarchy(companyId, commerceAccountId, commerceChannelId, cpDefinitionId);
    }

    private List<CommerceDiscount> _getOrderCommerceDiscountByHierarchy(long companyId, long commerceAccountId, long commerceChannelId, String commerceDiscountTargetType) throws PortalException {
        List commerceDiscounts = this.commerceDiscountLocalService.getAccountAndChannelCommerceDiscounts(commerceAccountId, commerceChannelId, commerceDiscountTargetType);
        if (commerceDiscounts != null && !commerceDiscounts.isEmpty()) {
            return commerceDiscounts;
        }
        commerceDiscounts = this.commerceDiscountLocalService.getAccountCommerceDiscounts(commerceAccountId, commerceDiscountTargetType);
        if (commerceDiscounts != null && !commerceDiscounts.isEmpty()) {
            return commerceDiscounts;
        }
        long[] commerceAccountGroupIds = this.commerceAccountHelper.getCommerceAccountGroupIds(commerceAccountId);
        commerceDiscounts = this.commerceDiscountLocalService.getAccountGroupAndChannelCommerceDiscount(commerceAccountGroupIds, commerceChannelId, commerceDiscountTargetType);
        if (commerceDiscounts != null && !commerceDiscounts.isEmpty()) {
            return commerceDiscounts;
        }
        commerceDiscounts = this.commerceDiscountLocalService.getAccountGroupCommerceDiscount(commerceAccountGroupIds, commerceDiscountTargetType);
        if (commerceDiscounts != null && !commerceDiscounts.isEmpty()) {
            return commerceDiscounts;
        }
        commerceDiscounts = this.commerceDiscountLocalService.getChannelCommerceDiscounts(commerceChannelId, commerceDiscountTargetType);
        if (commerceDiscounts != null && !commerceDiscounts.isEmpty()) {
            return commerceDiscounts;
        }
        return this.commerceDiscountLocalService.getUnqualifiedCommerceDiscounts(companyId, commerceDiscountTargetType);
    }

    private List<CommerceDiscount> _getProductCommerceDiscountByHierarchy(long companyId, long commerceAccountId, long commerceChannelId, long cpDefinitionId) throws PortalException {
        List commerceDiscounts = this.commerceDiscountLocalService.getAccountAndChannelCommerceDiscounts(commerceAccountId, commerceChannelId, cpDefinitionId);
        if (commerceDiscounts != null && !commerceDiscounts.isEmpty()) {
            return commerceDiscounts;
        }
        commerceDiscounts = this.commerceDiscountLocalService.getAccountCommerceDiscounts(commerceAccountId, cpDefinitionId);
        if (commerceDiscounts != null && !commerceDiscounts.isEmpty()) {
            return commerceDiscounts;
        }
        long[] commerceAccountGroupIds = this.commerceAccountHelper.getCommerceAccountGroupIds(commerceAccountId);
        commerceDiscounts = this.commerceDiscountLocalService.getAccountGroupAndChannelCommerceDiscount(commerceAccountGroupIds, commerceChannelId, cpDefinitionId);
        if (commerceDiscounts != null && !commerceDiscounts.isEmpty()) {
            return commerceDiscounts;
        }
        commerceDiscounts = this.commerceDiscountLocalService.getAccountGroupCommerceDiscount(commerceAccountGroupIds, cpDefinitionId);
        if (commerceDiscounts != null && !commerceDiscounts.isEmpty()) {
            return commerceDiscounts;
        }
        commerceDiscounts = this.commerceDiscountLocalService.getChannelCommerceDiscounts(commerceChannelId, cpDefinitionId);
        if (commerceDiscounts != null && !commerceDiscounts.isEmpty()) {
            return commerceDiscounts;
        }
        return this.commerceDiscountLocalService.getUnqualifiedCommerceDiscounts(companyId, cpDefinitionId);
    }
}

