/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.internal.application.strategy;

import com.liferay.commerce.discount.application.strategy.CommerceDiscountApplicationStrategy;
import com.liferay.commerce.util.CommerceBigDecimalUtil;
import com.liferay.portal.kernel.exception.PortalException;
import java.math.BigDecimal;
import org.osgi.service.component.annotations.Component;

@Component(enabled=false, property={"commerce.discount.application.strategy.key=addition"}, service={CommerceDiscountApplicationStrategy.class})
public class AdditionCommerceDiscountApplicationStrategyImpl
implements CommerceDiscountApplicationStrategy {
    private static final BigDecimal _ONE_HUNDRED = BigDecimal.valueOf(100L);

    public BigDecimal applyCommerceDiscounts(BigDecimal commercePrice, BigDecimal[] commerceDiscountLevels) throws PortalException {
        BigDecimal discountedAmount = commercePrice;
        BigDecimal totalDiscount = BigDecimal.ZERO;
        for (BigDecimal commerceDiscountLevel : commerceDiscountLevels) {
            if (commerceDiscountLevel == null || CommerceBigDecimalUtil.isZero((BigDecimal)commerceDiscountLevel)) continue;
            totalDiscount = totalDiscount.add(commerceDiscountLevel);
            BigDecimal currentDiscountAmount = commercePrice.multiply(totalDiscount);
            currentDiscountAmount = currentDiscountAmount.divide(_ONE_HUNDRED);
            discountedAmount = commercePrice.subtract(currentDiscountAmount);
        }
        return discountedAmount;
    }
}

