/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.internal.permission;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.permission.CommerceDiscountPermission;
import com.liferay.commerce.discount.service.CommerceDiscountLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommerceDiscountPermission.class})
public class CommerceDiscountPermissionImpl
implements CommerceDiscountPermission {
    @Reference
    private CommerceDiscountLocalService _commerceDiscountLocalService;

    public void check(PermissionChecker permissionChecker, CommerceDiscount commerceDiscount, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceDiscount, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceDiscount.class.getName(), commerceDiscount.getCommerceDiscountId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long commerceDiscountId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceDiscountId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceDiscount.class.getName(), commerceDiscountId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CommerceDiscount commerceDiscount, String actionId) throws PortalException {
        return this.contains(permissionChecker, commerceDiscount.getCommerceDiscountId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long commerceDiscountId, String actionId) throws PortalException {
        CommerceDiscount commerceDiscount = this._commerceDiscountLocalService.getCommerceDiscount(commerceDiscountId);
        if (commerceDiscount == null) {
            return false;
        }
        return this._contains(permissionChecker, commerceDiscount, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long[] commerceDiscountIds, String actionId) throws PortalException {
        if (ArrayUtil.isEmpty((long[])commerceDiscountIds)) {
            return false;
        }
        for (long commerceDiscountId : commerceDiscountIds) {
            if (this.contains(permissionChecker, commerceDiscountId, actionId)) continue;
            return false;
        }
        return true;
    }

    private boolean _contains(PermissionChecker permissionChecker, CommerceDiscount commerceDiscount, String actionId) {
        if (permissionChecker.isCompanyAdmin(commerceDiscount.getCompanyId()) || permissionChecker.isOmniadmin()) {
            return true;
        }
        if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), CommerceDiscount.class.getName(), commerceDiscount.getCommerceDiscountId(), permissionChecker.getUserId(), actionId) && commerceDiscount.getUserId() == permissionChecker.getUserId()) {
            return true;
        }
        return permissionChecker.hasPermission(null, CommerceDiscount.class.getName(), commerceDiscount.getCommerceDiscountId(), actionId);
    }
}

