/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.internal.rule.type;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.discount.model.CommerceDiscountRule;
import com.liferay.commerce.discount.rule.type.CommerceDiscountRuleType;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.ToLongFunction;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;

@Component(enabled=false, immediate=true, property={"commerce.discount.rule.type.key=added-all", "commerce.discount.rule.type.order:Integer=50"}, service={CommerceDiscountRuleType.class})
public class AddedAllCommerceDiscountRuleTypeImpl
implements CommerceDiscountRuleType {
    public boolean evaluate(CommerceDiscountRule commerceDiscountRule, CommerceContext commerceContext) throws PortalException {
        CommerceOrder commerceOrder = commerceContext.getCommerceOrder();
        if (commerceOrder == null) {
            return false;
        }
        List commerceOrderItems = commerceOrder.getCommerceOrderItems();
        Stream stream = commerceOrderItems.stream();
        LongStream longStream = stream.mapToLong(this._getOrderItemToLongFunction());
        long[] orderItemDefinitionIds = longStream.toArray();
        String settingsProperty = commerceDiscountRule.getSettingsProperty(commerceDiscountRule.getType());
        long[] cpDefinitionIds = StringUtil.split((String)settingsProperty, (long)0L);
        return ArrayUtil.containsAll((long[])orderItemDefinitionIds, (long[])cpDefinitionIds);
    }

    public String getKey() {
        return "added-all";
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"has-all-of-these-products");
    }

    private ToLongFunction<CommerceOrderItem> _getOrderItemToLongFunction() {
        return new ToLongFunction<CommerceOrderItem>(){

            @Override
            public long applyAsLong(CommerceOrderItem commerceOrderItem) {
                return commerceOrderItem.getCPDefinitionId();
            }
        };
    }
}

