/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.internal.search;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountAccountRelModel;
import com.liferay.commerce.discount.model.CommerceDiscountCommerceAccountGroupRelModel;
import com.liferay.commerce.discount.service.CommerceDiscountAccountRelLocalService;
import com.liferay.commerce.discount.service.CommerceDiscountCommerceAccountGroupRelLocalService;
import com.liferay.commerce.discount.service.CommerceDiscountLocalService;
import com.liferay.commerce.discount.target.CommerceDiscountOrderTarget;
import com.liferay.commerce.discount.target.CommerceDiscountProductTarget;
import com.liferay.commerce.discount.target.CommerceDiscountTarget;
import com.liferay.commerce.discount.target.CommerceDiscountTargetRegistry;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelRel;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.service.CommerceChannelRelLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.MissingFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.filter.FilterBuilders;
import com.liferay.portal.search.filter.TermsSetFilterBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(enabled=false, immediate=true, service={Indexer.class})
public class CommerceDiscountIndexer
extends BaseIndexer<CommerceDiscount> {
    public static final String CLASS_NAME = CommerceDiscount.class.getName();
    public static final String FIELD_ACTIVE = "active";
    public static final String FIELD_COUPON_CODE = "couponCode";
    public static final String FIELD_GROUP_IDS = "groupIds";
    public static final String FIELD_TARGET_TYPE = "targetType";
    public static final String FIELD_USE_COUPON_CODE = "useCouponCode";
    private static final Log _log = LogFactoryUtil.getLog(CommerceDiscountIndexer.class);
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceChannelRelLocalService _commerceChannelRelLocalService;
    @Reference
    private CommerceDiscountAccountRelLocalService _commerceDiscountAccountRelLocalService;
    @Reference
    private CommerceDiscountCommerceAccountGroupRelLocalService _commerceDiscountCommerceAccountGroupRelLocalService;
    @Reference
    private CommerceDiscountLocalService _commerceDiscountLocalService;
    private final List<CommerceDiscountOrderTarget> _commerceDiscountOrderTargets = new CopyOnWriteArrayList<CommerceDiscountOrderTarget>();
    private final List<CommerceDiscountProductTarget> _commerceDiscountProductTargets = new CopyOnWriteArrayList<CommerceDiscountProductTarget>();
    @Reference
    private CommerceDiscountTargetRegistry _commerceDiscountTargetRegistry;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private FilterBuilders _filterBuilders;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CommerceDiscountIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "modified", "name", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long commerceOrderId;
        long cpDefinitionId;
        String couponCode;
        String targetType;
        boolean active;
        long[] groupIds;
        int[] statuses = GetterUtil.getIntegerValues((Object)searchContext.getAttribute("status"), null);
        if (ArrayUtil.isEmpty((int[])statuses)) {
            int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
            statuses = new int[]{status};
        }
        if (!ArrayUtil.contains((int[])statuses, (int)-1)) {
            TermsFilter statusesTermsFilter = new TermsFilter("status");
            statusesTermsFilter.addValues(ArrayUtil.toStringArray((int[])statuses));
            contextBooleanFilter.add((Filter)statusesTermsFilter, BooleanClauseOccur.MUST);
        } else {
            contextBooleanFilter.addTerm("status", String.valueOf(8), BooleanClauseOccur.MUST_NOT);
        }
        boolean skipCommerceAccountGroupValidation = GetterUtil.getBoolean((Object)searchContext.getAttribute("skipCommerceAccountGroupValidation"));
        if (!skipCommerceAccountGroupValidation) {
            long[] commerceAccountGroupIds = GetterUtil.getLongValues((Object)searchContext.getAttribute("commerceAccountGroupIds"), null);
            if (commerceAccountGroupIds == null) {
                commerceAccountGroupIds = new long[]{};
            }
            TermsSetFilterBuilder termsSetFilterBuilder = this._filterBuilders.termsSetFilterBuilder();
            termsSetFilterBuilder.setFieldName("commerceAccountGroupIds");
            termsSetFilterBuilder.setMinimumShouldMatchField("commerceAccountGroupIds_required_matches");
            Object values = new ArrayList(commerceAccountGroupIds.length);
            for (long commerceAccountGroupId : commerceAccountGroupIds) {
                values.add(String.valueOf(commerceAccountGroupId));
            }
            termsSetFilterBuilder.setValues((List)values);
            TermFilter termFilter = new TermFilter("commerceAccountGroupIds_required_matches", "0");
            BooleanFilter fieldBooleanFilter = new BooleanFilter();
            fieldBooleanFilter.add((Filter)termFilter, BooleanClauseOccur.SHOULD);
            fieldBooleanFilter.add((Filter)termsSetFilterBuilder.build(), BooleanClauseOccur.SHOULD);
            contextBooleanFilter.add((Filter)fieldBooleanFilter, BooleanClauseOccur.MUST);
        }
        if ((groupIds = GetterUtil.getLongValues((Object)searchContext.getAttribute(FIELD_GROUP_IDS), null)) != null && groupIds.length > 0) {
            BooleanFilter groupBooleanFilter = new BooleanFilter();
            for (long groupId : groupIds) {
                TermFilter termFilter = new TermFilter(FIELD_GROUP_IDS, String.valueOf(groupId));
                groupBooleanFilter.add((Filter)termFilter, BooleanClauseOccur.SHOULD);
            }
            groupBooleanFilter.add((Filter)new MissingFilter(FIELD_GROUP_IDS), BooleanClauseOccur.SHOULD);
            contextBooleanFilter.add((Filter)groupBooleanFilter, BooleanClauseOccur.MUST);
        }
        if (active = GetterUtil.getBoolean((Object)searchContext.getAttribute(FIELD_ACTIVE))) {
            contextBooleanFilter.addRequiredTerm(FIELD_ACTIVE, String.valueOf(active));
        }
        if (Validator.isNotNull((String)(targetType = GetterUtil.getString((Object)searchContext.getAttribute(FIELD_TARGET_TYPE), null)))) {
            contextBooleanFilter.addRequiredTerm(FIELD_TARGET_TYPE, targetType);
        }
        if (Validator.isNotNull((String)(couponCode = GetterUtil.getString((Object)searchContext.getAttribute(FIELD_COUPON_CODE), null)))) {
            BooleanFilter booleanFilter = new BooleanFilter();
            BooleanFilter booleanFilterCoupon = new BooleanFilter();
            booleanFilterCoupon.addRequiredTerm(FIELD_COUPON_CODE, couponCode);
            booleanFilterCoupon.addRequiredTerm(FIELD_USE_COUPON_CODE, Boolean.TRUE.toString());
            booleanFilter.add((Filter)booleanFilterCoupon);
            booleanFilter.addTerm(FIELD_USE_COUPON_CODE, Boolean.FALSE.toString());
            contextBooleanFilter.add((Filter)booleanFilter);
        }
        if ((cpDefinitionId = GetterUtil.getLong((Object)searchContext.getAttribute("cpDefinitionId"))) > 0L) {
            CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
            for (CommerceDiscountProductTarget commerceDiscountProductTarget : this._commerceDiscountProductTargets) {
                commerceDiscountProductTarget.postProcessContextBooleanFilter(contextBooleanFilter, cpDefinition);
            }
        }
        if ((commerceOrderId = GetterUtil.getLong((Object)searchContext.getAttribute("commerceOrderId"))) > 0L) {
            CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
            for (CommerceDiscountOrderTarget commerceDiscountOrderTarget : this._commerceDiscountOrderTargets) {
                commerceDiscountOrderTarget.postProcessContextBooleanFilter(contextBooleanFilter, commerceOrder);
            }
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "name", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(CommerceDiscount commerceDiscount) throws Exception {
        this.deleteDocument(commerceDiscount.getCompanyId(), commerceDiscount.getCommerceDiscountId());
    }

    protected Document doGetDocument(CommerceDiscount commerceDiscount) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing discount " + commerceDiscount));
        }
        CommerceDiscountTarget commerceDiscountTarget = this._commerceDiscountTargetRegistry.getCommerceDiscountTarget(commerceDiscount.getTarget());
        CommerceDiscountTarget.Type commerceDiscountTargetType = commerceDiscountTarget.getType();
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commerceDiscount);
        document.addText("title", commerceDiscount.getTitle());
        document.addText(FIELD_TARGET_TYPE, commerceDiscountTargetType.toString());
        document.addText("userName", commerceDiscount.getUserName());
        document.addKeyword(FIELD_ACTIVE, commerceDiscount.isActive());
        document.addKeyword(FIELD_COUPON_CODE, commerceDiscount.getCouponCode());
        document.addKeyword(FIELD_USE_COUPON_CODE, commerceDiscount.isUseCouponCode());
        List commerceDiscountAccountRels = this._commerceDiscountAccountRelLocalService.getCommerceDiscountAccountRels(commerceDiscount.getCommerceDiscountId(), -1, -1, null);
        Stream commerceDiscountAccountRelsStream = commerceDiscountAccountRels.stream();
        LongStream commerceAccountIdLongStream = commerceDiscountAccountRelsStream.mapToLong(CommerceDiscountAccountRelModel::getCommerceAccountId);
        long[] commerceAccountIds = commerceAccountIdLongStream.toArray();
        document.addNumber("commerceAccountId", commerceAccountIds);
        List commerceDiscountCommerceAccountGroupRels = this._commerceDiscountCommerceAccountGroupRelLocalService.getCommerceDiscountCommerceAccountGroupRels(commerceDiscount.getCommerceDiscountId(), -1, -1, null);
        Stream commerceDiscountCommerceAccountGroupRelsStream = commerceDiscountCommerceAccountGroupRels.stream();
        LongStream commerceAccountGroupIdLongStream = commerceDiscountCommerceAccountGroupRelsStream.mapToLong(CommerceDiscountCommerceAccountGroupRelModel::getCommerceAccountGroupId);
        long[] commerceAccountGroupIds = commerceAccountGroupIdLongStream.toArray();
        document.addNumber("commerceAccountGroupIds", commerceAccountGroupIds);
        document.addNumber("commerceAccountGroupIds_required_matches", commerceAccountGroupIds.length);
        ArrayList<Long> channelIdList = new ArrayList<Long>();
        ArrayList<Long> groupIdList = new ArrayList<Long>();
        List commerceChannelRels = this._commerceChannelRelLocalService.getCommerceChannelRels(commerceDiscount.getModelClassName(), commerceDiscount.getCommerceDiscountId(), -1, -1, null);
        for (CommerceChannelRel commerceChannelRel : commerceChannelRels) {
            CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannel(commerceChannelRel.getCommerceChannelId());
            if (commerceChannel == null) continue;
            channelIdList.add(commerceChannel.getCommerceChannelId());
            groupIdList.add(commerceChannel.getGroupId());
        }
        Stream channelIdStream = channelIdList.stream();
        long[] channelIds = channelIdStream.mapToLong(l -> l).toArray();
        document.addNumber("commerceChannelId", channelIds);
        Stream groupIdStream = groupIdList.stream();
        long[] groupIds = groupIdStream.mapToLong(l -> l).toArray();
        document.addNumber(FIELD_GROUP_IDS, groupIds);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + commerceDiscount + " indexed successfully"));
        }
        if (commerceDiscountTarget instanceof CommerceDiscountProductTarget) {
            CommerceDiscountProductTarget commerceDiscountProductTarget = (CommerceDiscountProductTarget)commerceDiscountTarget;
            commerceDiscountProductTarget.contributeDocument(document, commerceDiscount);
        }
        if (commerceDiscountTarget instanceof CommerceDiscountOrderTarget) {
            CommerceDiscountOrderTarget commerceDiscountOrderTarget = (CommerceDiscountOrderTarget)commerceDiscountTarget;
            commerceDiscountOrderTarget.contributeDocument(document, commerceDiscount);
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "entryClassPK", "name");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CommerceDiscount commerceDiscount) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), commerceDiscount.getCompanyId(), this.getDocument(commerceDiscount), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._commerceDiscountLocalService.getCommerceDiscount(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCommerceDiscounts(companyId);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, service=CommerceDiscountOrderTarget.class)
    protected void registerCommerceDiscountOrderTarget(CommerceDiscountOrderTarget commerceDiscountOrderTarget) {
        this._commerceDiscountOrderTargets.add(commerceDiscountOrderTarget);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, service=CommerceDiscountProductTarget.class)
    protected void registerCommerceDiscountProductTarget(CommerceDiscountProductTarget commerceDiscountProductTarget) {
        this._commerceDiscountProductTargets.add(commerceDiscountProductTarget);
    }

    protected void reindexCommerceDiscounts(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commerceDiscountLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(commerceDiscount -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(commerceDiscount)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce discount " + commerceDiscount.getCommerceDiscountId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    protected void unregisterCommerceDiscountOrderTarget(CommerceDiscountOrderTarget commerceDiscountOrderTarget) {
        this._commerceDiscountOrderTargets.remove(commerceDiscountOrderTarget);
    }

    protected void unregisterCommerceDiscountProductTarget(CommerceDiscountProductTarget commerceDiscountProductTarget) {
        this._commerceDiscountProductTargets.remove(commerceDiscountProductTarget);
    }
}

