/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.internal.target;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetCategoryModel;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRelModel;
import com.liferay.commerce.discount.service.CommerceDiscountRelLocalService;
import com.liferay.commerce.discount.target.CommerceDiscountProductTarget;
import com.liferay.commerce.discount.target.CommerceDiscountTarget;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.ExistsFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"commerce.discount.target.key=categories", "commerce.discount.target.order:Integer=10"}, service={CommerceDiscountProductTarget.class, CommerceDiscountTarget.class})
public class ApplyToCategoriesCommerceDiscountTargetImpl
implements CommerceDiscountProductTarget,
CommerceDiscountTarget {
    private static final Log _log = LogFactoryUtil.getLog(ApplyToCategoriesCommerceDiscountTargetImpl.class);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private CommerceDiscountRelLocalService _commerceDiscountRelLocalService;

    public void contributeDocument(Document document, CommerceDiscount commerceDiscount) {
        List commerceDiscountRels = this._commerceDiscountRelLocalService.getCommerceDiscountRels(commerceDiscount.getCommerceDiscountId(), AssetCategory.class.getName());
        Stream stream = commerceDiscountRels.stream();
        LongStream longStream = stream.mapToLong(CommerceDiscountRelModel::getClassPK);
        long[] assetCategoryIds = longStream.toArray();
        document.addKeyword("target_asset_category_ids", assetCategoryIds);
    }

    public String getKey() {
        return "categories";
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"categories");
    }

    public CommerceDiscountTarget.Type getType() {
        return CommerceDiscountTarget.Type.APPLY_TO_PRODUCT;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, CPDefinition cpDefinition) {
        long[] assetCategoryIds = this._getAssetCategoryIds(cpDefinition);
        TermsFilter termsFilter = new TermsFilter("target_asset_category_ids");
        termsFilter.addValues(ArrayUtil.toStringArray((long[])assetCategoryIds));
        ExistsFilter existFilter = new ExistsFilter("target_asset_category_ids");
        BooleanFilter existBooleanFilter = new BooleanFilter();
        existBooleanFilter.add((Filter)existFilter, BooleanClauseOccur.MUST_NOT);
        BooleanFilter fieldBooleanFilter = new BooleanFilter();
        fieldBooleanFilter.add((Filter)existBooleanFilter, BooleanClauseOccur.SHOULD);
        fieldBooleanFilter.add((Filter)termsFilter, BooleanClauseOccur.SHOULD);
        contextBooleanFilter.add((Filter)fieldBooleanFilter, BooleanClauseOccur.MUST);
    }

    private long[] _getAssetCategoryIds(CPDefinition cpDefinition) {
        try {
            AssetEntry assetEntry = this._assetEntryLocalService.getEntry(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId());
            HashSet<AssetCategory> assetCategories = new HashSet<AssetCategory>();
            for (AssetCategory assetCategory : assetEntry.getCategories()) {
                assetCategories.add(assetCategory);
                assetCategories.addAll(assetCategory.getAncestors());
            }
            Stream stream = assetCategories.stream();
            LongStream longStream = stream.mapToLong(AssetCategoryModel::getCategoryId);
            return longStream.toArray();
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
            return new long[0];
        }
    }
}

