/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.internal.target;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRelModel;
import com.liferay.commerce.discount.service.CommerceDiscountRelLocalService;
import com.liferay.commerce.discount.target.CommerceDiscountProductTarget;
import com.liferay.commerce.discount.target.CommerceDiscountTarget;
import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.service.CommercePricingClassLocalService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.ExistsFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"commerce.discount.target.key=product-groups", "commerce.discount.target.order:Integer=10"}, service={CommerceDiscountProductTarget.class, CommerceDiscountTarget.class})
public class ApplyToPricingClassCommerceDiscountTargetImpl
implements CommerceDiscountProductTarget,
CommerceDiscountTarget {
    @Reference
    private CommerceDiscountRelLocalService _commerceDiscountRelLocalService;
    @Reference
    private CommercePricingClassLocalService _commercePricingClassLocalService;

    public void contributeDocument(Document document, CommerceDiscount commerceDiscount) {
        List commerceDiscountRels = this._commerceDiscountRelLocalService.getCommerceDiscountRels(commerceDiscount.getCommerceDiscountId(), CommercePricingClass.class.getName());
        Stream stream = commerceDiscountRels.stream();
        LongStream longStream = stream.mapToLong(CommerceDiscountRelModel::getClassPK);
        long[] assetCategoryIds = longStream.toArray();
        document.addKeyword("target_pricing_class_ids", assetCategoryIds);
    }

    public String getKey() {
        return "product-groups";
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"product-groups");
    }

    public CommerceDiscountTarget.Type getType() {
        return CommerceDiscountTarget.Type.APPLY_TO_PRODUCT;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, CPDefinition cpDefinition) {
        long[] pricingClassIds = this._commercePricingClassLocalService.getCommercePricingClassByCPDefinition(cpDefinition.getCPDefinitionId());
        TermsFilter termsFilter = new TermsFilter("target_pricing_class_ids");
        termsFilter.addValues(ArrayUtil.toStringArray((long[])pricingClassIds));
        ExistsFilter existFilter = new ExistsFilter("target_pricing_class_ids");
        BooleanFilter existBooleanFilter = new BooleanFilter();
        existBooleanFilter.add((Filter)existFilter, BooleanClauseOccur.MUST_NOT);
        BooleanFilter fieldBooleanFilter = new BooleanFilter();
        fieldBooleanFilter.add((Filter)existBooleanFilter, BooleanClauseOccur.SHOULD);
        fieldBooleanFilter.add((Filter)termsFilter, BooleanClauseOccur.SHOULD);
        contextBooleanFilter.add((Filter)fieldBooleanFilter, BooleanClauseOccur.MUST);
    }
}

