/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.internal.validator;

import com.liferay.commerce.discount.internal.validator.comparator.CommerceDiscountValidatorServiceWrapperPriorityComparator;
import com.liferay.commerce.discount.validator.CommerceDiscountValidator;
import com.liferay.commerce.discount.validator.CommerceDiscountValidatorRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(enabled=false, immediate=true, service={CommerceDiscountValidatorRegistry.class})
public class CommerceDiscountValidatorRegistryImpl
implements CommerceDiscountValidatorRegistry {
    private static final Log _log = LogFactoryUtil.getLog(CommerceDiscountValidatorRegistryImpl.class);
    private static final Comparator<ServiceTrackerCustomizerFactory.ServiceWrapper<CommerceDiscountValidator>> _commerceDiscountValidatorServiceWrapperPriorityComparator = new CommerceDiscountValidatorServiceWrapperPriorityComparator();
    private ServiceTrackerMap<String, ServiceTrackerCustomizerFactory.ServiceWrapper<CommerceDiscountValidator>> _serviceTrackerMap;

    public CommerceDiscountValidator getCommerceDiscountValidator(String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        ServiceTrackerCustomizerFactory.ServiceWrapper commerceDiscountValidatorServiceWrapper = (ServiceTrackerCustomizerFactory.ServiceWrapper)this._serviceTrackerMap.getService((Object)key);
        if (commerceDiscountValidatorServiceWrapper == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No commerce discount validator registered with key " + key));
            }
            return null;
        }
        return (CommerceDiscountValidator)commerceDiscountValidatorServiceWrapper.getService();
    }

    public List<CommerceDiscountValidator> getCommerceDiscountValidators() {
        return this.getCommerceDiscountValidators(null);
    }

    public List<CommerceDiscountValidator> getCommerceDiscountValidators(String ... types) {
        ArrayList<Object> commerceDiscountValidators = new ArrayList<Object>();
        List commerceDiscountValidatorServiceWrappers = ListUtil.fromCollection((Collection)this._serviceTrackerMap.values());
        Collections.sort(commerceDiscountValidatorServiceWrappers, _commerceDiscountValidatorServiceWrapperPriorityComparator);
        for (ServiceTrackerCustomizerFactory.ServiceWrapper commerceDiscountValidatorServiceWrapper : commerceDiscountValidatorServiceWrappers) {
            if (types == null || types.length == 0) {
                commerceDiscountValidators.add(commerceDiscountValidatorServiceWrapper.getService());
                continue;
            }
            Map commerceDiscountValidatorServiceWrapperProperties = commerceDiscountValidatorServiceWrapper.getProperties();
            Object valueObject = commerceDiscountValidatorServiceWrapperProperties.get("commerce.discount.validator.type");
            String value = GetterUtil.getString(valueObject);
            if (!ArrayUtil.contains((Object[])types, (Object)value)) continue;
            commerceDiscountValidators.add(commerceDiscountValidatorServiceWrapper.getService());
        }
        return Collections.unmodifiableList(commerceDiscountValidators);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CommerceDiscountValidator.class, (String)"commerce.discount.validator.key", (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceWrapper((BundleContext)bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

