/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.internal.validator;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.service.CommerceDiscountLocalService;
import com.liferay.commerce.discount.validator.CommerceDiscountValidator;
import com.liferay.commerce.discount.validator.CommerceDiscountValidatorResult;
import com.liferay.portal.kernel.exception.PortalException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"commerce.discount.validator.key=qualifiers", "commerce.discount.validator.priority:Integer=20", "commerce.discount.validator.type=pre-qualification"}, service={CommerceDiscountValidator.class})
public class QualifiersCommerceDiscountValidator
implements CommerceDiscountValidator {
    public static final String KEY = "qualifiers";
    @Reference
    private CommerceDiscountLocalService _commerceDiscountLocalService;

    public String getKey() {
        return KEY;
    }

    public CommerceDiscountValidatorResult validate(CommerceContext commerceContext, CommerceDiscount commerceDiscount) throws PortalException {
        int validCommerceDiscountsCount;
        long commerceAccountId = 0L;
        CommerceAccount commerceAccount = commerceContext.getCommerceAccount();
        if (commerceAccount != null) {
            commerceAccountId = commerceAccount.getCommerceAccountId();
        }
        if ((validCommerceDiscountsCount = this._commerceDiscountLocalService.getValidCommerceDiscountsCount(commerceAccountId, commerceContext.getCommerceAccountGroupIds(), commerceContext.getCommerceChannelId(), commerceDiscount.getCommerceDiscountId())) == 0) {
            return new CommerceDiscountValidatorResult(commerceDiscount.getCommerceDiscountId(), false, "the-account-is-not-qualified-to-use-the-discount");
        }
        return new CommerceDiscountValidatorResult(true);
    }
}

