/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.service.impl;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountAccountRel;
import com.liferay.commerce.discount.service.base.CommerceDiscountAccountRelLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceDiscountAccountRelLocalServiceImpl
extends CommerceDiscountAccountRelLocalServiceBaseImpl {
    public CommerceDiscountAccountRel addCommerceDiscountAccountRel(long commerceDiscountId, long commerceAccountId, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long commerceDiscountAccountRelId = this.counterLocalService.increment();
        CommerceDiscountAccountRel commerceDiscountAccountRel = this.commerceDiscountAccountRelPersistence.create(commerceDiscountAccountRelId);
        commerceDiscountAccountRel.setCompanyId(user.getCompanyId());
        commerceDiscountAccountRel.setUserId(user.getUserId());
        commerceDiscountAccountRel.setUserName(user.getFullName());
        commerceDiscountAccountRel.setCommerceAccountId(commerceAccountId);
        commerceDiscountAccountRel.setCommerceDiscountId(commerceDiscountId);
        commerceDiscountAccountRel = (CommerceDiscountAccountRel)this.commerceDiscountAccountRelPersistence.update((BaseModel)commerceDiscountAccountRel);
        this.reindexCommerceDiscount(commerceDiscountId);
        return commerceDiscountAccountRel;
    }

    @Override
    public CommerceDiscountAccountRel deleteCommerceDiscountAccountRel(CommerceDiscountAccountRel commerceDiscountAccountRel) throws PortalException {
        this.commerceDiscountAccountRelPersistence.remove((BaseModel)commerceDiscountAccountRel);
        this.reindexCommerceDiscount(commerceDiscountAccountRel.getCommerceDiscountId());
        return commerceDiscountAccountRel;
    }

    @Override
    public CommerceDiscountAccountRel deleteCommerceDiscountAccountRel(long commerceDiscountAccountRelId) throws PortalException {
        CommerceDiscountAccountRel commerceDiscountAccountRel = this.commerceDiscountAccountRelPersistence.findByPrimaryKey(commerceDiscountAccountRelId);
        return this.commerceDiscountAccountRelLocalService.deleteCommerceDiscountAccountRel(commerceDiscountAccountRel);
    }

    @Deprecated
    public void deleteCommerceDiscountAccountRelsBycommerceAccountId(long commerceAccountId) {
        this.commerceDiscountAccountRelPersistence.removeByCommerceAccountId(commerceAccountId);
    }

    public void deleteCommerceDiscountAccountRelsByCommerceDiscountId(long commerceDiscountId) throws PortalException {
        List commerceDiscountAccountRels = this.commerceDiscountAccountRelPersistence.findByCommerceDiscountId(commerceDiscountId);
        for (CommerceDiscountAccountRel commerceDiscountAccountRel : commerceDiscountAccountRels) {
            this.commerceDiscountAccountRelLocalService.deleteCommerceDiscountAccountRel(commerceDiscountAccountRel);
        }
    }

    public CommerceDiscountAccountRel fetchCommerceDiscountAccountRel(long commerceDiscountId, long commerceAccountId) {
        return this.commerceDiscountAccountRelPersistence.fetchByC_C(commerceAccountId, commerceDiscountId);
    }

    public List<CommerceDiscountAccountRel> getCommerceDiscountAccountRels(long commerceDiscountId, int start, int end, OrderByComparator<CommerceDiscountAccountRel> orderByComparator) {
        return this.commerceDiscountAccountRelPersistence.findByCommerceDiscountId(commerceDiscountId, start, end, orderByComparator);
    }

    public List<CommerceDiscountAccountRel> getCommerceDiscountAccountRels(long commerceDiscountId, String name, int start, int end) {
        return this.commerceDiscountAccountRelFinder.findByCommerceDiscountId(commerceDiscountId, name, start, end);
    }

    public int getCommerceDiscountAccountRelsCount(long commerceDiscountId) {
        return this.commerceDiscountAccountRelPersistence.countByCommerceDiscountId(commerceDiscountId);
    }

    public int getCommerceDiscountAccountRelsCount(long commerceDiscountId, String name) {
        return this.commerceDiscountAccountRelFinder.countByCommerceDiscountId(commerceDiscountId, name);
    }

    protected void reindexCommerceDiscount(long commerceDiscountId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceDiscount.class);
        indexer.reindex(CommerceDiscount.class.getName(), commerceDiscountId);
    }
}

