/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.service.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetCategoryModel;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.commerce.discount.exception.CommerceDiscountCouponCodeException;
import com.liferay.commerce.discount.exception.CommerceDiscountDisplayDateException;
import com.liferay.commerce.discount.exception.CommerceDiscountExpirationDateException;
import com.liferay.commerce.discount.exception.CommerceDiscountLimitationTypeException;
import com.liferay.commerce.discount.exception.CommerceDiscountTargetException;
import com.liferay.commerce.discount.exception.CommerceDiscountTitleException;
import com.liferay.commerce.discount.exception.DuplicateCommerceDiscountException;
import com.liferay.commerce.discount.exception.NoSuchDiscountException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.service.base.CommerceDiscountLocalServiceBaseImpl;
import com.liferay.commerce.discount.target.CommerceDiscountTarget;
import com.liferay.commerce.discount.target.CommerceDiscountTargetRegistry;
import com.liferay.commerce.discount.util.comparator.CommerceDiscountCreateDateComparator;
import com.liferay.commerce.pricing.service.CommercePricingClassLocalService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class CommerceDiscountLocalServiceImpl
extends CommerceDiscountLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "uid"};
    private static final Log _log = LogFactoryUtil.getLog(CommerceDiscountLocalServiceImpl.class);
    @ServiceReference(type=AssetEntryLocalService.class)
    private AssetEntryLocalService _assetEntryLocalService;
    @ServiceReference(type=CommerceDiscountTargetRegistry.class)
    private CommerceDiscountTargetRegistry _commerceDiscountTargetRegistry;
    @ServiceReference(type=CommercePricingClassLocalService.class)
    private CommercePricingClassLocalService _commercePricingClassLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount addCommerceDiscount(long userId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.commerceDiscountLocalService.addCommerceDiscount(userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, "", level1, level2, level3, level4, limitationType, limitationTimes, true, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount addCommerceDiscount(long userId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addCommerceDiscount(null, userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount addCommerceDiscount(long userId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, String externalReferenceCode, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addCommerceDiscount(externalReferenceCode, userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount addCommerceDiscount(long userId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, int limitationTimesPerAccount, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, String externalReferenceCode, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addCommerceDiscount(externalReferenceCode, userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, limitationTimesPerAccount, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount addCommerceDiscount(String externalReferenceCode, long userId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addCommerceDiscount(externalReferenceCode, userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, 0, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount addCommerceDiscount(String externalReferenceCode, long userId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, int limitationTimesPerAccount, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        this.validateExternalReferenceCode(externalReferenceCode, serviceContext.getCompanyId());
        User user = this.userLocalService.getUser(userId);
        this.validate(serviceContext.getCompanyId(), 0L, title, target, useCouponCode, couponCode, limitationType);
        Date date = new Date();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), CommerceDiscountDisplayDateException.class);
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), CommerceDiscountExpirationDateException.class);
        }
        long commerceDiscountId = this.counterLocalService.increment();
        CommerceDiscount commerceDiscount = this.commerceDiscountPersistence.create(commerceDiscountId);
        commerceDiscount.setExternalReferenceCode(externalReferenceCode);
        commerceDiscount.setCompanyId(user.getCompanyId());
        commerceDiscount.setUserId(user.getUserId());
        commerceDiscount.setUserName(user.getFullName());
        commerceDiscount.setTitle(title);
        commerceDiscount.setTarget(target);
        commerceDiscount.setUseCouponCode(useCouponCode);
        commerceDiscount.setCouponCode(couponCode);
        commerceDiscount.setUsePercentage(usePercentage);
        commerceDiscount.setMaximumDiscountAmount(maximumDiscountAmount);
        commerceDiscount.setLevel(level);
        if (!level.isEmpty()) {
            if (level.equals("L1")) {
                commerceDiscount.setLevel1(level1);
            } else if (level.equals("L2")) {
                commerceDiscount.setLevel2(level1);
            } else if (level.equals("L3")) {
                commerceDiscount.setLevel3(level1);
            } else if (level.equals("L4")) {
                commerceDiscount.setLevel4(level1);
            }
        } else {
            commerceDiscount.setLevel1(level1);
            commerceDiscount.setLevel2(level2);
            commerceDiscount.setLevel3(level3);
            commerceDiscount.setLevel4(level4);
        }
        commerceDiscount.setLimitationType(limitationType);
        commerceDiscount.setLimitationTimes(limitationTimes);
        commerceDiscount.setLimitationTimesPerAccount(limitationTimesPerAccount);
        commerceDiscount.setRulesConjunction(rulesConjunction);
        commerceDiscount.setActive(active);
        commerceDiscount.setDisplayDate(displayDate);
        commerceDiscount.setExpirationDate(expirationDate);
        if (expirationDate == null || expirationDate.after(date)) {
            commerceDiscount.setStatus(2);
        } else {
            commerceDiscount.setStatus(3);
        }
        commerceDiscount.setStatusByUserId(user.getUserId());
        commerceDiscount.setStatusDate(serviceContext.getModifiedDate(date));
        commerceDiscount.setExpandoBridgeAttributes(serviceContext);
        commerceDiscount = (CommerceDiscount)this.commerceDiscountPersistence.update((BaseModel)commerceDiscount);
        this.resourceLocalService.addModelResources((AuditedModel)commerceDiscount, serviceContext);
        return this.startWorkflowInstance(user.getUserId(), commerceDiscount, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount addOrUpdateCommerceDiscount(String externalReferenceCode, long userId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommerceDiscount(externalReferenceCode, userId, commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, "", level1, level2, level3, level4, limitationType, limitationTimes, 0, true, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount addOrUpdateCommerceDiscount(String externalReferenceCode, long userId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        CommerceDiscount commerceDiscount;
        block4: {
            if (commerceDiscountId > 0L) {
                try {
                    return this.commerceDiscountLocalService.updateCommerceDiscount(commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
                }
                catch (NoSuchDiscountException noSuchDiscountException) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)("Unable to find discount with ID: " + commerceDiscountId), (Throwable)noSuchDiscountException);
                }
            }
        }
        if (!Validator.isBlank((String)externalReferenceCode) && (commerceDiscount = this.commerceDiscountPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode)) != null) {
            return this.commerceDiscountLocalService.updateCommerceDiscount(commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
        }
        return this.commerceDiscountLocalService.addCommerceDiscount(externalReferenceCode, userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount addOrUpdateCommerceDiscount(String externalReferenceCode, long userId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, int limitationTimesPerAccount, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        CommerceDiscount commerceDiscount;
        block4: {
            if (commerceDiscountId > 0L) {
                try {
                    return this.commerceDiscountLocalService.updateCommerceDiscount(commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, limitationTimesPerAccount, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
                }
                catch (NoSuchDiscountException noSuchDiscountException) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)("Unable to find discount with ID: " + commerceDiscountId), (Throwable)noSuchDiscountException);
                }
            }
        }
        if (!Validator.isBlank((String)externalReferenceCode) && (commerceDiscount = this.commerceDiscountPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode)) != null) {
            return this.commerceDiscountLocalService.updateCommerceDiscount(commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, limitationTimesPerAccount, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
        }
        return this.commerceDiscountLocalService.addCommerceDiscount(externalReferenceCode, userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, limitationTimesPerAccount, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public void checkCommerceDiscounts() throws PortalException {
        this.checkCommerceDiscountsByDisplayDate();
        this.checkCommerceDiscountsByExpirationDate();
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceDiscount deleteCommerceDiscount(CommerceDiscount commerceDiscount) throws PortalException {
        this.commerceDiscountUsageEntryLocalService.deleteCommerceUsageEntryByDiscountId(commerceDiscount.getCommerceDiscountId());
        this.commerceDiscountRelLocalService.deleteCommerceDiscountRels(commerceDiscount.getCommerceDiscountId());
        this.commerceDiscountRuleLocalService.deleteCommerceDiscountRules(commerceDiscount.getCommerceDiscountId());
        this.commerceDiscountCommerceAccountGroupRelLocalService.deleteCommerceDiscountCommerceAccountGroupRelsByCommerceDiscountId(commerceDiscount.getCommerceDiscountId());
        this.commerceDiscountPersistence.remove((BaseModel)commerceDiscount);
        this.resourceLocalService.deleteResource(commerceDiscount.getCompanyId(), CommerceDiscount.class.getName(), 4, commerceDiscount.getCommerceDiscountId());
        this.expandoRowLocalService.deleteRows(commerceDiscount.getCommerceDiscountId());
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(commerceDiscount.getCompanyId(), 0L, CommerceDiscount.class.getName(), commerceDiscount.getCommerceDiscountId());
        return commerceDiscount;
    }

    @Override
    public CommerceDiscount deleteCommerceDiscount(long commerceDiscountId) throws PortalException {
        CommerceDiscount commerceDiscount = this.commerceDiscountPersistence.findByPrimaryKey(commerceDiscountId);
        return this.commerceDiscountLocalService.deleteCommerceDiscount(commerceDiscount);
    }

    public void deleteCommerceDiscounts(long companyId) throws PortalException {
        List commerceDiscounts = this.commerceDiscountPersistence.findByCompanyId(companyId);
        for (CommerceDiscount commerceDiscount : commerceDiscounts) {
            this.commerceDiscountLocalService.deleteCommerceDiscount(commerceDiscount);
        }
    }

    @Deprecated
    public CommerceDiscount fetchByExternalReferenceCode(long companyId, String externalReferenceCode) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.commerceDiscountPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public CommerceDiscount fetchByExternalReferenceCode(String externalReferenceCode, long companyId) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.commerceDiscountPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public List<CommerceDiscount> getAccountAndChannelCommerceDiscounts(long commerceAccountId, long commerceChannelId, long cpDefinitionId) {
        return this.commerceDiscountFinder.findByA_C_C_C_Product(commerceAccountId, commerceChannelId, cpDefinitionId, this._getAssetCategoryIds(cpDefinitionId), this._commercePricingClassLocalService.getCommercePricingClassByCPDefinition(cpDefinitionId));
    }

    public List<CommerceDiscount> getAccountAndChannelCommerceDiscounts(long commerceAccountId, long commerceChannelId, String commerceDiscountTargetType) {
        return this.commerceDiscountFinder.findByA_C_C_C_Order(commerceAccountId, commerceChannelId, commerceDiscountTargetType);
    }

    public List<CommerceDiscount> getAccountCommerceDiscounts(long commerceAccountId, long cpDefinitionId) {
        return this.commerceDiscountFinder.findByA_C_C_Product(commerceAccountId, cpDefinitionId, this._getAssetCategoryIds(cpDefinitionId), this._commercePricingClassLocalService.getCommercePricingClassByCPDefinition(cpDefinitionId));
    }

    public List<CommerceDiscount> getAccountCommerceDiscounts(long commerceAccountId, String commerceDiscountTargetType) {
        return this.commerceDiscountFinder.findByA_C_C_Order(commerceAccountId, commerceDiscountTargetType);
    }

    public List<CommerceDiscount> getAccountGroupAndChannelCommerceDiscount(long[] commerceAccountGroupIds, long commerceChannelId, long cpDefinitionId) {
        return this.commerceDiscountFinder.findByAG_C_C_C_Product(commerceAccountGroupIds, commerceChannelId, cpDefinitionId, this._getAssetCategoryIds(cpDefinitionId), this._commercePricingClassLocalService.getCommercePricingClassByCPDefinition(cpDefinitionId));
    }

    public List<CommerceDiscount> getAccountGroupAndChannelCommerceDiscount(long[] commerceAccountGroupIds, long commerceChannelId, String commerceDiscountTargetType) {
        return this.commerceDiscountFinder.findByAG_C_C_C_Order(commerceAccountGroupIds, commerceChannelId, commerceDiscountTargetType);
    }

    public List<CommerceDiscount> getAccountGroupCommerceDiscount(long[] commerceAccountGroupIds, long cpDefinitionId) {
        return this.commerceDiscountFinder.findByAG_C_C_Product(commerceAccountGroupIds, cpDefinitionId, this._getAssetCategoryIds(cpDefinitionId), this._commercePricingClassLocalService.getCommercePricingClassByCPDefinition(cpDefinitionId));
    }

    public List<CommerceDiscount> getAccountGroupCommerceDiscount(long[] commerceAccountGroupIds, String commerceDiscountTargetType) {
        return this.commerceDiscountFinder.findByAG_C_C_Order(commerceAccountGroupIds, commerceDiscountTargetType);
    }

    public CommerceDiscount getActiveCommerceDiscount(long companyId, String couponCode, boolean active) throws PortalException {
        return this.commerceDiscountPersistence.findByC_C_A(companyId, couponCode, active);
    }

    public int getActiveCommerceDiscountsCount(long companyId, String couponCode, boolean active) {
        return this.commerceDiscountPersistence.countByC_C_A(companyId, couponCode, active);
    }

    public List<CommerceDiscount> getChannelCommerceDiscounts(long commerceChannelId, long cpDefinitionId) {
        return this.commerceDiscountFinder.findByC_C_C_Product(commerceChannelId, cpDefinitionId, this._getAssetCategoryIds(cpDefinitionId), this._commercePricingClassLocalService.getCommercePricingClassByCPDefinition(cpDefinitionId));
    }

    public List<CommerceDiscount> getChannelCommerceDiscounts(long commerceChannelId, String commerceDiscountTargetType) {
        return this.commerceDiscountFinder.findByC_C_C_Order(commerceChannelId, commerceDiscountTargetType);
    }

    @Deprecated
    public List<CommerceDiscount> getCommerceDiscounts(long companyId, String couponCode) {
        return this.commerceDiscountPersistence.findByC_C(companyId, couponCode);
    }

    @Deprecated
    public int getCommerceDiscountsCount(long companyId, String couponCode) {
        return this.commerceDiscountPersistence.countByC_C(companyId, couponCode);
    }

    public int getCommerceDiscountsCountByPricingClassId(long commercePricingClassId, String title) {
        return this.commerceDiscountFinder.countByCommercePricingClassId(commercePricingClassId, title);
    }

    public List<CommerceDiscount> getPriceListCommerceDiscounts(long[] commerceDiscountIds, long cpDefinitionId) {
        return this.commerceDiscountFinder.findPriceListDiscountProduct(commerceDiscountIds, cpDefinitionId, this._getAssetCategoryIds(cpDefinitionId), this._commercePricingClassLocalService.getCommercePricingClassByCPDefinition(cpDefinitionId));
    }

    public List<CommerceDiscount> getUnqualifiedCommerceDiscounts(long companyId, long cpDefinitionId) {
        return this.commerceDiscountFinder.findByUnqualifiedProduct(companyId, cpDefinitionId, this._getAssetCategoryIds(cpDefinitionId), this._commercePricingClassLocalService.getCommercePricingClassByCPDefinition(cpDefinitionId));
    }

    public List<CommerceDiscount> getUnqualifiedCommerceDiscounts(long companyId, String commerceDiscountTargetType) {
        return this.commerceDiscountFinder.findByUnqualifiedOrder(companyId, commerceDiscountTargetType);
    }

    public int getValidCommerceDiscountsCount(long commerceAccountId, long[] commerceAccountGroupIds, long commerceChannelId, long commerceDiscountId) {
        return this.commerceDiscountFinder.countByValidCommerceDiscount(commerceAccountId, commerceAccountGroupIds, commerceChannelId, commerceDiscountId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount incrementCommerceDiscountNumberOfUse(long commerceDiscountId) throws PortalException {
        CommerceDiscount commerceDiscount = this.commerceDiscountPersistence.findByPrimaryKey(commerceDiscountId);
        commerceDiscount.setNumberOfUse(commerceDiscount.getNumberOfUse() + 1);
        return (CommerceDiscount)this.commerceDiscountPersistence.update((BaseModel)commerceDiscount);
    }

    public List<CommerceDiscount> searchByCommercePricingClassId(long commercePricingClassId, String title, int start, int end) {
        return this.commerceDiscountFinder.findByCommercePricingClassId(commercePricingClassId, title, start, end);
    }

    public BaseModelSearchResult<CommerceDiscount> searchCommerceDiscounts(long companyId, long[] groupIds, String keywords, int status, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, keywords, status, start, end, sort);
        return this.searchCommerceDiscounts(searchContext);
    }

    public BaseModelSearchResult<CommerceDiscount> searchCommerceDiscounts(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceDiscount.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceDiscount> commerceDiscounts = this.getCommerceDiscounts(hits);
            if (commerceDiscounts == null) continue;
            return new BaseModelSearchResult(commerceDiscounts, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount updateCommerceDiscount(long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.updateCommerceDiscount(commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, "", level1, level2, level3, level4, limitationType, limitationTimes, 0, true, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount updateCommerceDiscount(long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CommerceDiscount commerceDiscount = this.commerceDiscountPersistence.findByPrimaryKey(commerceDiscountId);
        this.validate(serviceContext.getCompanyId(), commerceDiscountId, title, target, useCouponCode, couponCode, limitationType);
        Date date = new Date();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), CommerceDiscountDisplayDateException.class);
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), CommerceDiscountExpirationDateException.class);
        }
        commerceDiscount.setTitle(title);
        commerceDiscount.setTarget(target);
        commerceDiscount.setUseCouponCode(useCouponCode);
        commerceDiscount.setCouponCode(couponCode);
        commerceDiscount.setUsePercentage(usePercentage);
        commerceDiscount.setMaximumDiscountAmount(maximumDiscountAmount);
        commerceDiscount.setLevel(level);
        commerceDiscount.setLevel1(level1);
        commerceDiscount.setLevel2(level2);
        commerceDiscount.setLevel3(level3);
        commerceDiscount.setLevel4(level4);
        commerceDiscount.setLimitationType(limitationType);
        commerceDiscount.setLimitationTimes(limitationTimes);
        commerceDiscount.setRulesConjunction(rulesConjunction);
        commerceDiscount.setActive(active);
        commerceDiscount.setDisplayDate(displayDate);
        commerceDiscount.setExpirationDate(expirationDate);
        if (expirationDate == null || expirationDate.after(date)) {
            commerceDiscount.setStatus(2);
        } else {
            commerceDiscount.setStatus(3);
        }
        commerceDiscount.setStatusByUserId(user.getUserId());
        commerceDiscount.setStatusDate(serviceContext.getModifiedDate(date));
        commerceDiscount.setExpandoBridgeAttributes(serviceContext);
        commerceDiscount = (CommerceDiscount)this.commerceDiscountPersistence.update((BaseModel)commerceDiscount);
        return this.startWorkflowInstance(user.getUserId(), commerceDiscount, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount updateCommerceDiscount(long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, int limitationTimesPerAccount, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CommerceDiscount commerceDiscount = this.commerceDiscountPersistence.findByPrimaryKey(commerceDiscountId);
        this.validate(serviceContext.getCompanyId(), commerceDiscountId, title, target, useCouponCode, couponCode, limitationType);
        Date date = new Date();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), CommerceDiscountDisplayDateException.class);
        Date expirationDate = null;
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), CommerceDiscountExpirationDateException.class);
        }
        commerceDiscount.setTitle(title);
        commerceDiscount.setTarget(target);
        commerceDiscount.setUseCouponCode(useCouponCode);
        commerceDiscount.setCouponCode(couponCode);
        commerceDiscount.setUsePercentage(usePercentage);
        commerceDiscount.setMaximumDiscountAmount(maximumDiscountAmount);
        commerceDiscount.setLevel(level);
        commerceDiscount.setLevel1(level1);
        commerceDiscount.setLevel2(level2);
        commerceDiscount.setLevel3(level3);
        commerceDiscount.setLevel4(level4);
        commerceDiscount.setLimitationType(limitationType);
        commerceDiscount.setLimitationTimes(limitationTimes);
        commerceDiscount.setLimitationTimesPerAccount(limitationTimesPerAccount);
        commerceDiscount.setRulesConjunction(rulesConjunction);
        commerceDiscount.setActive(active);
        commerceDiscount.setDisplayDate(displayDate);
        commerceDiscount.setExpirationDate(expirationDate);
        if (expirationDate == null || expirationDate.after(date)) {
            commerceDiscount.setStatus(2);
        } else {
            commerceDiscount.setStatus(3);
        }
        commerceDiscount.setStatusByUserId(user.getUserId());
        commerceDiscount.setStatusDate(serviceContext.getModifiedDate(date));
        commerceDiscount.setExpandoBridgeAttributes(serviceContext);
        commerceDiscount = (CommerceDiscount)this.commerceDiscountPersistence.update((BaseModel)commerceDiscount);
        return this.startWorkflowInstance(user.getUserId(), commerceDiscount, serviceContext);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount updateCommerceDiscountExternalReferenceCode(long commerceDiscountId, String externalReferenceCode) throws PortalException {
        return this.updateCommerceDiscountExternalReferenceCode(externalReferenceCode, commerceDiscountId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount updateCommerceDiscountExternalReferenceCode(String externalReferenceCode, long commerceDiscountId) throws PortalException {
        CommerceDiscount commerceDiscount = this.commerceDiscountLocalService.getCommerceDiscount(commerceDiscountId);
        commerceDiscount.setExternalReferenceCode(externalReferenceCode);
        return this.commerceDiscountLocalService.updateCommerceDiscount(commerceDiscount);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount updateStatus(long userId, long commerceDiscountId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date date = new Date();
        CommerceDiscount commerceDiscount = this.commerceDiscountPersistence.findByPrimaryKey(commerceDiscountId);
        if (status == 0 && commerceDiscount.getDisplayDate() != null && date.before(commerceDiscount.getDisplayDate())) {
            commerceDiscount.setActive(false);
            status = 7;
        }
        if (status == 0) {
            Date expirationDate = commerceDiscount.getExpirationDate();
            if (expirationDate != null && expirationDate.before(date)) {
                commerceDiscount.setExpirationDate(null);
            }
            if (commerceDiscount.getStatus() == 7) {
                commerceDiscount.setActive(true);
            }
        }
        if (status == 3) {
            commerceDiscount.setActive(false);
            commerceDiscount.setExpirationDate(date);
        }
        commerceDiscount.setStatus(status);
        commerceDiscount.setStatusByUserId(user.getUserId());
        commerceDiscount.setStatusByUserName(user.getFullName());
        commerceDiscount.setStatusDate(serviceContext.getModifiedDate(date));
        return (CommerceDiscount)this.commerceDiscountPersistence.update((BaseModel)commerceDiscount);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount upsertCommerceDiscount(long userId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, String externalReferenceCode, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommerceDiscount(externalReferenceCode, userId, commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, "", level1, level2, level3, level4, limitationType, limitationTimes, 0, true, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount upsertCommerceDiscount(long userId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, String externalReferenceCode, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommerceDiscount(externalReferenceCode, userId, commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommerceDiscount upsertCommerceDiscount(long userId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, int limitationTimesPerAccount, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, String externalReferenceCode, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommerceDiscount(externalReferenceCode, userId, commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, limitationTimesPerAccount, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    protected SearchContext buildSearchContext(long companyId, long[] groupIds, String keywords, int status, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"groupIds", (Object)groupIds).put((Object)"entryClassPK", (Object)keywords).put((Object)"status", (Object)status).put((Object)"title", (Object)keywords).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).put((Object)"skipCommerceAccountGroupValidation", (Object)true).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected void checkCommerceDiscountsByDisplayDate() throws PortalException {
        List commerceDiscounts = this.commerceDiscountPersistence.findByLtD_S(new Date(), 7);
        for (CommerceDiscount commerceDiscount : commerceDiscounts) {
            long userId = PortalUtil.getValidUserId((long)commerceDiscount.getCompanyId(), (long)commerceDiscount.getUserId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            this.commerceDiscountLocalService.updateStatus(userId, commerceDiscount.getCommerceDiscountId(), 0, serviceContext, new HashMap());
        }
    }

    protected void checkCommerceDiscountsByExpirationDate() throws PortalException {
        List commerceDiscounts = this.commerceDiscountPersistence.findByLtE_S(new Date(), 0);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Expiring " + commerceDiscounts.size() + " commerce discounts"));
        }
        if (commerceDiscounts != null && !commerceDiscounts.isEmpty()) {
            for (CommerceDiscount commerceDiscount : commerceDiscounts) {
                long userId = PortalUtil.getValidUserId((long)commerceDiscount.getCompanyId(), (long)commerceDiscount.getUserId());
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCommand("update");
                this.commerceDiscountLocalService.updateStatus(userId, commerceDiscount.getCommerceDiscountId(), 3, serviceContext, new HashMap());
            }
        }
    }

    protected List<CommerceDiscount> getCommerceDiscounts(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceDiscount> commerceDiscounts = new ArrayList<CommerceDiscount>(documents.size());
        for (Document document : documents) {
            long commerceDiscountId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceDiscount commerceDiscount = this.fetchCommerceDiscount(commerceDiscountId);
            if (commerceDiscount == null) {
                commerceDiscounts = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceDiscount.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceDiscounts == null) continue;
            commerceDiscounts.add(commerceDiscount);
        }
        return commerceDiscounts;
    }

    protected CommerceDiscount startWorkflowInstance(long userId, CommerceDiscount commerceDiscount, ServiceContext serviceContext) throws PortalException {
        HashMap workflowContext = new HashMap();
        return (CommerceDiscount)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)commerceDiscount.getCompanyId(), (long)0L, (long)userId, (String)CommerceDiscount.class.getName(), (long)commerceDiscount.getCommerceDiscountId(), (Object)commerceDiscount, (ServiceContext)serviceContext, workflowContext);
    }

    protected void validate(long companyId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, String limitationType) throws PortalException {
        if (Validator.isNull((String)title)) {
            throw new CommerceDiscountTitleException();
        }
        CommerceDiscountTarget commerceDiscountTarget = this._commerceDiscountTargetRegistry.getCommerceDiscountTarget(target);
        if (commerceDiscountTarget == null) {
            throw new CommerceDiscountTargetException();
        }
        if (useCouponCode) {
            if (Validator.isNull((String)couponCode)) {
                throw new CommerceDiscountCouponCodeException();
            }
            CommerceDiscount commerceDiscount = this.commerceDiscountPersistence.fetchByC_C_First(companyId, couponCode, (OrderByComparator)new CommerceDiscountCreateDateComparator(true));
            if (commerceDiscountId <= 0L && commerceDiscount != null || commerceDiscount != null && commerceDiscountId != commerceDiscount.getCommerceDiscountId()) {
                throw new DuplicateCommerceDiscountException();
            }
        }
        if (Validator.isNull((String)limitationType)) {
            throw new CommerceDiscountLimitationTypeException();
        }
    }

    protected void validateExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        CommerceDiscount commerceDiscount = this.commerceDiscountPersistence.fetchByC_ERC(companyId, externalReferenceCode);
        if (commerceDiscount != null) {
            throw new DuplicateCommerceDiscountException("There is another commerce discount with external reference code " + externalReferenceCode);
        }
    }

    private long[] _getAssetCategoryIds(long cpDefinitionId) {
        try {
            AssetEntry assetEntry = this._assetEntryLocalService.getEntry(CPDefinition.class.getName(), cpDefinitionId);
            HashSet<AssetCategory> assetCategories = new HashSet<AssetCategory>();
            for (AssetCategory assetCategory : assetEntry.getCategories()) {
                assetCategories.add(assetCategory);
                assetCategories.addAll(assetCategory.getAncestors());
            }
            Stream stream = assetCategories.stream();
            LongStream longStream = stream.mapToLong(AssetCategoryModel::getCategoryId);
            return longStream.toArray();
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
            return new long[0];
        }
    }
}

