/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.service.impl;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRel;
import com.liferay.commerce.discount.model.CommerceDiscountRelModel;
import com.liferay.commerce.discount.service.base.CommerceDiscountRelLocalServiceBaseImpl;
import com.liferay.commerce.discount.util.comparator.CommerceDiscountRelCreateDateComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceDiscountRelLocalServiceImpl
extends CommerceDiscountRelLocalServiceBaseImpl {
    public CommerceDiscountRel addCommerceDiscountRel(long commerceDiscountId, String className, long classPK, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long commerceDiscountRelId = this.counterLocalService.increment();
        CommerceDiscountRel commerceDiscountRel = this.commerceDiscountRelPersistence.create(commerceDiscountRelId);
        commerceDiscountRel.setCompanyId(user.getCompanyId());
        commerceDiscountRel.setUserId(user.getUserId());
        commerceDiscountRel.setUserName(user.getFullName());
        commerceDiscountRel.setCommerceDiscountId(commerceDiscountId);
        commerceDiscountRel.setClassName(className);
        commerceDiscountRel.setClassPK(classPK);
        commerceDiscountRel = (CommerceDiscountRel)this.commerceDiscountRelPersistence.update((BaseModel)commerceDiscountRel);
        this.reindexCommerceDiscount(commerceDiscountId);
        return commerceDiscountRel;
    }

    @Override
    public CommerceDiscountRel deleteCommerceDiscountRel(CommerceDiscountRel commerceDiscountRel) throws PortalException {
        this.commerceDiscountRelPersistence.remove((BaseModel)commerceDiscountRel);
        this.reindexCommerceDiscount(commerceDiscountRel.getCommerceDiscountId());
        return commerceDiscountRel;
    }

    @Override
    public CommerceDiscountRel deleteCommerceDiscountRel(long commerceDiscountRelId) throws PortalException {
        CommerceDiscountRel commerceDiscountRel = this.commerceDiscountRelPersistence.findByPrimaryKey(commerceDiscountRelId);
        return this.commerceDiscountRelLocalService.deleteCommerceDiscountRel(commerceDiscountRel);
    }

    public void deleteCommerceDiscountRels(long commerceDiscountId) throws PortalException {
        List commerceDiscountRels = this.commerceDiscountRelPersistence.findByCommerceDiscountId(commerceDiscountId);
        for (CommerceDiscountRel commerceDiscountRel : commerceDiscountRels) {
            this.commerceDiscountRelLocalService.deleteCommerceDiscountRel(commerceDiscountRel);
        }
    }

    public void deleteCommerceDiscountRels(String className, long classPK) throws PortalException {
        List commerceDiscountRels = this.commerceDiscountRelPersistence.findByCN_CPK(this.classNameLocalService.getClassNameId(className), classPK);
        for (CommerceDiscountRel commerceDiscountRel : commerceDiscountRels) {
            this.commerceDiscountRelLocalService.deleteCommerceDiscountRel(commerceDiscountRel);
        }
    }

    public CommerceDiscountRel fetchCommerceDiscountRel(String className, long classPK) {
        return this.commerceDiscountRelPersistence.fetchByCN_CPK_First(this.classNameLocalService.getClassNameId(className), classPK, (OrderByComparator)new CommerceDiscountRelCreateDateComparator());
    }

    public List<CommerceDiscountRel> getCategoriesByCommerceDiscountId(long commerceDiscountId, String name, int start, int end) {
        return this.commerceDiscountRelFinder.findCategoriesByCommerceDiscountId(commerceDiscountId, name, start, end);
    }

    public int getCategoriesByCommerceDiscountIdCount(long commerceDiscountId, String name) {
        return this.commerceDiscountRelFinder.countCategoriesByCommerceDiscountId(commerceDiscountId, name);
    }

    public long[] getClassPKs(long commerceDiscountId, String className) {
        return ListUtil.toLongArray((List)this.commerceDiscountRelPersistence.findByCD_CN(commerceDiscountId, this.classNameLocalService.getClassNameId(className)), CommerceDiscountRelModel::getClassPK);
    }

    public List<CommerceDiscountRel> getCommerceDiscountRels(long commerceDiscountId, String className) {
        return this.commerceDiscountRelPersistence.findByCD_CN(commerceDiscountId, this.classNameLocalService.getClassNameId(className));
    }

    public List<CommerceDiscountRel> getCommerceDiscountRels(long commerceDiscountId, String className, int start, int end, OrderByComparator<CommerceDiscountRel> orderByComparator) {
        return this.commerceDiscountRelPersistence.findByCD_CN(commerceDiscountId, this.classNameLocalService.getClassNameId(className), start, end, orderByComparator);
    }

    public int getCommerceDiscountRelsCount(long commerceDiscountId, String className) {
        return this.commerceDiscountRelPersistence.countByCD_CN(commerceDiscountId, this.classNameLocalService.getClassNameId(className));
    }

    public List<CommerceDiscountRel> getCommercePricingClassesByCommerceDiscountId(long commerceDiscountId, String title, int start, int end) {
        return this.commerceDiscountRelFinder.findPricingClassesByCommerceDiscountId(commerceDiscountId, title, start, end);
    }

    public int getCommercePricingClassesByCommerceDiscountIdCount(long commerceDiscountId, String title) {
        return this.commerceDiscountRelFinder.countPricingClassesByCommerceDiscountId(commerceDiscountId, title);
    }

    public List<CommerceDiscountRel> getCPDefinitionsByCommerceDiscountId(long commerceDiscountId, String name, String languageId, int start, int end) {
        return this.commerceDiscountRelFinder.findCPDefinitionsByCommerceDiscountId(commerceDiscountId, name, languageId, start, end);
    }

    public int getCPDefinitionsByCommerceDiscountIdCount(long commerceDiscountId, String name, String languageId) {
        return this.commerceDiscountRelFinder.countCPDefinitionsByCommerceDiscountId(commerceDiscountId, name, languageId);
    }

    protected void reindexCommerceDiscount(long commerceDiscountId) throws PortalException {
        CommerceDiscount commerceDiscount = this.commerceDiscountLocalService.getCommerceDiscount(commerceDiscountId);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceDiscount.class);
        indexer.reindex((Object)commerceDiscount);
    }
}

