/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.service.impl;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRel;
import com.liferay.commerce.discount.service.base.CommerceDiscountRelServiceBaseImpl;
import com.liferay.commerce.discount.service.impl.CommerceDiscountCommerceAccountGroupRelServiceImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceDiscountRelServiceImpl
extends CommerceDiscountRelServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceDiscount> _commerceDiscountResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceDiscountCommerceAccountGroupRelServiceImpl.class, (String)"_commerceDiscountResourcePermission", CommerceDiscount.class);

    public CommerceDiscountRel addCommerceDiscountRel(long commerceDiscountId, String className, long classPK, ServiceContext serviceContext) throws PortalException {
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "UPDATE");
        return this.commerceDiscountRelLocalService.addCommerceDiscountRel(commerceDiscountId, className, classPK, serviceContext);
    }

    public void deleteCommerceDiscountRel(long commerceDiscountRelId) throws PortalException {
        CommerceDiscountRel commerceDiscountRel = this.commerceDiscountRelLocalService.getCommerceDiscountRel(commerceDiscountRelId);
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountRel.getCommerceDiscountId(), "UPDATE");
        this.commerceDiscountRelLocalService.deleteCommerceDiscountRel(commerceDiscountRel);
    }

    public CommerceDiscountRel fetchCommerceDiscountRel(String className, long classPK) throws PortalException {
        CommerceDiscountRel commerceDiscountRel = this.commerceDiscountRelLocalService.fetchCommerceDiscountRel(className, classPK);
        if (commerceDiscountRel != null) {
            _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountRel.getCommerceDiscountId(), "UPDATE");
        }
        return commerceDiscountRel;
    }

    public List<CommerceDiscountRel> getCategoriesByCommerceDiscountId(long commerceDiscountId, String name, int start, int end) {
        return this.commerceDiscountRelFinder.findCategoriesByCommerceDiscountId(commerceDiscountId, name, start, end, true);
    }

    public int getCategoriesByCommerceDiscountIdCount(long commerceDiscountId, String name) {
        return this.commerceDiscountRelFinder.countCategoriesByCommerceDiscountId(commerceDiscountId, name, true);
    }

    public long[] getClassPKs(long commerceDiscountId, String className) throws PortalException {
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "UPDATE");
        return this.commerceDiscountRelLocalService.getClassPKs(commerceDiscountId, className);
    }

    public CommerceDiscountRel getCommerceDiscountRel(long commerceDiscountRelId) throws PortalException {
        CommerceDiscountRel commerceDiscountRel = this.commerceDiscountRelLocalService.getCommerceDiscountRel(commerceDiscountRelId);
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountRel.getCommerceDiscountId(), "UPDATE");
        return commerceDiscountRel;
    }

    public List<CommerceDiscountRel> getCommerceDiscountRels(long commerceDiscountId, String className) throws PortalException {
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "UPDATE");
        return this.commerceDiscountRelLocalService.getCommerceDiscountRels(commerceDiscountId, className);
    }

    public List<CommerceDiscountRel> getCommerceDiscountRels(long commerceDiscountId, String className, int start, int end, OrderByComparator<CommerceDiscountRel> orderByComparator) throws PortalException {
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "UPDATE");
        return this.commerceDiscountRelLocalService.getCommerceDiscountRels(commerceDiscountId, className, start, end, orderByComparator);
    }

    public int getCommerceDiscountRelsCount(long commerceDiscountId, String className) throws PortalException {
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "UPDATE");
        return this.commerceDiscountRelLocalService.getCommerceDiscountRelsCount(commerceDiscountId, className);
    }

    public List<CommerceDiscountRel> getCommercePricingClassesByCommerceDiscountId(long commerceDiscountId, String title, int start, int end) {
        return this.commerceDiscountRelFinder.findPricingClassesByCommerceDiscountId(commerceDiscountId, title, start, end, true);
    }

    public int getCommercePricingClassesByCommerceDiscountIdCount(long commerceDiscountId, String title) {
        return this.commerceDiscountRelFinder.countPricingClassesByCommerceDiscountId(commerceDiscountId, title, true);
    }

    public List<CommerceDiscountRel> getCPDefinitionsByCommerceDiscountId(long commerceDiscountId, String name, String languageId, int start, int end) {
        return this.commerceDiscountRelFinder.findCPDefinitionsByCommerceDiscountId(commerceDiscountId, name, languageId, start, end, true);
    }

    public int getCPDefinitionsByCommerceDiscountIdCount(long commerceDiscountId, String name, String languageId) {
        return this.commerceDiscountRelFinder.countCPDefinitionsByCommerceDiscountId(commerceDiscountId, name, languageId, true);
    }
}

