/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.service.impl;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountRule;
import com.liferay.commerce.discount.service.base.CommerceDiscountRuleServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceDiscountRuleServiceImpl
extends CommerceDiscountRuleServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceDiscount> _commerceDiscountResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceDiscountRuleServiceImpl.class, (String)"_commerceDiscountResourcePermission", CommerceDiscount.class);

    public CommerceDiscountRule addCommerceDiscountRule(long commerceDiscountId, String type, String typeSettings, ServiceContext serviceContext) throws PortalException {
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "UPDATE");
        return this.commerceDiscountRuleLocalService.addCommerceDiscountRule(commerceDiscountId, type, typeSettings, serviceContext);
    }

    public CommerceDiscountRule addCommerceDiscountRule(long commerceDiscountId, String name, String type, String typeSettings, ServiceContext serviceContext) throws PortalException {
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "UPDATE");
        return this.commerceDiscountRuleLocalService.addCommerceDiscountRule(commerceDiscountId, name, type, typeSettings, serviceContext);
    }

    public void deleteCommerceDiscountRule(long commerceDiscountRuleId) throws PortalException {
        CommerceDiscountRule commerceDiscountRule = this.commerceDiscountRuleLocalService.getCommerceDiscountRule(commerceDiscountRuleId);
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountRule.getCommerceDiscountId(), "UPDATE");
        this.commerceDiscountRuleLocalService.deleteCommerceDiscountRule(commerceDiscountRule);
    }

    public CommerceDiscountRule fetchCommerceDiscountRule(long commerceDiscountRuleId) throws PortalException {
        CommerceDiscountRule commerceDiscountRule = this.commerceDiscountRuleLocalService.fetchCommerceDiscountRule(commerceDiscountRuleId);
        if (commerceDiscountRule != null) {
            _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountRule.getCommerceDiscountId(), "UPDATE");
        }
        return commerceDiscountRule;
    }

    public CommerceDiscountRule getCommerceDiscountRule(long commerceDiscountRuleId) throws PortalException {
        CommerceDiscountRule commerceDiscountRule = this.commerceDiscountRuleLocalService.getCommerceDiscountRule(commerceDiscountRuleId);
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountRule.getCommerceDiscountId(), "UPDATE");
        return commerceDiscountRule;
    }

    public List<CommerceDiscountRule> getCommerceDiscountRules(long commerceDiscountId, int start, int end, OrderByComparator<CommerceDiscountRule> orderByComparator) throws PortalException {
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "UPDATE");
        return this.commerceDiscountRuleLocalService.getCommerceDiscountRules(commerceDiscountId, start, end, orderByComparator);
    }

    public List<CommerceDiscountRule> getCommerceDiscountRules(long commerceDiscountId, String name, int start, int end) throws PortalException {
        return this.commerceDiscountRuleFinder.findByCommerceDiscountId(commerceDiscountId, name, start, end, true);
    }

    public int getCommerceDiscountRulesCount(long commerceDiscountId) throws PortalException {
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "UPDATE");
        return this.commerceDiscountRuleLocalService.getCommerceDiscountRulesCount(commerceDiscountId);
    }

    public int getCommerceDiscountRulesCount(long commerceDiscountId, String name) throws PortalException {
        return this.commerceDiscountRuleFinder.countByCommerceDiscountId(commerceDiscountId, name, true);
    }

    public CommerceDiscountRule updateCommerceDiscountRule(long commerceDiscountRuleId, String type, String typeSettings) throws PortalException {
        CommerceDiscountRule commerceDiscountRule = this.commerceDiscountRuleLocalService.getCommerceDiscountRule(commerceDiscountRuleId);
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountRule.getCommerceDiscountId(), "UPDATE");
        return this.commerceDiscountRuleLocalService.updateCommerceDiscountRule(commerceDiscountRuleId, type, typeSettings);
    }

    public CommerceDiscountRule updateCommerceDiscountRule(long commerceDiscountRuleId, String name, String type, String typeSettings) throws PortalException {
        CommerceDiscountRule commerceDiscountRule = this.commerceDiscountRuleLocalService.getCommerceDiscountRule(commerceDiscountRuleId);
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountRule.getCommerceDiscountId(), "UPDATE");
        return this.commerceDiscountRuleLocalService.updateCommerceDiscountRule(commerceDiscountRuleId, name, type, typeSettings);
    }
}

