/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.service.impl;

import com.liferay.commerce.discount.exception.NoSuchDiscountException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.service.base.CommerceDiscountServiceBaseImpl;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Stream;

public class CommerceDiscountServiceImpl
extends CommerceDiscountServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CommerceDiscountServiceImpl.class);
    private static volatile ModelResourcePermission<CommerceDiscount> _commerceDiscountResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceDiscountServiceImpl.class, (String)"_commerceDiscountResourcePermission", CommerceDiscount.class);
    @ServiceReference(type=CommerceChannelService.class)
    private CommerceChannelService _commerceChannelService;

    public CommerceDiscount addCommerceDiscount(long userId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceDiscountResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_COMMERCE_DISCOUNT");
        return this.commerceDiscountLocalService.addCommerceDiscount(userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level1, level2, level3, level4, limitationType, limitationTimes, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommerceDiscount addCommerceDiscount(long userId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceDiscountResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_COMMERCE_DISCOUNT");
        return this.commerceDiscountLocalService.addCommerceDiscount(userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Deprecated
    public CommerceDiscount addCommerceDiscount(long userId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, int limitationTimesPerAccount, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, String externalReferenceCode, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.commerceDiscountLocalService.addCommerceDiscount(externalReferenceCode, userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, limitationTimesPerAccount, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommerceDiscount addCommerceDiscount(String externalReferenceCode, long userId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, int limitationTimesPerAccount, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        PortletResourcePermission portletResourcePermission = _commerceDiscountResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_COMMERCE_DISCOUNT");
        return this.commerceDiscountLocalService.addCommerceDiscount(externalReferenceCode, userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, limitationTimesPerAccount, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommerceDiscount addOrUpdateCommerceDiscount(String externalReferenceCode, long userId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommerceDiscount(externalReferenceCode, userId, commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, "", level1, level2, level3, level4, limitationType, limitationTimes, true, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommerceDiscount addOrUpdateCommerceDiscount(String externalReferenceCode, long userId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommerceDiscount(externalReferenceCode, userId, commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, 0, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommerceDiscount addOrUpdateCommerceDiscount(String externalReferenceCode, long userId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, int limitationTimesPerAccount, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        CommerceDiscount commerceDiscount;
        block4: {
            if (commerceDiscountId > 0L) {
                try {
                    return this.updateCommerceDiscount(commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, limitationTimesPerAccount, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
                }
                catch (NoSuchDiscountException noSuchDiscountException) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)("Unable to find discount with ID: " + commerceDiscountId), (Throwable)noSuchDiscountException);
                }
            }
        }
        if (!Validator.isBlank((String)externalReferenceCode) && (commerceDiscount = this.commerceDiscountPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode)) != null) {
            return this.updateCommerceDiscount(commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, limitationTimesPerAccount, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
        }
        return this.addCommerceDiscount(externalReferenceCode, userId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, limitationTimesPerAccount, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public void deleteCommerceDiscount(long commerceDiscountId) throws PortalException {
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "DELETE");
        this.commerceDiscountLocalService.deleteCommerceDiscount(commerceDiscountId);
    }

    @Deprecated
    public CommerceDiscount fetchByExternalReferenceCode(long companyId, String externalReferenceCode) throws PortalException {
        return this.fetchByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public CommerceDiscount fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommerceDiscount commerceDiscount = this.commerceDiscountLocalService.fetchByExternalReferenceCode(externalReferenceCode, companyId);
        if (commerceDiscount != null) {
            _commerceDiscountResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceDiscount, "VIEW");
        }
        return commerceDiscount;
    }

    public CommerceDiscount fetchCommerceDiscount(long commerceDiscountId) throws PortalException {
        CommerceDiscount commerceDiscount = this.commerceDiscountLocalService.fetchCommerceDiscount(commerceDiscountId);
        if (commerceDiscount != null) {
            _commerceDiscountResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceDiscount, "VIEW");
        }
        return commerceDiscount;
    }

    public CommerceDiscount getCommerceDiscount(long commerceDiscountId) throws PortalException {
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "VIEW");
        return this.commerceDiscountLocalService.getCommerceDiscount(commerceDiscountId);
    }

    @Deprecated
    public List<CommerceDiscount> getCommerceDiscounts(long companyId, String couponCode) throws PortalException {
        return this.commerceDiscountPersistence.filterFindByC_C(companyId, couponCode);
    }

    @Deprecated
    public int getCommerceDiscountsCount(long companyId, String couponCode) throws PortalException {
        return this.commerceDiscountPersistence.filterCountByC_C(companyId, couponCode);
    }

    public int getCommerceDiscountsCountByPricingClassId(long commercePricingClassId, String title) throws PrincipalException {
        return this.commerceDiscountFinder.countByCommercePricingClassId(commercePricingClassId, title, true);
    }

    public List<CommerceDiscount> searchByCommercePricingClassId(long commercePricingClassId, String title, int start, int end) throws PrincipalException {
        return this.commerceDiscountFinder.findByCommercePricingClassId(commercePricingClassId, title, start, end, true);
    }

    public BaseModelSearchResult<CommerceDiscount> searchCommerceDiscounts(long companyId, String keywords, int status, int start, int end, Sort sort) throws PortalException {
        List commerceChannels = this._commerceChannelService.searchCommerceChannels(companyId);
        Stream stream = commerceChannels.stream();
        long[] commerceChannelGroupIds = stream.mapToLong(CommerceChannel::getGroupId).toArray();
        return this.commerceDiscountLocalService.searchCommerceDiscounts(companyId, commerceChannelGroupIds, keywords, status, start, end, sort);
    }

    public CommerceDiscount updateCommerceDiscount(long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "UPDATE");
        return this.commerceDiscountLocalService.updateCommerceDiscount(commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level1, level2, level3, level4, limitationType, limitationTimes, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommerceDiscount updateCommerceDiscount(long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "UPDATE");
        return this.commerceDiscountLocalService.updateCommerceDiscount(commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CommerceDiscount updateCommerceDiscount(long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, int limitationTimesPerAccount, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "UPDATE");
        return this.commerceDiscountLocalService.updateCommerceDiscount(commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, limitationTimesPerAccount, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Deprecated
    public CommerceDiscount updateCommerceDiscountExternalReferenceCode(long commerceDiscountId, String externalReferenceCode) throws PortalException {
        return this.updateCommerceDiscountExternalReferenceCode(externalReferenceCode, commerceDiscountId);
    }

    public CommerceDiscount updateCommerceDiscountExternalReferenceCode(String externalReferenceCode, long commerceDiscountId) throws PortalException {
        _commerceDiscountResourcePermission.check(this.getPermissionChecker(), commerceDiscountId, "UPDATE");
        return this.commerceDiscountLocalService.updateCommerceDiscountExternalReferenceCode(externalReferenceCode, commerceDiscountId);
    }

    @Deprecated
    public CommerceDiscount upsertCommerceDiscount(long userId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, String externalReferenceCode, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommerceDiscount(externalReferenceCode, userId, commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, "", level1, level2, level3, level4, limitationType, limitationTimes, true, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Deprecated
    public CommerceDiscount upsertCommerceDiscount(long userId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, String externalReferenceCode, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommerceDiscount(externalReferenceCode, userId, commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, 0, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Deprecated
    public CommerceDiscount upsertCommerceDiscount(long userId, long commerceDiscountId, String title, String target, boolean useCouponCode, String couponCode, boolean usePercentage, BigDecimal maximumDiscountAmount, String level, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4, String limitationType, int limitationTimes, int limitationTimesPerAccount, boolean rulesConjunction, boolean active, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, String externalReferenceCode, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCommerceDiscount(externalReferenceCode, userId, commerceDiscountId, title, target, useCouponCode, couponCode, usePercentage, maximumDiscountAmount, level, level1, level2, level3, level4, limitationType, limitationTimes, limitationTimesPerAccount, rulesConjunction, active, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }
}

