/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.service.impl;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.CommerceDiscountUsageEntry;
import com.liferay.commerce.discount.service.base.CommerceDiscountUsageEntryLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.Objects;

public class CommerceDiscountUsageEntryLocalServiceImpl
extends CommerceDiscountUsageEntryLocalServiceBaseImpl {
    public CommerceDiscountUsageEntry addCommerceDiscountUsageEntry(long commerceAccountId, long commerceOrderId, long commerceDiscountId, ServiceContext serviceContext) throws PortalException {
        long userId = serviceContext.getUserId();
        User user = this.userLocalService.getUser(userId);
        if (user.isDefaultUser()) {
            userId = 0L;
        }
        long commerceDiscountUsageEntryId = this.counterLocalService.increment();
        CommerceDiscountUsageEntry commerceDiscountUsageEntry = this.commerceDiscountUsageEntryPersistence.create(commerceDiscountUsageEntryId);
        commerceDiscountUsageEntry.setCompanyId(user.getCompanyId());
        commerceDiscountUsageEntry.setUserId(userId);
        commerceDiscountUsageEntry.setUserName(user.getFullName());
        commerceDiscountUsageEntry.setCommerceAccountId(commerceAccountId);
        commerceDiscountUsageEntry.setCommerceOrderId(commerceOrderId);
        commerceDiscountUsageEntry.setCommerceDiscountId(commerceDiscountId);
        return (CommerceDiscountUsageEntry)this.commerceDiscountUsageEntryPersistence.update((BaseModel)commerceDiscountUsageEntry);
    }

    public void deleteCommerceUsageEntry(long commerceAccountId, long commerceOrderId, long commerceDiscountId) {
        CommerceDiscountUsageEntry commerceDiscountUsageEntry = this.commerceDiscountUsageEntryPersistence.fetchByA_O_D_First(commerceAccountId, commerceOrderId, commerceDiscountId, null);
        if (commerceDiscountUsageEntry != null) {
            this.commerceDiscountUsageEntryPersistence.remove((BaseModel)commerceDiscountUsageEntry);
        }
    }

    public void deleteCommerceUsageEntryByDiscountId(long commerceDiscountId) {
        this.commerceDiscountUsageEntryPersistence.removeByCommerceDiscountId(commerceDiscountId);
    }

    public int getCommerceDiscountUsageEntriesCount(long commerceDiscountId) {
        return this.commerceDiscountUsageEntryPersistence.countByCommerceDiscountId(commerceDiscountId);
    }

    public int getCommerceDiscountUsageEntriesCount(long commerceAccountId, long commerceOrderId, long commerceDiscountId) {
        return this.commerceDiscountUsageEntryPersistence.countByA_O_D(commerceAccountId, commerceOrderId, commerceDiscountId);
    }

    public int getCommerceDiscountUsageEntriesCountByAccountId(long commerceAccountId, long commerceDiscountId) {
        return this.commerceDiscountUsageEntryPersistence.countByA_D(commerceAccountId, commerceDiscountId);
    }

    public int getCommerceDiscountUsageEntriesCountByOrderId(long commerceOrderId, long commerceDiscountId) {
        return this.commerceDiscountUsageEntryPersistence.countByO_D(commerceOrderId, commerceDiscountId);
    }

    public boolean validateDiscountLimitationUsage(long commerceAccountId, long commerceDiscountId) throws PortalException {
        CommerceDiscount commerceDiscount = this.commerceDiscountLocalService.getCommerceDiscount(commerceDiscountId);
        if (Objects.equals(commerceDiscount.getLimitationType(), "unlimited")) {
            return true;
        }
        int limitationTimes = commerceDiscount.getLimitationTimes();
        if (Objects.equals(commerceDiscount.getLimitationType(), "limited")) {
            int commerceDiscountUsageEntriesCount = this.getCommerceDiscountUsageEntriesCount(commerceDiscountId);
            return commerceDiscountUsageEntriesCount < limitationTimes;
        }
        int limitationTimesPerAccount = commerceDiscount.getLimitationTimesPerAccount();
        if (Objects.equals(commerceDiscount.getLimitationType(), "limited-for-accounts")) {
            int commerceDiscountUsageEntriesCount = this.getCommerceDiscountUsageEntriesCountByAccountId(commerceAccountId, commerceDiscountId);
            return commerceDiscountUsageEntriesCount < limitationTimesPerAccount;
        }
        int commerceDiscountUsageEntriesTotalCount = this.getCommerceDiscountUsageEntriesCount(commerceDiscountId);
        if (commerceDiscountUsageEntriesTotalCount >= limitationTimes) {
            return false;
        }
        int commerceDiscountUsageEntriesUserCount = this.getCommerceDiscountUsageEntriesCountByAccountId(commerceAccountId, commerceDiscountId);
        return commerceDiscountUsageEntriesUserCount < limitationTimesPerAccount;
    }
}

