/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.discount.service.persistence.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.model.impl.CommerceDiscountImpl;
import com.liferay.commerce.discount.service.persistence.CommerceDiscountFinder;
import com.liferay.commerce.discount.service.persistence.impl.CommerceDiscountFinderBaseImpl;
import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Iterator;
import java.util.List;

public class CommerceDiscountFinderImpl
extends CommerceDiscountFinderBaseImpl
implements CommerceDiscountFinder {
    public static final String COUNT_BY_COMMERCE_PRICING_CLASS_ID = CommerceDiscountFinder.class.getName() + ".countByCommercePricingClassId";
    public static final String COUNT_BY_VALID_DISCOUNT = CommerceDiscountFinder.class.getName() + ".countByValidDiscount";
    public static final String FIND_BY_COMMERCE_PRICING_CLASS_ID = CommerceDiscountFinder.class.getName() + ".findByCommercePricingClassId";
    public static final String FIND_BY_UNQUALIFIED_PRODUCT = CommerceDiscountFinder.class.getName() + ".findByUnqualifiedProduct";
    public static final String FIND_BY_UNQUALIFIED_ORDER = CommerceDiscountFinder.class.getName() + ".findByUnqualifiedOrder";
    public static final String FIND_BY_A_C_C_PRODUCT = CommerceDiscountFinder.class.getName() + ".findByA_C_C_Product";
    public static final String FIND_BY_A_C_C_ORDER = CommerceDiscountFinder.class.getName() + ".findByA_C_C_Order";
    public static final String FIND_BY_AG_C_C_PRODUCT = CommerceDiscountFinder.class.getName() + ".findByAG_C_C_Product";
    public static final String FIND_BY_AG_C_C_ORDER = CommerceDiscountFinder.class.getName() + ".findByAG_C_C_Order";
    public static final String FIND_BY_C_C_C_PRODUCT = CommerceDiscountFinder.class.getName() + ".findByC_C_C_Product";
    public static final String FIND_BY_C_C_C_ORDER = CommerceDiscountFinder.class.getName() + ".findByC_C_C_Order";
    public static final String FIND_BY_A_C_C_C_PRODUCT = CommerceDiscountFinder.class.getName() + ".findByA_C_C_C_Product";
    public static final String FIND_BY_A_C_C_C_ORDER = CommerceDiscountFinder.class.getName() + ".findByA_C_C_C_Order";
    public static final String FIND_BY_AG_C_C_C_PRODUCT = CommerceDiscountFinder.class.getName() + ".findByAG_C_C_C_Product";
    public static final String FIND_BY_AG_C_C_C_ORDER = CommerceDiscountFinder.class.getName() + ".findByAG_C_C_C_Order";
    public static final String FIND_PL_DISCOUNT_PRODUCT = CommerceDiscountFinder.class.getName() + ".findPriceListDiscountProduct";
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;

    public int countByCommercePricingClassId(long commercePricingClassId, String title) {
        return this.countByCommercePricingClassId(commercePricingClassId, title, false);
    }

    public int countByCommercePricingClassId(long commercePricingClassId, String title, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            Iterator iterator;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_COMMERCE_PRICING_CLASS_ID);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)CommerceDiscount.class.getName(), (String)"CommerceDiscount.commerceDiscountId", null, null, (long[])new long[]{0L}, null);
            }
            String[] keywords = this._customSQL.keywords(title, true);
            if (Validator.isNotNull((String)title)) {
                sql = this._customSQL.replaceKeywords(sql, "(LOWER(CommerceDiscount.title)", "LIKE", true, keywords);
                sql = this._customSQL.replaceAndOperator(sql, false);
            } else {
                sql = StringUtil.removeSubstring((String)sql, (String)" AND (LOWER(CommerceDiscount.title) LIKE ? [$AND_OR_NULL_CHECK$])");
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(PortalUtil.getClassNameId((String)CommercePricingClass.class.getName()));
            queryPos.add(commercePricingClassId);
            if (Validator.isNotNull((String)title)) {
                queryPos.add(keywords, 2);
            }
            if ((iterator = sqlQuery.iterate()).hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByValidCommerceDiscount(long commerceAccountId, long[] commerceAccountGroupIds, long commerceChannelId, long commerceDiscountId) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_VALID_DISCOUNT);
            sql = commerceAccountGroupIds != null && commerceAccountGroupIds.length > 0 ? this.replaceQueryClassPKs(sql, "[$ACCOUNT_GROUP_IDS$]", commerceAccountGroupIds) : this.replaceQueryClassPKs(sql, "[$ACCOUNT_GROUP_IDS$]", new long[]{0L});
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(PortalUtil.getClassNameId((String)CommerceDiscount.class.getName()));
            queryPos.add(commerceDiscountId);
            queryPos.add(commerceAccountId);
            queryPos.add(commerceChannelId);
            queryPos.add(commerceAccountId);
            queryPos.add(commerceChannelId);
            queryPos.add(commerceChannelId);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommerceDiscount> findByCommercePricingClassId(long commercePricingClassId, String title, int start, int end) {
        return this.findByCommercePricingClassId(commercePricingClassId, title, start, end, false);
    }

    public List<CommerceDiscount> findByCommercePricingClassId(long commercePricingClassId, String title, int start, int end, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String[] keywords = this._customSQL.keywords(title, true);
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_COMMERCE_PRICING_CLASS_ID);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)CommerceDiscount.class.getName(), (String)"CommerceDiscount.commerceDiscountId", null, null, (long[])new long[]{0L}, null);
            }
            if (Validator.isNotNull((String)title)) {
                sql = this._customSQL.replaceKeywords(sql, "(LOWER(CommerceDiscount.title)", "LIKE", true, keywords);
                sql = this._customSQL.replaceAndOperator(sql, false);
            } else {
                sql = StringUtil.removeSubstring((String)sql, (String)" AND (LOWER(CommerceDiscount.title) LIKE ? [$AND_OR_NULL_CHECK$])");
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommerceDiscount", CommerceDiscountImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(PortalUtil.getClassNameId((String)CommercePricingClass.class.getName()));
            queryPos.add(commercePricingClassId);
            if (Validator.isNotNull((String)title)) {
                queryPos.add(keywords, 2);
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommerceDiscount> findByUnqualifiedProduct(long companyId, long cpDefinitionId, long[] assetCategoryIds, long[] commercePricingClassIds) {
        return this._findProductDiscount(FIND_BY_UNQUALIFIED_PRODUCT, companyId, null, null, null, cpDefinitionId, assetCategoryIds, commercePricingClassIds);
    }

    public List<CommerceDiscount> findByUnqualifiedOrder(long companyId, String commerceDiscountTargetType) {
        return this._findOrderDiscounts(FIND_BY_UNQUALIFIED_ORDER, companyId, null, null, null, commerceDiscountTargetType);
    }

    public List<CommerceDiscount> findByA_C_C_Product(long commerceAccountId, long cpDefinitionId, long[] assetCategoryIds, long[] commercePricingClassIds) {
        return this._findProductDiscount(FIND_BY_A_C_C_PRODUCT, null, commerceAccountId, null, -1L, cpDefinitionId, assetCategoryIds, commercePricingClassIds);
    }

    public List<CommerceDiscount> findByA_C_C_Order(long commerceAccountId, String commerceDiscountTargetType) {
        return this._findOrderDiscounts(FIND_BY_A_C_C_ORDER, null, commerceAccountId, null, -1L, commerceDiscountTargetType);
    }

    public List<CommerceDiscount> findByAG_C_C_Product(long[] commerceAccountGroupIds, long cpDefinitionId, long[] assetCategoryIds, long[] commercePricingClassIds) {
        return this._findProductDiscount(FIND_BY_AG_C_C_PRODUCT, null, null, commerceAccountGroupIds, -1L, cpDefinitionId, assetCategoryIds, commercePricingClassIds);
    }

    public List<CommerceDiscount> findByAG_C_C_Order(long[] commerceAccountGroupIds, String commerceDiscountTargetType) {
        return this._findOrderDiscounts(FIND_BY_AG_C_C_ORDER, null, null, commerceAccountGroupIds, -1L, commerceDiscountTargetType);
    }

    public List<CommerceDiscount> findByC_C_C_Product(long commerceChannelId, long cpDefinitionId, long[] assetCategoryIds, long[] commercePricingClassIds) {
        return this._findProductDiscount(FIND_BY_C_C_C_PRODUCT, null, null, null, commerceChannelId, cpDefinitionId, assetCategoryIds, commercePricingClassIds);
    }

    public List<CommerceDiscount> findByC_C_C_Order(long commerceChannelId, String commerceDiscountTargetType) {
        return this._findOrderDiscounts(FIND_BY_C_C_C_ORDER, null, null, null, commerceChannelId, commerceDiscountTargetType);
    }

    public List<CommerceDiscount> findByA_C_C_C_Product(long commerceAccountId, long commerceChannelId, long cpDefinitionId, long[] assetCategoryIds, long[] commercePricingClassIds) {
        return this._findProductDiscount(FIND_BY_A_C_C_C_PRODUCT, null, commerceAccountId, null, commerceChannelId, cpDefinitionId, assetCategoryIds, commercePricingClassIds);
    }

    public List<CommerceDiscount> findByA_C_C_C_Order(long commerceAccountId, long commerceChannelId, String commerceDiscountTargetType) {
        return this._findOrderDiscounts(FIND_BY_A_C_C_C_ORDER, null, commerceAccountId, null, commerceChannelId, commerceDiscountTargetType);
    }

    public List<CommerceDiscount> findByAG_C_C_C_Product(long[] commerceAccountGroupIds, long commerceChannelId, long cpDefinitionId, long[] assetCategoryIds, long[] commercePricingClassIds) {
        return this._findProductDiscount(FIND_BY_AG_C_C_C_PRODUCT, null, null, commerceAccountGroupIds, commerceChannelId, cpDefinitionId, assetCategoryIds, commercePricingClassIds);
    }

    public List<CommerceDiscount> findByAG_C_C_C_Order(long[] commerceAccountGroupIds, long commerceChannelId, String commerceDiscountTargetType) {
        return this._findOrderDiscounts(FIND_BY_AG_C_C_C_ORDER, null, null, commerceAccountGroupIds, commerceChannelId, commerceDiscountTargetType);
    }

    public List<CommerceDiscount> findPriceListDiscountProduct(long[] commerceDiscountIds, long cpDefinitionId, long[] assetCategoryIds, long[] commercePricingClassIds) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_PL_DISCOUNT_PRODUCT);
            sql = commerceDiscountIds != null && commerceDiscountIds.length > 0 ? this.replaceQueryClassPKs(sql, "[$DISCOUNT_IDS$]", commerceDiscountIds) : this.replaceQueryClassPKs(sql, "[$DISCOUNT_IDS$]", new long[]{0L});
            sql = assetCategoryIds != null && assetCategoryIds.length > 0 ? this.replaceQueryClassPKs(sql, "[$CLASS_PK_CATEGORIES$]", assetCategoryIds) : this.replaceQueryClassPKs(sql, "[$CLASS_PK_CATEGORIES$]", new long[]{0L});
            sql = commercePricingClassIds != null && commercePricingClassIds.length > 0 ? this.replaceQueryClassPKs(sql, "[$CLASS_PK_PRICING_CLASSES$]", commercePricingClassIds) : this.replaceQueryClassPKs(sql, "[$CLASS_PK_PRICING_CLASSES$]", new long[]{0L});
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommerceDiscount", CommerceDiscountImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(cpDefinitionId);
            queryPos.add(PortalUtil.getClassNameId((String)CPDefinition.class.getName()));
            queryPos.add(PortalUtil.getClassNameId((String)AssetCategory.class.getName()));
            queryPos.add(PortalUtil.getClassNameId((String)CommercePricingClass.class.getName()));
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)-1, (int)-1);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String replaceQueryClassPKs(String sql, String queryPlaceholder, long[] classPKs) {
        StringBundler sb = new StringBundler(classPKs.length);
        for (int i = 0; i < classPKs.length; ++i) {
            sb.append(classPKs[i]);
            if (i == classPKs.length - 1) continue;
            sb.append(", ");
        }
        return StringUtil.replace((String)sql, (String)queryPlaceholder, (String)sb.toString());
    }

    private List<CommerceDiscount> _findOrderDiscounts(String queryString, Long companyId, Long commerceAccountId, long[] commerceAccountGroupIds, Long commerceChannelId, String commerceDiscountTargetType) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), queryString);
            sql = commerceAccountGroupIds != null && commerceAccountGroupIds.length > 0 ? this.replaceQueryClassPKs(sql, "[$ACCOUNT_GROUP_IDS$]", commerceAccountGroupIds) : this.replaceQueryClassPKs(sql, "[$ACCOUNT_GROUP_IDS$]", new long[]{0L});
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommerceDiscount", CommerceDiscountImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos = this._setQueryPosDynamicParameters(companyId, commerceAccountId, commerceAccountGroupIds, commerceChannelId, queryPos);
            queryPos.add(commerceDiscountTargetType);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)-1, (int)-1);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    private List<CommerceDiscount> _findProductDiscount(String queryString, Long companyId, Long commerceAccountId, long[] commerceAccountGroupIds, Long commerceChannelId, long cpDefinitionId, long[] assetCategoryIds, long[] commercePricingClassIds) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), queryString);
            sql = commerceAccountGroupIds != null && commerceAccountGroupIds.length > 0 ? this.replaceQueryClassPKs(sql, "[$ACCOUNT_GROUP_IDS$]", commerceAccountGroupIds) : this.replaceQueryClassPKs(sql, "[$ACCOUNT_GROUP_IDS$]", new long[]{0L});
            sql = assetCategoryIds != null && assetCategoryIds.length > 0 ? this.replaceQueryClassPKs(sql, "[$CLASS_PK_CATEGORIES$]", assetCategoryIds) : this.replaceQueryClassPKs(sql, "[$CLASS_PK_CATEGORIES$]", new long[]{0L});
            sql = commercePricingClassIds != null && commercePricingClassIds.length > 0 ? this.replaceQueryClassPKs(sql, "[$CLASS_PK_PRICING_CLASSES$]", commercePricingClassIds) : this.replaceQueryClassPKs(sql, "[$CLASS_PK_PRICING_CLASSES$]", new long[]{0L});
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommerceDiscount", CommerceDiscountImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos = this._setQueryPosDynamicParameters(companyId, commerceAccountId, commerceAccountGroupIds, commerceChannelId, queryPos);
            queryPos.add("products");
            queryPos.add(cpDefinitionId);
            queryPos.add(PortalUtil.getClassNameId((String)CPDefinition.class.getName()));
            queryPos.add("categories");
            queryPos.add(PortalUtil.getClassNameId((String)AssetCategory.class.getName()));
            queryPos.add("product-groups");
            queryPos.add(PortalUtil.getClassNameId((String)CommercePricingClass.class.getName()));
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)-1, (int)-1);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    private QueryPos _setQueryPosDynamicParameters(Long companyId, Long commerceAccountId, long[] commerceAccountGroupIds, Long commerceChannelId, QueryPos queryPos) {
        if (commerceChannelId != null || commerceAccountId == null && commerceAccountGroupIds == null && commerceChannelId == null) {
            queryPos.add(PortalUtil.getClassNameId((String)CommerceDiscount.class.getName()));
        }
        if (companyId != null) {
            queryPos.add(companyId);
        }
        if (commerceAccountId != null) {
            queryPos.add(commerceAccountId);
        }
        if (commerceChannelId != null && commerceChannelId > -1L) {
            queryPos.add(commerceChannelId);
        }
        return queryPos;
    }
}

