<%--
/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
--%>

<%@ include file="/init.jsp" %>

<%
CommerceDiscountDisplayContext commerceDiscountDisplayContext = (CommerceDiscountDisplayContext)request.getAttribute(WebKeys.PORTLET_DISPLAY_CONTEXT);

CommerceDiscount commerceDiscount = commerceDiscountDisplayContext.getCommerceDiscount();

PortletURL portletURL = commerceDiscountDisplayContext.getPortletURL();

portletURL.setParameter("mvcRenderCommandName", "/commerce_discount/edit_commerce_discount");

String title = LanguageUtil.get(request, "add-discount");

if (commerceDiscount != null) {
	title = LanguageUtil.format(request, "edit-x", commerceDiscount.getTitle(), false);
}

Map<String, Object> data = HashMapBuilder.<String, Object>put(
	"direction-right", StringPool.TRUE
).build();

PortalUtil.addPortletBreadcrumbEntry(request, LanguageUtil.get(request, "discounts"), String.valueOf(renderResponse.createRenderURL()), data);
PortalUtil.addPortletBreadcrumbEntry(request, title, StringPool.BLANK, data);
%>

<%@ include file="/breadcrumb.jspf" %>

<liferay-frontend:screen-navigation
	containerCssClass="col-md-10"
	context="<%= commerceDiscount %>"
	fullContainerCssClass="col-md-8 offset-md-2"
	key="<%= CommerceDiscountScreenNavigationConstants.SCREEN_NAVIGATION_KEY_COMMERCE_DISCOUNT_GENERAL %>"
	navCssClass="col-md-2"
	portletURL="<%= currentURLObj %>"
/>