/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.frontend.internal.order;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.frontend.internal.account.model.Order;
import com.liferay.commerce.frontend.internal.account.model.OrderList;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.CommerceOrderHttpHelper;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommerceOrderResource.class})
public class CommerceOrderResource {
    private static final ObjectMapper _OBJECT_MAPPER = new ObjectMapper(){
        {
            this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            this.disable(SerializationFeature.INDENT_OUTPUT);
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderResource.class);
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOrderHttpHelper _commerceOrderHttpHelper;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private Portal _portal;

    public OrderList getOrderList(long groupId, String keywords, int page, int pageSize, HttpServletRequest httpServletRequest, CommerceAccount commerceAccount) throws PortalException {
        long companyId = this._portal.getCompanyId(httpServletRequest);
        groupId = this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(groupId);
        List<Order> orders = this.getOrders(companyId, groupId, keywords, page, pageSize, httpServletRequest);
        return new OrderList(orders, this.getOrdersCount(companyId, groupId, keywords));
    }

    protected List<Order> getOrders(long companyId, long groupId, String keywords, int page, int pageSize, HttpServletRequest httpServletRequest) throws PortalException {
        ArrayList<Order> orders = new ArrayList<Order>();
        int start = (page - 1) * pageSize;
        int end = page * pageSize;
        List userCommerceOrders = this._commerceOrderService.getUserPendingCommerceOrders(companyId, groupId, keywords, start, end);
        for (CommerceOrder commerceOrder : userCommerceOrders) {
            Date modifiedDate = commerceOrder.getModifiedDate();
            String modifiedDateTimeDescription = LanguageUtil.getTimeDescription((HttpServletRequest)httpServletRequest, (long)(System.currentTimeMillis() - modifiedDate.getTime()), (boolean)true);
            orders.add(new Order(commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId(), commerceOrder.getCommerceAccountName(), commerceOrder.getPurchaseOrderNumber(), LanguageUtil.format((HttpServletRequest)httpServletRequest, (String)"x-ago", (Object)modifiedDateTimeDescription), WorkflowConstants.getStatusLabel((int)commerceOrder.getStatus()), this._getOrderLinkURL(commerceOrder.getCommerceOrderId(), httpServletRequest)));
        }
        return orders;
    }

    protected int getOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        return (int)this._commerceOrderService.getUserPendingCommerceOrdersCount(companyId, groupId, keywords);
    }

    protected Response getResponse(Object object) {
        if (object == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            String json = _OBJECT_MAPPER.writeValueAsString(object);
            return Response.ok((Object)json, (String)"application/json").build();
        }
        catch (JsonProcessingException jsonProcessingException) {
            _log.error((Object)jsonProcessingException, (Throwable)jsonProcessingException);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    private String _getOrderLinkURL(long commerceOrderId, HttpServletRequest httpServletRequest) throws PortalException {
        PortletURL editURL = PortletProviderUtil.getPortletURL((HttpServletRequest)httpServletRequest, (String)CommerceOrder.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        editURL.setParameter("javax.portlet.action", "/commerce_open_order_content/edit_commerce_order");
        editURL.setParameter("cmd", "setCurrent");
        editURL.setParameter("commerceOrderId", String.valueOf(commerceOrderId));
        String redirect = this._portal.getCurrentURL(httpServletRequest);
        editURL.setParameter("redirect", redirect);
        return editURL.toString();
    }
}

