/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.frontend.internal.search.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommerceSearchUtil.class})
public class CommerceSearchUtil {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public String getAccountManagementFriendlyURL(ThemeDisplay themeDisplay) throws PortalException {
        LayoutSet layoutSet = themeDisplay.getLayoutSet();
        Layout layout = this._getAccountManagementLayout(themeDisplay.getScopeGroupId(), layoutSet.isPrivateLayout());
        if (layout == null) {
            return null;
        }
        return this._portal.getLayoutFriendlyURL(layout, themeDisplay);
    }

    public String getCatalogFriendlyURL(ThemeDisplay themeDisplay) throws PortalException {
        LayoutSet layoutSet = themeDisplay.getLayoutSet();
        Layout layout = this._getCatalogLayout(themeDisplay.getScopeGroupId(), layoutSet.isPrivateLayout());
        if (layout == null) {
            return null;
        }
        return this._portal.getLayoutFriendlyURL(layout, themeDisplay);
    }

    public String getOrdersFriendlyURL(ThemeDisplay themeDisplay) throws PortalException {
        LayoutSet layoutSet = themeDisplay.getLayoutSet();
        Layout layout = this._getOrdersLayout(themeDisplay.getScopeGroupId(), layoutSet.isPrivateLayout());
        if (layout == null) {
            return null;
        }
        return this._portal.getLayoutFriendlyURL(layout, themeDisplay);
    }

    public String getSearchFriendlyURL(ThemeDisplay themeDisplay) throws PortalException {
        LayoutSet layoutSet = themeDisplay.getLayoutSet();
        Layout layout = this._getSearchLayout(themeDisplay.getScopeGroupId(), layoutSet.isPrivateLayout());
        if (layout == null) {
            return null;
        }
        return this._portal.getLayoutFriendlyURL(layout, themeDisplay);
    }

    private Layout _getAccountManagementLayout(long groupId, boolean privateLayout) throws PortalException {
        Layout layout = this._layoutLocalService.fetchLayoutByFriendlyURL(groupId, privateLayout, "/accounts");
        if (layout != null) {
            return layout;
        }
        long plid = this._portal.getPlidFromPortletId(groupId, "com_liferay_commerce_account_web_internal_portlet_CommerceAccountPortlet");
        if (plid > 0L) {
            layout = this._layoutLocalService.fetchLayout(plid);
        }
        return layout;
    }

    private Layout _getCatalogLayout(long groupId, boolean privateLayout) throws PortalException {
        Layout layout = this._layoutLocalService.fetchLayoutByFriendlyURL(groupId, privateLayout, "/catalog");
        if (layout != null) {
            return layout;
        }
        long plid = this._portal.getPlidFromPortletId(groupId, "com_liferay_commerce_product_content_search_web_internal_portlet_CPSearchResultsPortlet");
        if (plid > 0L) {
            layout = this._layoutLocalService.fetchLayout(plid);
        }
        return layout;
    }

    private Layout _getOrdersLayout(long groupId, boolean privateLayout) throws PortalException {
        Layout layout = this._layoutLocalService.fetchLayoutByFriendlyURL(groupId, privateLayout, "/cart");
        if (layout == null) {
            layout = this._layoutLocalService.fetchLayoutByFriendlyURL(groupId, privateLayout, "/orders");
        }
        if (layout != null) {
            return layout;
        }
        long plid = this._portal.getPlidFromPortletId(groupId, "com_liferay_commerce_cart_content_web_internal_portlet_CommerceCartContentPortlet");
        if (plid <= 0L) {
            plid = this._portal.getPlidFromPortletId(groupId, "com_liferay_commerce_order_content_web_internal_portlet_CommerceOrderContentPortlet");
        }
        if (plid > 0L) {
            layout = this._layoutLocalService.fetchLayout(plid);
        }
        return layout;
    }

    private Layout _getSearchLayout(long groupId, boolean privateLayout) {
        return this._layoutLocalService.fetchLayoutByFriendlyURL(groupId, privateLayout, "/search");
    }
}

