/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.frontend.internal.cart;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.frontend.internal.cart.model.Cart;
import com.liferay.commerce.frontend.internal.cart.model.OrderStatusInfo;
import com.liferay.commerce.frontend.internal.cart.model.Product;
import com.liferay.commerce.frontend.internal.cart.model.Summary;
import com.liferay.commerce.frontend.model.PriceModel;
import com.liferay.commerce.frontend.model.ProductSettingsModel;
import com.liferay.commerce.frontend.util.ProductHelper;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.order.CommerceOrderValidatorRegistry;
import com.liferay.commerce.order.CommerceOrderValidatorResult;
import com.liferay.commerce.price.CommerceOrderItemPrice;
import com.liferay.commerce.price.CommerceOrderPrice;
import com.liferay.commerce.price.CommerceOrderPriceCalculation;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.util.CPInstanceHelper;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.util.CommerceUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommerceCartResourceUtil.class})
public class CommerceCartResourceUtil {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CommerceOrderPriceCalculation _commerceOrderPriceCalculation;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommerceOrderValidatorRegistry _commerceOrderValidatorRegistry;
    @Reference
    private CommercePriceFormatter _commercePriceFormatter;
    @Reference
    private CPInstanceHelper _cpInstanceHelper;
    @Reference
    private ProductHelper _productHelper;

    public Cart getCart(long commerceOrderId, String detailsUrl, Locale locale, CommerceContext commerceContext, boolean valid) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderId);
        List<Product> product = this._getProducts(commerceOrder, commerceContext, locale);
        if (valid && product.isEmpty()) {
            valid = false;
        }
        String orderStatusInfoLabel = WorkflowConstants.getStatusLabel((int)commerceOrder.getStatus());
        OrderStatusInfo orderStatusInfo = new OrderStatusInfo(commerceOrder.getOrderStatus(), orderStatusInfoLabel, LanguageUtil.get((Locale)locale, (String)orderStatusInfoLabel));
        return new Cart(detailsUrl, commerceOrderId, product, this._getSummary(commerceOrder, locale, commerceContext), valid, orderStatusInfo);
    }

    private PriceModel _getCommerceOrderItemPriceModel(CommerceOrderItem commerceOrderItem, CommerceContext commerceContext, Locale locale) throws Exception {
        CommerceOrderItemPrice commerceOrderItemPrice = this._commerceOrderPriceCalculation.getCommerceOrderItemPricePerUnit(commerceContext.getCommerceCurrency(), commerceOrderItem);
        return this._getPriceModel(commerceOrderItemPrice.getUnitPrice(), commerceOrderItemPrice.getPromoPrice(), commerceOrderItemPrice.getDiscountAmount(), commerceOrderItemPrice.getDiscountPercentage(), commerceOrderItemPrice.getDiscountPercentageLevel1(), commerceOrderItemPrice.getDiscountPercentageLevel2(), commerceOrderItemPrice.getDiscountPercentageLevel3(), commerceOrderItemPrice.getDiscountPercentageLevel4(), commerceOrderItemPrice.getFinalPrice(), locale);
    }

    private String[] _getErrorMessages(Locale locale, CommerceOrderItem commerceOrderItem) throws Exception {
        Object[] errorMessages = new String[]{};
        List commerceOrderValidatorResults = this._commerceOrderValidatorRegistry.validate(locale, commerceOrderItem);
        for (CommerceOrderValidatorResult commerceOrderValidatorResult : commerceOrderValidatorResults) {
            errorMessages = (String[])ArrayUtil.append((Object[])errorMessages, (Object)commerceOrderValidatorResult.getLocalizedMessage());
        }
        return errorMessages;
    }

    private PriceModel _getPriceModel(CommerceMoney unitPriceCommerceMoney, CommerceMoney promoPriceCommerceMoney, CommerceMoney discountAmountCommerceMoney, BigDecimal discountPercentage, BigDecimal discountPercentageLevel1, BigDecimal discountPercentageLevel2, BigDecimal discountPercentageLevel3, BigDecimal discountPercentageLevel4, CommerceMoney finalPriceCommerceMoney, Locale locale) throws Exception {
        PriceModel priceModel = new PriceModel(unitPriceCommerceMoney.format(locale));
        if (promoPriceCommerceMoney != null) {
            priceModel.setPromoPrice(promoPriceCommerceMoney.format(locale));
        }
        if (discountAmountCommerceMoney == null) {
            return priceModel;
        }
        BigDecimal discountAmount = discountAmountCommerceMoney.getPrice();
        if (discountAmount == null || discountAmount.compareTo(BigDecimal.ZERO) == 0) {
            return priceModel;
        }
        priceModel.setDiscount(discountAmountCommerceMoney.format(locale));
        priceModel.setDiscountPercentage(this._commercePriceFormatter.format(discountPercentage, locale));
        BigDecimal level1 = BigDecimal.ZERO;
        BigDecimal level2 = BigDecimal.ZERO;
        BigDecimal level3 = BigDecimal.ZERO;
        BigDecimal level4 = BigDecimal.ZERO;
        if (discountPercentageLevel1 != null) {
            level1 = discountPercentageLevel1;
        }
        if (discountPercentageLevel2 != null) {
            level2 = discountPercentageLevel2;
        }
        if (discountPercentageLevel3 != null) {
            level3 = discountPercentageLevel3;
        }
        if (discountPercentageLevel4 != null) {
            level4 = discountPercentageLevel4;
        }
        String[] discountPercentages = new String[]{level1.toString(), level2.toString(), level3.toString(), level4.toString()};
        priceModel.setDiscountPercentages(discountPercentages);
        priceModel.setFinalPrice(finalPriceCommerceMoney.format(locale));
        return priceModel;
    }

    private List<Product> _getProducts(CommerceOrder commerceOrder, CommerceContext commerceContext, Locale locale) throws Exception {
        ArrayList<Product> products = new ArrayList<Product>();
        List commerceOrderItems = commerceOrder.getCommerceOrderItems();
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            PriceModel prices = this._getCommerceOrderItemPriceModel(commerceOrderItem, commerceContext, locale);
            ProductSettingsModel settings = this._productHelper.getProductSettingsModel(commerceOrderItem.getCPInstanceId());
            Product product = new Product(commerceOrderItem.getCommerceOrderItemId(), commerceOrderItem.getParentCommerceOrderItemId(), commerceOrderItem.getName(locale), commerceOrderItem.getSku(), commerceOrderItem.getQuantity(), this._cpInstanceHelper.getCPInstanceThumbnailSrc(CommerceUtil.getCommerceAccountId((CommerceContext)commerceContext), commerceOrderItem.getCPInstanceId()), prices, settings, this._getErrorMessages(locale, commerceOrderItem), commerceOrderItem.getCPInstanceId());
            long commerceOptionValueCPDefinitionId = commerceOrderItem.getCPDefinitionId();
            if (commerceOrderItem.hasParentCommerceOrderItem()) {
                commerceOptionValueCPDefinitionId = commerceOrderItem.getParentCommerceOrderItemCPDefinitionId();
            }
            product.setOptions(this._cpInstanceHelper.getKeyValuePairs(commerceOptionValueCPDefinitionId, commerceOrderItem.getJson(), locale));
            products.add(product);
        }
        return this._groupProductByOrderItemId(products);
    }

    private Summary _getSummary(CommerceOrder commerceOrder, Locale locale, CommerceContext commerceContext) throws Exception {
        CommerceOrderPrice commerceOrderPrice = this._commerceOrderPriceCalculation.getCommerceOrderPrice(commerceOrder, commerceContext);
        if (commerceOrderPrice == null) {
            return null;
        }
        CommerceMoney subtotalCommerceMoney = commerceOrderPrice.getSubtotal();
        CommerceMoney totalCommerceMoney = commerceOrderPrice.getTotal();
        int itemsQuantity = this._commerceOrderItemService.getCommerceOrderItemsQuantity(commerceOrder.getCommerceOrderId());
        CommerceDiscountValue totalCommerceDiscountValue = commerceOrderPrice.getTotalDiscountValue();
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
        String priceDisplayType = commerceChannel.getPriceDisplayType();
        if (priceDisplayType.equals("tax-included")) {
            subtotalCommerceMoney = commerceOrderPrice.getSubtotalWithTaxAmount();
            totalCommerceMoney = commerceOrderPrice.getTotalWithTaxAmount();
            totalCommerceDiscountValue = commerceOrderPrice.getTotalDiscountValueWithTaxAmount();
        }
        Summary summary = new Summary(subtotalCommerceMoney.format(locale), totalCommerceMoney.format(locale), itemsQuantity);
        if (totalCommerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = totalCommerceDiscountValue.getDiscountAmount();
            summary.setDiscount(discountAmountCommerceMoney.format(locale));
        }
        return summary;
    }

    private List<Product> _groupProductByOrderItemId(List<Product> products) {
        HashMap<Long, Product> productMap = new HashMap<Long, Product>();
        for (Product product : products) {
            productMap.put(product.getId(), product);
        }
        for (Product product : products) {
            Product parent;
            long parentProductId = product.getParentProductId();
            if (parentProductId == 0L || (parent = (Product)productMap.get(parentProductId)) == null) continue;
            if (parent.getChildItems() == null) {
                parent.setChildItems(new ArrayList<Product>());
            }
            List<Product> childItems = parent.getChildItems();
            childItems.add(product);
            productMap.remove(product.getId());
        }
        return new ArrayList<Product>(productMap.values());
    }
}

