/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.frontend.internal.address;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.country.CommerceCountryManager;
import com.liferay.commerce.frontend.internal.address.model.CountryModel;
import com.liferay.commerce.frontend.internal.address.model.RegionModel;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.service.CommerceAddressService;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.RegionService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={AddressResource.class})
public class AddressResource {
    private static final ObjectMapper _OBJECT_MAPPER = new ObjectMapper(){
        {
            this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            this.enable(SerializationFeature.INDENT_OUTPUT);
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(AddressResource.class);
    @Reference
    private CommerceAddressService _commerceAddressService;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceCountryManager _commerceCountryManager;
    @Reference
    private CountryService _countryService;
    @Reference
    private RegionService _regionService;

    @GET
    @Path(value="/address/{id}")
    @Produces(value={"application/json"})
    public Response getCommerceAddress(@PathParam(value="id") long commerceAddressId) {
        try {
            CommerceAddress commerceAddress = this._commerceAddressService.fetchCommerceAddress(commerceAddressId);
            if (commerceAddress != null) {
                String json = _OBJECT_MAPPER.writeValueAsString((Object)JSONFactoryUtil.looseSerialize((Object)commerceAddress));
                return Response.ok((Object)json, (String)"application/json").build();
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    @GET
    @Path(value="/address/regions/{countryId}")
    @Produces(value={"application/json"})
    public Response getRegions(@PathParam(value="countryId") long countryId, @Context ThemeDisplay themeDisplay) {
        ArrayList<RegionModel> regionModels = new ArrayList<RegionModel>();
        List regions = this._regionService.getRegions(countryId, true);
        for (Region region : regions) {
            regionModels.add(new RegionModel(region.getRegionId(), region.getName()));
        }
        try {
            String json = _OBJECT_MAPPER.writeValueAsString(regionModels);
            return Response.ok((Object)json, (String)"application/json").build();
        }
        catch (JsonProcessingException jsonProcessingException) {
            _log.error((Throwable)jsonProcessingException);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Deprecated
    @GET
    @Path(value="/address/countries")
    @Produces(value={"application/json"})
    public Response getShippingCountries(@QueryParam(value="companyId") long companyId, @Context ThemeDisplay themeDisplay) {
        return this._getCountries(this._countryService.getCompanyCountries(companyId, true), themeDisplay.getLanguageId());
    }

    @GET
    @Path(value="/address/countries")
    @Produces(value={"application/json"})
    public Response getShippingCountries(@Context ThemeDisplay themeDisplay) {
        List countries = this._countryService.getCompanyCountries(themeDisplay.getCompanyId(), true);
        return this._getCountries(countries, themeDisplay.getLanguageId());
    }

    @GET
    @Path(value="/address/countries-by-channel-id")
    @Produces(value={"application/json"})
    public Response getShippingCountriesByChannelId(@QueryParam(value="channelId") long channelId, @Context ThemeDisplay themeDisplay) {
        List countries = this._commerceCountryManager.getShippingCountriesByChannelId(channelId, -1, -1);
        return this._getCountries(countries, themeDisplay.getLanguageId());
    }

    private Response _getCountries(List<Country> countries, String languageId) {
        ArrayList<CountryModel> countryModels = new ArrayList<CountryModel>();
        for (Country country : countries) {
            countryModels.add(new CountryModel(country.getCountryId(), country.getTitle(languageId), country.isBillingAllowed(), country.isShippingAllowed()));
        }
        try {
            String json = _OBJECT_MAPPER.writeValueAsString(countryModels);
            return Response.ok((Object)json, (String)"application/json").build();
        }
        catch (JsonProcessingException jsonProcessingException) {
            _log.error((Throwable)jsonProcessingException);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

