/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.frontend.internal.search;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.frontend.internal.account.CommerceAccountResource;
import com.liferay.commerce.frontend.internal.account.model.Account;
import com.liferay.commerce.frontend.internal.account.model.AccountList;
import com.liferay.commerce.frontend.internal.account.model.Order;
import com.liferay.commerce.frontend.internal.account.model.OrderList;
import com.liferay.commerce.frontend.internal.order.CommerceOrderResource;
import com.liferay.commerce.frontend.internal.search.model.SearchItemModel;
import com.liferay.commerce.frontend.internal.search.util.CommerceSearchUtil;
import com.liferay.commerce.order.CommerceOrderHttpHelper;
import com.liferay.commerce.product.catalog.CPCatalogEntry;
import com.liferay.commerce.product.catalog.CPQuery;
import com.liferay.commerce.product.data.source.CPDataSourceResult;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.util.CPDefinitionHelper;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={CommerceSearchResource.class})
public class CommerceSearchResource {
    private static final ObjectMapper _OBJECT_MAPPER = new ObjectMapper(){
        {
            this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            this.disable(SerializationFeature.INDENT_OUTPUT);
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(CommerceSearchResource.class);
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private CommerceAccountResource _commerceAccountResource;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceOrderHttpHelper _commerceOrderHttpHelper;
    @Reference
    private CommerceOrderResource _commerceOrderResource;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommerceSearchUtil _commerceSearchUtil;
    @Reference
    private CPDefinitionHelper _cpDefinitionHelper;
    @Reference
    private HtmlParser _htmlParser;
    @Reference
    private Language _language;
    @Reference
    private LayoutLocalService _layoutLocalService;

    @GET
    @Path(value="/search/{plid}")
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="plid") long plid, @QueryParam(value="q") String queryString, @Context ThemeDisplay themeDisplay, @Context HttpServletRequest httpServletRequest) {
        try {
            String url;
            Layout layout = this._layoutLocalService.getLayout(plid);
            themeDisplay.setLayout(layout);
            themeDisplay.setLayoutSet(layout.getLayoutSet());
            themeDisplay.setScopeGroupId(layout.getGroupId());
            ArrayList<SearchItemModel> searchItemModels = new ArrayList<SearchItemModel>();
            searchItemModels.addAll(this._searchProducts(themeDisplay.getCompanyId(), layout.getGroupId(), queryString, themeDisplay));
            if (themeDisplay.isSignedIn()) {
                searchItemModels.addAll(this._searchAccounts(queryString, themeDisplay));
                CommerceAccount commerceAccount = this._commerceAccountHelper.getCurrentCommerceAccount(this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(themeDisplay.getScopeGroupId()), httpServletRequest);
                searchItemModels.addAll(this._searchOrders(queryString, themeDisplay, commerceAccount));
            }
            if (Validator.isNotNull((String)(url = this._commerceSearchUtil.getSearchFriendlyURL(themeDisplay)))) {
                url = HttpComponentsUtil.addParameter((String)url, (String)"q", (String)queryString);
                SearchItemModel searchItemModel = new SearchItemModel("category", this._language.get(themeDisplay.getLocale(), "all-content"));
                searchItemModel.setUrl(url);
                searchItemModels.add(searchItemModel);
            }
            String json = _OBJECT_MAPPER.writeValueAsString(searchItemModels);
            return Response.ok((Object)json, (String)"application/json").build();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
    }

    private String _getAccountManagementPortletEditURL(long accountId, ThemeDisplay themeDisplay) throws PortalException {
        PortletURL editURL = PortletProviderUtil.getPortletURL((HttpServletRequest)themeDisplay.getRequest(), (String)CommerceAccount.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        if (editURL == null) {
            return "";
        }
        editURL.setParameter("commerceAccountId", String.valueOf(accountId));
        return editURL.toString();
    }

    private SearchItemModel _getSearchItemModel(long commerceAccountId, CPCatalogEntry cpCatalogEntry, ThemeDisplay themeDisplay) throws PortalException {
        SearchItemModel searchItemModel = new SearchItemModel("item", HtmlUtil.escape((String)cpCatalogEntry.getName()));
        searchItemModel.setImage(this._cpDefinitionHelper.getDefaultImageFileURL(commerceAccountId, cpCatalogEntry.getCPDefinitionId()));
        String subtitle = cpCatalogEntry.getShortDescription();
        if (Validator.isNull((String)subtitle)) {
            subtitle = this._htmlParser.extractText(cpCatalogEntry.getDescription());
        }
        searchItemModel.setSubtitle(subtitle);
        searchItemModel.setUrl(this._cpDefinitionHelper.getFriendlyURL(cpCatalogEntry.getCPDefinitionId(), themeDisplay));
        return searchItemModel;
    }

    private List<SearchItemModel> _searchAccounts(String queryString, ThemeDisplay themeDisplay) throws PortalException {
        ArrayList<SearchItemModel> searchItemModels = new ArrayList<SearchItemModel>();
        CommerceContext commerceContext = this._commerceContextFactory.create(themeDisplay.getCompanyId(), this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(themeDisplay.getScopeGroupId()), themeDisplay.getUserId(), 0L, 0L);
        AccountList accountList = this._commerceAccountResource.getAccountList(themeDisplay.getUserId(), 0L, commerceContext.getCommerceSiteType(), queryString, 1, 5, themeDisplay.getPathImage());
        if (accountList.getCount() > 0) {
            searchItemModels.add(new SearchItemModel("label", this._language.get(themeDisplay.getLocale(), "accounts")));
        }
        for (Account account : accountList.getAccounts()) {
            SearchItemModel searchItemModel = new SearchItemModel("item", account.getName());
            searchItemModel.setImage(account.getThumbnail());
            searchItemModel.setUrl(this._getAccountManagementPortletEditURL(GetterUtil.getLong((String)account.getAccountId()), themeDisplay));
            searchItemModels.add(searchItemModel);
        }
        String url = this._commerceSearchUtil.getAccountManagementFriendlyURL(themeDisplay);
        if (Validator.isNotNull((String)url)) {
            url = HttpComponentsUtil.addParameter((String)url, (String)"q", (String)queryString);
            SearchItemModel searchItemModel = new SearchItemModel("category", this._language.get(themeDisplay.getLocale(), "accounts"));
            searchItemModel.setUrl(url);
            searchItemModels.add(searchItemModel);
        }
        return searchItemModels;
    }

    private List<SearchItemModel> _searchOrders(String queryString, ThemeDisplay themeDisplay, CommerceAccount commerceAccount) throws PortalException {
        ArrayList<SearchItemModel> searchItemModels = new ArrayList<SearchItemModel>();
        OrderList orderList = this._commerceOrderResource.getOrderList(themeDisplay.getScopeGroupId(), queryString, 1, 5, themeDisplay.getRequest(), commerceAccount);
        if (orderList.getCount() > 0) {
            searchItemModels.add(new SearchItemModel("label", this._language.get(themeDisplay.getLocale(), "orders")));
        }
        for (Order order : orderList.getOrders()) {
            SearchItemModel searchItemModel = new SearchItemModel("item", String.valueOf(order.getId()));
            searchItemModel.setIcon("document");
            searchItemModel.setSubtitle(order.getAccountName());
            searchItemModel.setUrl(String.valueOf(this._commerceOrderHttpHelper.getCommerceCartPortletURL(themeDisplay.getScopeGroupId(), themeDisplay.getRequest(), this._commerceOrderService.getCommerceOrder(order.getId()))));
            searchItemModels.add(searchItemModel);
        }
        String url = this._commerceSearchUtil.getOrdersFriendlyURL(themeDisplay);
        if (Validator.isNotNull((String)url)) {
            url = HttpComponentsUtil.addParameter((String)url, (String)"q", (String)queryString);
            SearchItemModel searchItemModel = new SearchItemModel("category", this._language.get(themeDisplay.getLocale(), "orders"));
            searchItemModel.setUrl(url);
            searchItemModels.add(searchItemModel);
        }
        return searchItemModels;
    }

    private List<SearchItemModel> _searchProducts(long companyId, long groupId, String queryString, ThemeDisplay themeDisplay) throws PortalException {
        ArrayList<SearchItemModel> searchItemModels = new ArrayList<SearchItemModel>();
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)themeDisplay.getLocale(), this.getClass());
        SearchContext searchContext = new SearchContext();
        HashMap attributes = HashMapBuilder.put((Object)"status", (Object)0).build();
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(themeDisplay.getScopeGroupId());
        if (commerceChannel != null) {
            attributes.put("commerceChannelGroupId", commerceChannel.getGroupId());
        }
        long commerceAccountId = 0L;
        CommerceAccount commerceAccount = this._commerceAccountHelper.getCurrentCommerceAccount(commerceChannel.getGroupId(), themeDisplay.getRequest());
        if (commerceAccount != null) {
            commerceAccountId = commerceAccount.getCommerceAccountId();
            attributes.put("commerceAccountGroupIds", this._commerceAccountHelper.getCommerceAccountGroupIds(commerceAccountId));
        }
        searchContext.setAttributes((Map)attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setKeywords(queryString);
        CPQuery cpQuery = new CPQuery();
        cpQuery.setOrderByCol1("title");
        cpQuery.setOrderByCol2("modifiedDate");
        cpQuery.setOrderByType1("ASC");
        cpQuery.setOrderByType2("DESC");
        CPDataSourceResult cpDataSourceResult = this._cpDefinitionHelper.search(groupId, searchContext, cpQuery, 0, 5);
        if (cpDataSourceResult.getLength() > 0) {
            searchItemModels.add(new SearchItemModel("label", this._language.get(resourceBundle, "catalog")));
        }
        for (CPCatalogEntry cpCatalogEntry : cpDataSourceResult.getCPCatalogEntries()) {
            searchItemModels.add(this._getSearchItemModel(commerceAccountId, cpCatalogEntry, themeDisplay));
        }
        String url = this._commerceSearchUtil.getCatalogFriendlyURL(themeDisplay);
        if (Validator.isNotNull((String)url)) {
            url = HttpComponentsUtil.addParameter((String)url, (String)"q", (String)queryString);
            SearchItemModel searchItemModel = new SearchItemModel("category", this._language.get(resourceBundle, "catalog"));
            searchItemModel.setUrl(url);
            searchItemModels.add(searchItemModel);
        }
        return searchItemModels;
    }
}

