/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.frontend.internal.util;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.util.CommercePriceFormatter;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.frontend.model.PriceModel;
import com.liferay.commerce.frontend.model.ProductSettingsModel;
import com.liferay.commerce.frontend.util.ProductHelper;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngineRegistry;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.percentage.PercentageFormatter;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.price.CommerceProductPriceRequest;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.option.CommerceOptionValue;
import com.liferay.commerce.product.option.CommerceOptionValueHelper;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={ProductHelper.class})
public class ProductHelperImpl
implements ProductHelper {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOptionValueHelper _commerceOptionValueHelper;
    @Reference
    private CommercePriceFormatter _commercePriceFormatter;
    @Reference
    private CommerceProductPriceCalculation _commerceProductPriceCalculation;
    @Reference
    private CPDefinitionInventoryEngineRegistry _cpDefinitionInventoryEngineRegistry;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private Language _language;
    @Reference
    private PercentageFormatter _percentageFormatter;

    public PriceModel getMinPrice(long cpDefinitionId, CommerceContext commerceContext, Locale locale) throws PortalException {
        CommerceMoney cpDefinitionMinimumPriceCommerceMoney = this._commerceProductPriceCalculation.getCPDefinitionMinimumPrice(cpDefinitionId, commerceContext);
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return new PriceModel(this._language.format(resourceBundle, "from-x", (Object)cpDefinitionMinimumPriceCommerceMoney.format(locale), false));
    }

    @Deprecated
    public PriceModel getPrice(long cpInstanceId, int quantity, CommerceContext commerceContext, Locale locale) throws PortalException {
        return this.getPriceModel(cpInstanceId, quantity, commerceContext, "", locale);
    }

    public PriceModel getPriceModel(long cpInstanceId, int quantity, CommerceContext commerceContext, String commerceOptionValuesJSON, Locale locale) throws PortalException {
        CommerceProductPriceRequest commerceProductPriceRequest = new CommerceProductPriceRequest();
        commerceProductPriceRequest.setCpInstanceId(cpInstanceId);
        commerceProductPriceRequest.setQuantity(quantity);
        commerceProductPriceRequest.setCommerceContext(commerceContext);
        commerceProductPriceRequest.setCommerceOptionValues(this._getCommerceOptionValues(cpInstanceId, commerceOptionValuesJSON));
        commerceProductPriceRequest.setSecure(true);
        boolean taxIncludedInPrice = this._isTaxIncludedInPrice(commerceContext.getCommerceChannelId());
        commerceProductPriceRequest.setCalculateTax(taxIncludedInPrice);
        CommerceProductPrice commerceProductPrice = this._commerceProductPriceCalculation.getCommerceProductPrice(commerceProductPriceRequest);
        if (commerceProductPrice == null) {
            return null;
        }
        if (taxIncludedInPrice) {
            return this._getPriceModel(commerceProductPrice.getFinalPriceWithTaxAmount(), commerceProductPrice.getUnitPriceWithTaxAmount(), commerceProductPrice.getUnitPromoPriceWithTaxAmount(), commerceProductPrice.getDiscountValueWithTaxAmount(), locale);
        }
        return this._getPriceModel(commerceProductPrice.getFinalPrice(), commerceProductPrice.getUnitPrice(), commerceProductPrice.getUnitPromoPrice(), commerceProductPrice.getDiscountValue(), locale);
    }

    public ProductSettingsModel getProductSettingsModel(long cpInstanceId) throws PortalException {
        ProductSettingsModel productSettingsModel = new ProductSettingsModel();
        int minOrderQuantity = 1;
        int maxOrderQuantity = 10000;
        int multipleQuantity = 1;
        CPDefinitionInventory cpDefinitionInventory = null;
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        if (cpInstance != null) {
            cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        }
        if (cpDefinitionInventory != null) {
            minOrderQuantity = cpDefinitionInventory.getMinOrderQuantity();
            maxOrderQuantity = cpDefinitionInventory.getMaxOrderQuantity();
            multipleQuantity = cpDefinitionInventory.getMultipleOrderQuantity();
            int[] allowedOrderQuantitiesArray = cpDefinitionInventory.getAllowedOrderQuantitiesArray();
            if (allowedOrderQuantitiesArray != null && allowedOrderQuantitiesArray.length > 0) {
                productSettingsModel.setAllowedQuantities(allowedOrderQuantitiesArray);
            }
            productSettingsModel.setBackOrders(cpDefinitionInventory.isBackOrders());
            productSettingsModel.setLowStockQuantity(cpDefinitionInventory.getMinStockQuantity());
            productSettingsModel.setShowAvailabilityDot(cpDefinitionInventory.isDisplayAvailability());
        }
        productSettingsModel.setMinQuantity(minOrderQuantity);
        productSettingsModel.setMaxQuantity(maxOrderQuantity);
        productSettingsModel.setMultipleQuantity(multipleQuantity);
        return productSettingsModel;
    }

    private List<CommerceOptionValue> _getCommerceOptionValues(long cpInstanceId, String ddmFormValues) throws PortalException {
        if (Validator.isNull((String)ddmFormValues)) {
            return Collections.emptyList();
        }
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        return this._commerceOptionValueHelper.getCPDefinitionCommerceOptionValues(cpInstance.getCPDefinitionId(), ddmFormValues);
    }

    private String[] _getFormattedDiscountPercentages(BigDecimal[] discountPercentages, Locale locale) throws PortalException {
        ArrayList<String> formattedDiscountPercentages = new ArrayList<String>();
        for (BigDecimal percentage : discountPercentages) {
            if (percentage == null) {
                percentage = BigDecimal.ZERO;
            }
            formattedDiscountPercentages.add(this._commercePriceFormatter.format(percentage, locale));
        }
        return formattedDiscountPercentages.toArray(new String[0]);
    }

    private PriceModel _getPriceModel(CommerceMoney finalPriceCommerceMoney, CommerceMoney unitPriceCommerceMoney, CommerceMoney unitPromoPriceCommerceMoney, CommerceDiscountValue commerceDiscountValue, Locale locale) throws PortalException {
        BigDecimal unitPromoPrice;
        PriceModel priceModel = new PriceModel(unitPriceCommerceMoney.format(locale));
        if (!unitPromoPriceCommerceMoney.isEmpty() && (unitPromoPrice = unitPromoPriceCommerceMoney.getPrice()).compareTo(BigDecimal.ZERO) > 0 && unitPromoPrice.compareTo(unitPriceCommerceMoney.getPrice()) < 0) {
            priceModel.setPromoPrice(unitPromoPriceCommerceMoney.format(locale));
        }
        return this._updatePriceModelDiscount(priceModel, commerceDiscountValue, finalPriceCommerceMoney, locale);
    }

    private boolean _isTaxIncludedInPrice(long commerceChannelId) throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(commerceChannelId);
        String priceDisplayType = commerceChannel.getPriceDisplayType();
        return priceDisplayType.equals("tax-included");
    }

    private PriceModel _updatePriceModelDiscount(PriceModel priceModel, CommerceDiscountValue commerceDiscountValue, CommerceMoney finalPriceCommerceMoney, Locale locale) throws PortalException {
        if (commerceDiscountValue == null) {
            return priceModel;
        }
        CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
        priceModel.setDiscount(discountAmountCommerceMoney.format(locale));
        CommerceCurrency commerceCurrency = discountAmountCommerceMoney.getCommerceCurrency();
        priceModel.setDiscountPercentage(this._percentageFormatter.getLocalizedPercentage(locale, commerceCurrency.getMaxFractionDigits(), commerceCurrency.getMinFractionDigits(), commerceDiscountValue.getDiscountPercentage()));
        priceModel.setDiscountPercentages(this._getFormattedDiscountPercentages(commerceDiscountValue.getPercentages(), locale));
        priceModel.setFinalPrice(finalPriceCommerceMoney.format(locale));
        return priceModel;
    }
}

