/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.frontend.internal.order;

import com.liferay.commerce.frontend.internal.account.model.Order;
import com.liferay.commerce.frontend.internal.account.model.OrderList;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceOrderResource.class})
public class CommerceOrderResource {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;

    public OrderList getOrderList(long groupId, String keywords, int page, int pageSize, HttpServletRequest httpServletRequest) throws PortalException {
        long companyId = this._portal.getCompanyId(httpServletRequest);
        groupId = this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(groupId);
        List<Order> orders = this._getOrders(companyId, groupId, keywords, page, pageSize, httpServletRequest);
        return new OrderList(orders, this._getOrdersCount(companyId, groupId, keywords));
    }

    private String _getOrderLinkURL(long commerceOrderId, HttpServletRequest httpServletRequest) throws PortalException {
        PortletURL editURL = PortletURLBuilder.create((PortletURL)PortletProviderUtil.getPortletURL((HttpServletRequest)httpServletRequest, (String)CommerceOrder.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT)).setActionName("/commerce_open_order_content/edit_commerce_order").setCMD("setCurrent").setParameter("commerceOrderId", (Object)commerceOrderId).buildPortletURL();
        String redirect = this._portal.getCurrentURL(httpServletRequest);
        editURL.setParameter("redirect", redirect);
        return editURL.toString();
    }

    private List<Order> _getOrders(long companyId, long groupId, String keywords, int page, int pageSize, HttpServletRequest httpServletRequest) throws PortalException {
        ArrayList<Order> orders = new ArrayList<Order>();
        int start = (page - 1) * pageSize;
        int end = page * pageSize;
        List userCommerceOrders = this._commerceOrderService.getUserCommerceOrders(companyId, groupId, keywords, start, end);
        for (CommerceOrder commerceOrder : userCommerceOrders) {
            Date modifiedDate = commerceOrder.getModifiedDate();
            String modifiedDateTimeDescription = this._language.getTimeDescription(httpServletRequest, System.currentTimeMillis() - modifiedDate.getTime(), true);
            orders.add(new Order(commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId(), commerceOrder.getCommerceAccountName(), commerceOrder.getPurchaseOrderNumber(), this._language.format(httpServletRequest, "x-ago", (Object)modifiedDateTimeDescription), WorkflowConstants.getStatusLabel((int)commerceOrder.getStatus()), this._getOrderLinkURL(commerceOrder.getCommerceOrderId(), httpServletRequest)));
        }
        return orders;
    }

    private int _getOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        return (int)this._commerceOrderService.getUserPendingCommerceOrdersCount(companyId, groupId, keywords);
    }
}

