/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.frontend.internal.account;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.frontend.internal.account.model.Account;
import com.liferay.commerce.frontend.internal.account.model.AccountList;
import com.liferay.commerce.frontend.internal.account.model.AccountOrganization;
import com.liferay.commerce.frontend.internal.account.model.AccountOrganizationList;
import com.liferay.commerce.frontend.internal.account.model.AccountUser;
import com.liferay.commerce.frontend.internal.account.model.AccountUserList;
import com.liferay.commerce.frontend.internal.account.model.Order;
import com.liferay.commerce.frontend.internal.account.model.OrderList;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.util.CommerceAccountHelper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.webserver.WebServerServletToken;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceAccountResource.class})
public class CommerceAccountResource {
    private static final ObjectMapper _OBJECT_MAPPER = new ObjectMapper(){
        {
            this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            this.disable(SerializationFeature.INDENT_OUTPUT);
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(CommerceAccountResource.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private Language _language;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WebServerServletToken _webServerServletToken;

    public AccountList getAccountList(long userId, long parentAccountId, int commerceSiteType, String keywords, int page, int pageSize, String imagePath) throws PortalException {
        List<Account> accounts = this._getAccounts(userId, parentAccountId, commerceSiteType, keywords, page, pageSize, imagePath);
        return new AccountList(accounts, this._getAccountsCount(userId, parentAccountId, commerceSiteType, keywords));
    }

    public AccountOrganizationList getAccountOrganizationList(long companyId, String keywords, String imagePath) throws PortalException {
        List<AccountOrganization> accountOrganizations = this._searchOrganizations(companyId, keywords, imagePath);
        return new AccountOrganizationList(accountOrganizations, accountOrganizations.size());
    }

    public AccountUserList getAccountUserList(long companyId, String keywords, String imagePath) throws PortalException {
        List<AccountUser> accountUsers = this._searchUsers(companyId, keywords, imagePath);
        return new AccountUserList(accountUsers, accountUsers.size());
    }

    @GET
    @Path(value="/search-accounts")
    @Produces(value={"application/json"})
    public Response getCommerceAccounts(@QueryParam(value="groupId") long groupId, @QueryParam(value="q") String queryString, @QueryParam(value="page") int page, @QueryParam(value="pageSize") int pageSize, @Context UriInfo uriInfo, @Context ThemeDisplay themeDisplay) {
        AccountList accountList = null;
        themeDisplay.setScopeGroupId(groupId);
        HttpServletRequest httpServletRequest = themeDisplay.getRequest();
        try {
            CommerceContext commerceContext = this._commerceContextFactory.create(this._portal.getCompanyId(httpServletRequest), this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(groupId), this._portal.getUserId(httpServletRequest), 0L, 0L);
            accountList = this.getAccountList(themeDisplay.getUserId(), 0L, commerceContext.getCommerceSiteType(), queryString, page, pageSize, themeDisplay.getPathImage());
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            accountList = new AccountList(StringUtil.split((String)exception.getLocalizedMessage()));
        }
        return this._getResponse(accountList);
    }

    @GET
    @Path(value="/search-accounts/{accountId}/orders/")
    @Produces(value={"application/json"})
    public Response getCommerceOrders(@QueryParam(value="groupId") long groupId, @PathParam(value="accountId") long accountId, @QueryParam(value="q") String queryString, @QueryParam(value="page") int page, @QueryParam(value="pageSize") int pageSize, @Context HttpServletRequest httpServletRequest, @Context ThemeDisplay themeDisplay) {
        themeDisplay.setScopeGroupId(groupId);
        OrderList orderList = null;
        try {
            orderList = this.getOrderList(groupId, accountId, page, pageSize, httpServletRequest);
        }
        catch (Exception exception) {
            orderList = new OrderList(StringUtil.split((String)exception.getLocalizedMessage()));
        }
        return this._getResponse(orderList);
    }

    public OrderList getOrderList(long groupId, long accountId, int page, int pageSize, HttpServletRequest httpServletRequest) throws PortalException {
        List<Order> orders = this._getOrders(groupId, accountId, page, pageSize, httpServletRequest);
        return new OrderList(orders, orders.size());
    }

    @GET
    @Path(value="/search-organizations")
    @Produces(value={"application/json"})
    public Response searchOrganizations(@QueryParam(value="q") String queryString, @Context ThemeDisplay themeDisplay) {
        AccountOrganizationList accountOrganizationList = null;
        try {
            accountOrganizationList = this.getAccountOrganizationList(themeDisplay.getCompanyId(), queryString, themeDisplay.getPathImage());
        }
        catch (Exception exception) {
            accountOrganizationList = new AccountOrganizationList(StringUtil.split((String)exception.getLocalizedMessage()));
        }
        return this._getResponse(accountOrganizationList);
    }

    @GET
    @Path(value="/search-users")
    @Produces(value={"application/json"})
    public Response searchUsers(@QueryParam(value="q") String queryString, @Context ThemeDisplay themeDisplay) {
        AccountUserList accountUserList = null;
        try {
            accountUserList = this.getAccountUserList(themeDisplay.getCompanyId(), queryString, themeDisplay.getPathImage());
        }
        catch (Exception exception) {
            accountUserList = new AccountUserList(StringUtil.split((String)exception.getLocalizedMessage()));
        }
        return this._getResponse(accountUserList);
    }

    @Path(value="/set-current-account")
    @POST
    @Produces(value={"application/json"})
    public Response setCurrentAccount(@QueryParam(value="groupId") long groupId, @FormParam(value="accountId") long accountId, @Context HttpServletRequest httpServletRequest) {
        try {
            this._commerceAccountHelper.setCurrentCommerceAccount(httpServletRequest, this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(groupId), accountId);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            Response.ResponseBuilder responseBuilder = Response.serverError();
            return responseBuilder.build();
        }
        return Response.ok().build();
    }

    private List<Account> _getAccounts(long userId, long parentAccountId, int commerceSiteType, String keywords, int page, int pageSize, String imagePath) throws PortalException {
        ArrayList<Account> accounts = new ArrayList<Account>();
        int start = (page - 1) * pageSize;
        int end = page * pageSize;
        List userAccountEntries = this._accountEntryLocalService.getUserAccountEntries(userId, Long.valueOf(parentAccountId), keywords, this._commerceAccountHelper.toAccountEntryTypes(commerceSiteType), this._commerceAccountHelper.toAccountEntryStatus(Boolean.valueOf(true)), start, end);
        for (AccountEntry accountEntry : userAccountEntries) {
            accounts.add(new Account(String.valueOf(accountEntry.getAccountEntryId()), accountEntry.getName(), this._getLogoThumbnailSrc(accountEntry.getLogoId(), imagePath)));
        }
        return accounts;
    }

    private int _getAccountsCount(long userId, Long parentAccountId, int commerceSiteType, String keywords) throws PortalException {
        return this._accountEntryLocalService.getUserAccountEntriesCount(userId, parentAccountId, keywords, this._commerceAccountHelper.toAccountEntryTypes(commerceSiteType), this._commerceAccountHelper.toAccountEntryStatus(Boolean.valueOf(true)));
    }

    private String _getLogoThumbnailSrc(long logoId, String imagePath) {
        return StringBundler.concat((Object[])new Object[]{imagePath, "/organization_logo?img_id=", logoId, "&t=", this._webServerServletToken.getToken(logoId)});
    }

    private String _getOrderLinkURL(long groupId, long commerceOrderId, HttpServletRequest httpServletRequest) throws PortalException {
        long plid = this._portal.getPlidFromPortletId(groupId, "com_liferay_commerce_order_content_web_internal_portlet_CommerceOpenOrderContentPortlet");
        LiferayPortletURL editURL = PortletURLFactoryUtil.create((HttpServletRequest)this._portal.getOriginalServletRequest(httpServletRequest), (String)"com_liferay_commerce_order_content_web_internal_portlet_CommerceOpenOrderContentPortlet", (long)plid, (String)"ACTION_PHASE");
        editURL.setParameter("javax.portlet.action", "/commerce_open_order_content/edit_commerce_order");
        editURL.setParameter("cmd", "setCurrent");
        editURL.setParameter("commerceOrderId", String.valueOf(commerceOrderId));
        return editURL.toString();
    }

    private List<Order> _getOrders(long groupId, long commerceAccountId, int page, int pageSize, HttpServletRequest httpServletRequest) throws PortalException {
        ArrayList<Order> orders = new ArrayList<Order>();
        int start = (page - 1) * pageSize;
        int end = page * pageSize;
        long commerceChannelGroupId = this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(groupId);
        List userCommerceOrders = this._commerceOrderService.getPendingCommerceOrders(commerceChannelGroupId, commerceAccountId, "", start, end);
        for (CommerceOrder commerceOrder : userCommerceOrders) {
            Date modifiedDate = commerceOrder.getModifiedDate();
            String modifiedDateTimeDescription = this._language.getTimeDescription(httpServletRequest, System.currentTimeMillis() - modifiedDate.getTime(), true);
            orders.add(new Order(commerceOrder.getCommerceOrderId(), commerceOrder.getCommerceAccountId(), commerceOrder.getCommerceAccountName(), commerceOrder.getPurchaseOrderNumber(), this._language.format(httpServletRequest, "x-ago", (Object)modifiedDateTimeDescription), WorkflowConstants.getStatusLabel((int)commerceOrder.getStatus()), this._getOrderLinkURL(groupId, commerceOrder.getCommerceOrderId(), httpServletRequest)));
        }
        return orders;
    }

    private Response _getResponse(Object object) {
        if (object == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            String json = _OBJECT_MAPPER.writeValueAsString(object);
            return Response.ok((Object)json, (String)"application/json").build();
        }
        catch (JsonProcessingException jsonProcessingException) {
            _log.error((Throwable)jsonProcessingException);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    private String _getUserPortraitSrc(User user, String imagePath) {
        return StringBundler.concat((Object[])new Object[]{imagePath, "/user_portrait?screenName=", user.getScreenName(), "&amp;companyId=", user.getCompanyId()});
    }

    private List<AccountOrganization> _searchOrganizations(long companyId, String keywords, String imagePath) throws PortalException {
        ArrayList<AccountOrganization> accountOrganizations = new ArrayList<AccountOrganization>();
        BaseModelSearchResult baseModelSearchResult = this._organizationLocalService.searchOrganizations(companyId, -1L, keywords, null, 0, 10, SortFactoryUtil.create((String)"name", (boolean)false));
        for (Organization organization : baseModelSearchResult.getBaseModels()) {
            accountOrganizations.add(new AccountOrganization(organization.getOrganizationId(), organization.getName(), "", this._getLogoThumbnailSrc(organization.getLogoId(), imagePath)));
        }
        return accountOrganizations;
    }

    private List<AccountUser> _searchUsers(long companyId, String keywords, String imagePath) {
        ArrayList<AccountUser> accountUsers = new ArrayList<AccountUser>();
        List users = this._userLocalService.search(companyId, keywords, 0, null, 0, 10, (OrderByComparator)null);
        for (User user : users) {
            accountUsers.add(new AccountUser(user.getUserId(), user.getFullName(), user.getEmailAddress(), this._getUserPortraitSrc(user, imagePath)));
        }
        return accountUsers;
    }
}

