/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.google.merchant.internal.messaging;

import com.liferay.commerce.google.merchant.internal.configuration.ProductDefinitionConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.google.merchant.internal.configuration.ProductDefinitionConfiguration"}, enabled=false, immediate=true, service={ProductDefinitionMessageListener.class})
public class ProductDefinitionMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(ProductDefinitionMessageListener.class);
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    @Activate
    protected void activate(Map<String, Object> properties) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        ProductDefinitionConfiguration productDefinitionConfiguration = (ProductDefinitionConfiguration)ConfigurableUtil.createConfigurable(ProductDefinitionConfiguration.class, properties);
        TimeUnit timeUnit = TimeUnit.MINUTE;
        try {
            timeUnit = Enum.valueOf(TimeUnit.class, productDefinitionConfiguration.generatorTimeIntervalUnit());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            _log.error((Object)illegalArgumentException, (Throwable)illegalArgumentException);
        }
        String className = clazz.getName();
        Trigger trigger = null;
        String cronExpression = productDefinitionConfiguration.cronExpression();
        if (Validator.isNotNull((String)cronExpression)) {
            try {
                trigger = this._triggerFactory.createTrigger(className, className, null, null, cronExpression);
            }
            catch (RuntimeException runtimeException) {
                _log.error((Object)runtimeException, (Throwable)runtimeException);
            }
        }
        if (trigger == null) {
            trigger = this._triggerFactory.createTrigger(className, className, null, null, productDefinitionConfiguration.generatorTimeInterval(), timeUnit);
        }
        SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(className, trigger);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)schedulerEntry, "liferay/scheduler_dispatch");
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Running " + ProductDefinitionMessageListener.class.getName()));
        }
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }
}

